/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.google.services.firebase.insights.datamodel.PlayTrack;
import com.google.services.firebase.insights.datamodel.Version;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB3\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0003\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0003J7\u0010\u0014\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001c"}, d2={"Lcom/google/services/firebase/insights/datamodel/Version;", "", "buildVersion", "", "displayVersion", "displayName", "tracks", "", "Lcom/google/services/firebase/insights/datamodel/PlayTrack;", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/util/Set;)V", "getBuildVersion", "()Ljava/lang/String;", "getDisplayName", "getDisplayVersion", "getTracks", "()Ljava/util/Set;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "firebase"})
public final class Version {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String buildVersion;
    @NotNull
    private final String displayVersion;
    @NotNull
    private final String displayName;
    @NotNull
    private final Set<PlayTrack> tracks;
    @NotNull
    private static final Version ALL = new Version("", "ALL", "ALL", null, 8, null);

    public Version(@NotNull String buildVersion, @NotNull String displayVersion, @NotNull String displayName, @NotNull Set<? extends PlayTrack> tracks2) {
        Intrinsics.checkNotNullParameter((Object)buildVersion, (String)"buildVersion");
        Intrinsics.checkNotNullParameter((Object)displayVersion, (String)"displayVersion");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter(tracks2, (String)"tracks");
        this.buildVersion = buildVersion;
        this.displayVersion = displayVersion;
        this.displayName = displayName;
        this.tracks = tracks2;
    }

    public /* synthetic */ Version(String string, String string2, String string3, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            string2 = "";
        }
        if ((n & 4) != 0) {
            string3 = "";
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(string, string2, string3, set);
    }

    @NotNull
    public final String getBuildVersion() {
        return this.buildVersion;
    }

    @NotNull
    public final String getDisplayVersion() {
        return this.displayVersion;
    }

    @NotNull
    public final String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public final Set<PlayTrack> getTracks() {
        return this.tracks;
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof Version)) {
            return false;
        }
        return Intrinsics.areEqual((Object)((Version)other).buildVersion, (Object)this.buildVersion) && Intrinsics.areEqual((Object)((Version)other).displayVersion, (Object)this.displayVersion) && Intrinsics.areEqual((Object)((Version)other).displayName, (Object)this.displayName);
    }

    public int hashCode() {
        int result2 = this.buildVersion.hashCode();
        result2 = 31 * result2 + this.displayVersion.hashCode();
        result2 = 31 * result2 + this.displayName.hashCode();
        return result2;
    }

    @NotNull
    public String toString() {
        if (Intrinsics.areEqual((Object)this, (Object)ALL)) {
            return "All app versions";
        }
        return this.displayVersion;
    }

    @NotNull
    public final String component1() {
        return this.buildVersion;
    }

    @NotNull
    public final String component2() {
        return this.displayVersion;
    }

    @NotNull
    public final String component3() {
        return this.displayName;
    }

    @NotNull
    public final Set<PlayTrack> component4() {
        return this.tracks;
    }

    @NotNull
    public final Version copy(@NotNull String buildVersion, @NotNull String displayVersion, @NotNull String displayName, @NotNull Set<? extends PlayTrack> tracks2) {
        Intrinsics.checkNotNullParameter((Object)buildVersion, (String)"buildVersion");
        Intrinsics.checkNotNullParameter((Object)displayVersion, (String)"displayVersion");
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter(tracks2, (String)"tracks");
        return new Version(buildVersion, displayVersion, displayName, tracks2);
    }

    public static /* synthetic */ Version copy$default(Version version, String string, String string2, String string3, Set set, int n, Object object) {
        if ((n & 1) != 0) {
            string = version.buildVersion;
        }
        if ((n & 2) != 0) {
            string2 = version.displayVersion;
        }
        if ((n & 4) != 0) {
            string3 = version.displayName;
        }
        if ((n & 8) != 0) {
            set = version.tracks;
        }
        return version.copy(string, string2, string3, set);
    }

    public Version() {
        this(null, null, null, null, 15, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/insights/datamodel/Version$Companion;", "", "()V", "ALL", "Lcom/google/services/firebase/insights/datamodel/Version;", "getALL", "()Lcom/google/services/firebase/insights/datamodel/Version;", "fromProto", "proto", "Lcom/google/services/firebase/insights/proto/Version;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Version getALL() {
            return ALL;
        }

        @NotNull
        public final Version fromProto(@NotNull com.google.services.firebase.insights.proto.Version proto) {
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            List list = proto.getTracksList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proto.tracksList");
            Set tracks2 = SequencesKt.toSet((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)list), (Function1)fromProto.tracks.1.INSTANCE));
            String string = proto.getBuildVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"proto.buildVersion");
            String string2 = proto.getDisplayVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"proto.displayVersion");
            String string3 = proto.getDisplayName();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"proto.displayName");
            return new Version(string, string2, string3, tracks2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

