/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.google.services.firebase.insights.datamodel.Blames;
import com.google.services.firebase.insights.datamodel.Caption;
import com.google.services.firebase.insights.datamodel.ExceptionStack;
import com.google.services.firebase.insights.datamodel.Frame;
import com.google.services.firebase.insights.datamodel.Stacktrace;
import com.google.services.firebase.insights.proto.Exception;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lcom/google/services/firebase/insights/datamodel/StacktraceGroup;", "", "exceptions", "", "Lcom/google/services/firebase/insights/datamodel/ExceptionStack;", "(Ljava/util/List;)V", "getExceptions", "()Ljava/util/List;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "firebase"})
public final class StacktraceGroup {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<ExceptionStack> exceptions;
    @NotNull
    private static final Regex trampolineFrameRegex = new Regex(".+\\.access\\$\\d+00");

    public StacktraceGroup(@NotNull List<ExceptionStack> exceptions) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        this.exceptions = exceptions;
    }

    public /* synthetic */ StacktraceGroup(List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(list);
    }

    @NotNull
    public final List<ExceptionStack> getExceptions() {
        return this.exceptions;
    }

    @NotNull
    public final List<ExceptionStack> component1() {
        return this.exceptions;
    }

    @NotNull
    public final StacktraceGroup copy(@NotNull List<ExceptionStack> exceptions) {
        Intrinsics.checkNotNullParameter(exceptions, (String)"exceptions");
        return new StacktraceGroup(exceptions);
    }

    public static /* synthetic */ StacktraceGroup copy$default(StacktraceGroup stacktraceGroup, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = stacktraceGroup.exceptions;
        }
        return stacktraceGroup.copy(list);
    }

    @NotNull
    public String toString() {
        return "StacktraceGroup(exceptions=" + this.exceptions + ")";
    }

    public int hashCode() {
        return ((Object)this.exceptions).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof StacktraceGroup)) {
            return false;
        }
        StacktraceGroup stacktraceGroup = (StacktraceGroup)other;
        return Intrinsics.areEqual(this.exceptions, stacktraceGroup.exceptions);
    }

    public StacktraceGroup() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/google/services/firebase/insights/datamodel/StacktraceGroup$Companion;", "", "()V", "trampolineFrameRegex", "Lkotlin/text/Regex;", "fromProto", "Lcom/google/services/firebase/insights/datamodel/StacktraceGroup;", "proto", "", "Lcom/google/services/firebase/insights/proto/Exception;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final StacktraceGroup fromProto(@NotNull List<Exception> proto) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(proto, (String)"proto");
            Iterable $this$map$iv = proto;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string;
                String string2;
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Frame it;
                Collection<Frame> collection;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2;
                void exception;
                Exception exception2 = (Exception)item$iv$iv;
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                String string3 = exception.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"exception.title");
                String string4 = exception.getSubtitle();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"exception.subtitle");
                Caption caption = new Caption(string3, string4);
                Blames blames = exception.getBlamed() ? Blames.BLAMED : Blames.NOT_BLAMED;
                List list = exception.getFramesList();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"exception.framesList");
                Iterable iterable2 = list;
                Blames blames2 = blames;
                Caption caption2 = caption;
                boolean $i$f$map2 = false;
                void var15_15 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    com.google.services.firebase.insights.proto.Frame frame = (com.google.services.firebase.insights.proto.Frame)item$iv$iv2;
                    collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    collection.add(Frame.Companion.fromProto((com.google.services.firebase.insights.proto.Frame)it));
                }
                collection = (List)destination$iv$iv2;
                $this$map$iv2 = collection;
                boolean $i$f$filter = false;
                $this$mapTo$iv$iv2 = $this$filter$iv;
                destination$iv$iv2 = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Frame)element$iv$iv;
                    boolean bl3 = false;
                    if (!(!it.matches(trampolineFrameRegex))) continue;
                    destination$iv$iv2.add(element$iv$iv);
                }
                Collection<Frame> collection3 = collection = (List)destination$iv$iv2;
                Blames blames3 = blames2;
                Caption caption3 = caption2;
                Stacktrace stacktrace = new Stacktrace(caption3, blames3, (List<Frame>)collection3);
                Intrinsics.checkNotNullExpressionValue((Object)exception.getType(), (String)"exception.type");
                Intrinsics.checkNotNullExpressionValue((Object)exception.getExceptionMessage(), (String)"exception.exceptionMessage");
                Stacktrace stacktrace2 = stacktrace;
                collection2.add(new ExceptionStack(stacktrace2, string2, string));
            }
            List list = (List)destination$iv$iv;
            return new StacktraceGroup(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

