/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.google.services.firebase.insights.datamodel.Fatality;
import com.google.services.firebase.insights.datamodel.IssuesKt;
import com.google.services.firebase.insights.datamodel.SignalType;
import com.google.services.firebase.insights.proto.ErrorType;
import com.google.services.firebase.insights.proto.IntervalMetrics;
import com.google.services.firebase.insights.proto.Issue;
import com.google.services.firebase.insights.proto.IssueSignals;
import com.google.services.firebase.insights.proto.ReportGroup;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 72\u00020\u0001:\u00017Bk\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u0003\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\f\u0012\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u0012\u0006\u0010\u0011\u001a\u00020\u0003\u0012\u0006\u0010\u0012\u001a\u00020\f\u00a2\u0006\u0002\u0010\u0013J\t\u0010$\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u00c6\u0003J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\fH\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0007H\u00c6\u0003J\t\u0010+\u001a\u00020\u0003H\u00c6\u0003J\t\u0010,\u001a\u00020\u0003H\u00c6\u0003J\t\u0010-\u001a\u00020\u0003H\u00c6\u0003J\t\u0010.\u001a\u00020\fH\u00c6\u0003J\t\u0010/\u001a\u00020\fH\u00c6\u0003J\u0087\u0001\u00100\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00032\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u00032\b\b\u0002\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\r\u001a\u00020\f2\u000e\b\u0002\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0011\u001a\u00020\u00032\b\b\u0002\u0010\u0012\u001a\u00020\fH\u00c6\u0001J\u0013\u00101\u001a\u0002022\b\u00103\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00104\u001a\u000205H\u00d6\u0001J\t\u00106\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\r\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u0015R\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0019R\u0011\u0010\u0012\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u0015R\u0011\u0010\b\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0019R\u0017\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0019R\u0011\u0010\u0011\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0019\u00a8\u00068"}, d2={"Lcom/google/services/firebase/insights/datamodel/IssueDetails;", "", "id", "", "title", "subtitle", "fatality", "Lcom/google/services/firebase/insights/datamodel/Fatality;", "sampleEvent", "firstSeenVersion", "lastSeenVersion", "impactedDevicesCount", "", "eventsCount", "signals", "", "Lcom/google/services/firebase/insights/datamodel/SignalType;", "uri", "notesCount", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/google/services/firebase/insights/datamodel/Fatality;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;JJLjava/util/Set;Ljava/lang/String;J)V", "getEventsCount", "()J", "getFatality", "()Lcom/google/services/firebase/insights/datamodel/Fatality;", "getFirstSeenVersion", "()Ljava/lang/String;", "getId", "getImpactedDevicesCount", "getLastSeenVersion", "getNotesCount", "getSampleEvent", "getSignals", "()Ljava/util/Set;", "getSubtitle", "getTitle", "getUri", "component1", "component10", "component11", "component12", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "firebase"})
public final class IssueDetails {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String id;
    @NotNull
    private final String title;
    @NotNull
    private final String subtitle;
    @NotNull
    private final Fatality fatality;
    @NotNull
    private final String sampleEvent;
    @NotNull
    private final String firstSeenVersion;
    @NotNull
    private final String lastSeenVersion;
    private final long impactedDevicesCount;
    private final long eventsCount;
    @NotNull
    private final Set<SignalType> signals;
    @NotNull
    private final String uri;
    private final long notesCount;

    public IssueDetails(@NotNull String id, @NotNull String title, @NotNull String subtitle, @NotNull Fatality fatality, @NotNull String sampleEvent, @NotNull String firstSeenVersion, @NotNull String lastSeenVersion, long impactedDevicesCount, long eventsCount, @NotNull Set<? extends SignalType> signals, @NotNull String uri, long notesCount) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)subtitle, (String)"subtitle");
        Intrinsics.checkNotNullParameter((Object)((Object)fatality), (String)"fatality");
        Intrinsics.checkNotNullParameter((Object)sampleEvent, (String)"sampleEvent");
        Intrinsics.checkNotNullParameter((Object)firstSeenVersion, (String)"firstSeenVersion");
        Intrinsics.checkNotNullParameter((Object)lastSeenVersion, (String)"lastSeenVersion");
        Intrinsics.checkNotNullParameter(signals, (String)"signals");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        this.id = id;
        this.title = title;
        this.subtitle = subtitle;
        this.fatality = fatality;
        this.sampleEvent = sampleEvent;
        this.firstSeenVersion = firstSeenVersion;
        this.lastSeenVersion = lastSeenVersion;
        this.impactedDevicesCount = impactedDevicesCount;
        this.eventsCount = eventsCount;
        this.signals = signals;
        this.uri = uri;
        this.notesCount = notesCount;
    }

    @NotNull
    public final String getId() {
        return this.id;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @NotNull
    public final String getSubtitle() {
        return this.subtitle;
    }

    @NotNull
    public final Fatality getFatality() {
        return this.fatality;
    }

    @NotNull
    public final String getSampleEvent() {
        return this.sampleEvent;
    }

    @NotNull
    public final String getFirstSeenVersion() {
        return this.firstSeenVersion;
    }

    @NotNull
    public final String getLastSeenVersion() {
        return this.lastSeenVersion;
    }

    public final long getImpactedDevicesCount() {
        return this.impactedDevicesCount;
    }

    public final long getEventsCount() {
        return this.eventsCount;
    }

    @NotNull
    public final Set<SignalType> getSignals() {
        return this.signals;
    }

    @NotNull
    public final String getUri() {
        return this.uri;
    }

    public final long getNotesCount() {
        return this.notesCount;
    }

    @NotNull
    public final String component1() {
        return this.id;
    }

    @NotNull
    public final String component2() {
        return this.title;
    }

    @NotNull
    public final String component3() {
        return this.subtitle;
    }

    @NotNull
    public final Fatality component4() {
        return this.fatality;
    }

    @NotNull
    public final String component5() {
        return this.sampleEvent;
    }

    @NotNull
    public final String component6() {
        return this.firstSeenVersion;
    }

    @NotNull
    public final String component7() {
        return this.lastSeenVersion;
    }

    public final long component8() {
        return this.impactedDevicesCount;
    }

    public final long component9() {
        return this.eventsCount;
    }

    @NotNull
    public final Set<SignalType> component10() {
        return this.signals;
    }

    @NotNull
    public final String component11() {
        return this.uri;
    }

    public final long component12() {
        return this.notesCount;
    }

    @NotNull
    public final IssueDetails copy(@NotNull String id, @NotNull String title, @NotNull String subtitle, @NotNull Fatality fatality, @NotNull String sampleEvent, @NotNull String firstSeenVersion, @NotNull String lastSeenVersion, long impactedDevicesCount, long eventsCount, @NotNull Set<? extends SignalType> signals, @NotNull String uri, long notesCount) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)subtitle, (String)"subtitle");
        Intrinsics.checkNotNullParameter((Object)((Object)fatality), (String)"fatality");
        Intrinsics.checkNotNullParameter((Object)sampleEvent, (String)"sampleEvent");
        Intrinsics.checkNotNullParameter((Object)firstSeenVersion, (String)"firstSeenVersion");
        Intrinsics.checkNotNullParameter((Object)lastSeenVersion, (String)"lastSeenVersion");
        Intrinsics.checkNotNullParameter(signals, (String)"signals");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return new IssueDetails(id, title, subtitle, fatality, sampleEvent, firstSeenVersion, lastSeenVersion, impactedDevicesCount, eventsCount, signals, uri, notesCount);
    }

    public static /* synthetic */ IssueDetails copy$default(IssueDetails issueDetails, String string, String string2, String string3, Fatality fatality, String string4, String string5, String string6, long l, long l2, Set set, String string7, long l3, int n, Object object) {
        if ((n & 1) != 0) {
            string = issueDetails.id;
        }
        if ((n & 2) != 0) {
            string2 = issueDetails.title;
        }
        if ((n & 4) != 0) {
            string3 = issueDetails.subtitle;
        }
        if ((n & 8) != 0) {
            fatality = issueDetails.fatality;
        }
        if ((n & 0x10) != 0) {
            string4 = issueDetails.sampleEvent;
        }
        if ((n & 0x20) != 0) {
            string5 = issueDetails.firstSeenVersion;
        }
        if ((n & 0x40) != 0) {
            string6 = issueDetails.lastSeenVersion;
        }
        if ((n & 0x80) != 0) {
            l = issueDetails.impactedDevicesCount;
        }
        if ((n & 0x100) != 0) {
            l2 = issueDetails.eventsCount;
        }
        if ((n & 0x200) != 0) {
            set = issueDetails.signals;
        }
        if ((n & 0x400) != 0) {
            string7 = issueDetails.uri;
        }
        if ((n & 0x800) != 0) {
            l3 = issueDetails.notesCount;
        }
        return issueDetails.copy(string, string2, string3, fatality, string4, string5, string6, l, l2, set, string7, l3);
    }

    @NotNull
    public String toString() {
        return "IssueDetails(id=" + this.id + ", title=" + this.title + ", subtitle=" + this.subtitle + ", fatality=" + this.fatality + ", sampleEvent=" + this.sampleEvent + ", firstSeenVersion=" + this.firstSeenVersion + ", lastSeenVersion=" + this.lastSeenVersion + ", impactedDevicesCount=" + this.impactedDevicesCount + ", eventsCount=" + this.eventsCount + ", signals=" + this.signals + ", uri=" + this.uri + ", notesCount=" + this.notesCount + ")";
    }

    public int hashCode() {
        int result2 = this.id.hashCode();
        result2 = result2 * 31 + this.title.hashCode();
        result2 = result2 * 31 + this.subtitle.hashCode();
        result2 = result2 * 31 + this.fatality.hashCode();
        result2 = result2 * 31 + this.sampleEvent.hashCode();
        result2 = result2 * 31 + this.firstSeenVersion.hashCode();
        result2 = result2 * 31 + this.lastSeenVersion.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.impactedDevicesCount);
        result2 = result2 * 31 + Long.hashCode(this.eventsCount);
        result2 = result2 * 31 + ((Object)this.signals).hashCode();
        result2 = result2 * 31 + this.uri.hashCode();
        result2 = result2 * 31 + Long.hashCode(this.notesCount);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IssueDetails)) {
            return false;
        }
        IssueDetails issueDetails = (IssueDetails)other;
        if (!Intrinsics.areEqual((Object)this.id, (Object)issueDetails.id)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.title, (Object)issueDetails.title)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.subtitle, (Object)issueDetails.subtitle)) {
            return false;
        }
        if (this.fatality != issueDetails.fatality) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.sampleEvent, (Object)issueDetails.sampleEvent)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.firstSeenVersion, (Object)issueDetails.firstSeenVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lastSeenVersion, (Object)issueDetails.lastSeenVersion)) {
            return false;
        }
        if (this.impactedDevicesCount != issueDetails.impactedDevicesCount) {
            return false;
        }
        if (this.eventsCount != issueDetails.eventsCount) {
            return false;
        }
        if (!Intrinsics.areEqual(this.signals, issueDetails.signals)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.uri, (Object)issueDetails.uri)) {
            return false;
        }
        return this.notesCount == issueDetails.notesCount;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/services/firebase/insights/datamodel/IssueDetails$Companion;", "", "()V", "fromProto", "Lcom/google/services/firebase/insights/datamodel/IssueDetails;", "proto", "Lcom/google/services/firebase/insights/proto/ReportGroup;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final IssueDetails fromProto(@NotNull ReportGroup proto) {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapNotNull$iv;
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            Issue issue = proto.getIssue();
            List list = proto.getMetricsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proto.metricsList");
            IntervalMetrics metrics = (IntervalMetrics)CollectionsKt.single((List)list);
            String string = issue.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"issue.id");
            String string2 = issue.getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"issue.title");
            String string3 = issue.getSubtitle();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"issue.subtitle");
            ErrorType errorType = issue.getErrorType();
            Intrinsics.checkNotNullExpressionValue((Object)errorType, (String)"issue.errorType");
            Fatality fatality = IssuesKt.toFatality(errorType);
            String string4 = issue.getSampleEvent();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"issue.sampleEvent");
            String string5 = issue.getFirstSeenVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"issue.firstSeenVersion");
            String string6 = issue.getLastSeenVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"issue.lastSeenVersion");
            long l = metrics.getImpactedUsersCount().getValue();
            long l2 = metrics.getEventsCount().getValue();
            List list2 = issue.getSignalsList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"issue.signalsList");
            Iterable iterable = list2;
            long l3 = l2;
            long l4 = l;
            String string7 = string6;
            String string8 = string5;
            String string9 = string4;
            Fatality fatality2 = fatality;
            String string10 = string3;
            String string11 = string2;
            String string12 = string;
            boolean $i$f$mapNotNull = false;
            void var6_15 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                SignalType it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IssueSignals it = (IssueSignals)element$iv$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (SignalType.Companion.fromProto(it) == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List list3 = (List)destination$iv$iv;
            Set set = CollectionsKt.toSet((Iterable)list3);
            String string13 = issue.getUri();
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"issue.uri");
            long l5 = issue.getNotesCount();
            String string14 = string13;
            Set set2 = set;
            long l6 = l3;
            long l7 = l4;
            String string15 = string7;
            String string16 = string8;
            String string17 = string9;
            Fatality fatality3 = fatality2;
            String string18 = string10;
            String string19 = string11;
            String string20 = string12;
            return new IssueDetails(string20, string19, string18, fatality3, string17, string16, string15, l7, l6, set2, string14, l5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

