/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.google.services.firebase.insights.client.grpc.ProtobufUtilsKt;
import com.google.services.firebase.insights.proto.Interval;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\u0006\u0010\u0015\u001a\u00020\u0016J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/google/services/firebase/insights/datamodel/Interval;", "", "startTime", "Ljava/time/Instant;", "endTime", "(Ljava/time/Instant;Ljava/time/Instant;)V", "duration", "Ljava/time/Duration;", "getDuration", "()Ljava/time/Duration;", "getEndTime", "()Ljava/time/Instant;", "getStartTime", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toProto", "Lcom/google/services/firebase/insights/proto/Interval;", "toString", "", "toTimeFilter", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsFetchDetails$TimeFilter;", "firebase"})
public final class Interval {
    @NotNull
    private final Instant startTime;
    @NotNull
    private final Instant endTime;

    public Interval(@NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        this.startTime = startTime;
        this.endTime = endTime;
    }

    @NotNull
    public final Instant getStartTime() {
        return this.startTime;
    }

    @NotNull
    public final Instant getEndTime() {
        return this.endTime;
    }

    @NotNull
    public final com.google.services.firebase.insights.proto.Interval toProto() {
        Interval.Builder builder;
        Interval.Builder $this$toProto_u24lambda_u2d0 = builder = com.google.services.firebase.insights.proto.Interval.newBuilder();
        boolean bl = false;
        $this$toProto_u24lambda_u2d0.setStartTime(ProtobufUtilsKt.toProtoTimestamp(this.startTime));
        $this$toProto_u24lambda_u2d0.setEndTime(ProtobufUtilsKt.toProtoTimestamp(this.endTime));
        com.google.services.firebase.insights.proto.Interval interval = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)interval, (String)"newBuilder()\n      .appl\u2026()\n      }\n      .build()");
        return interval;
    }

    @NotNull
    public final AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter toTimeFilter() {
        Duration duration = this.getDuration();
        if (duration.compareTo(Duration.of(85L, ChronoUnit.DAYS)) >= 0) {
            return AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter.NINETY_DAYS;
        }
        if (duration.compareTo(Duration.of(55L, ChronoUnit.DAYS)) >= 0) {
            return AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter.SIXTY_DAYS;
        }
        if (duration.compareTo(Duration.of(25L, ChronoUnit.DAYS)) >= 0) {
            return AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter.THIRTY_DAYS;
        }
        if (duration.compareTo(Duration.of(6L, ChronoUnit.DAYS)) >= 0) {
            return AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter.SEVEN_DAYS;
        }
        if (duration.compareTo(Duration.of(20L, ChronoUnit.HOURS)) >= 0) {
            return AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter.TWENTYFOUR_HOURS;
        }
        return AppQualityInsightsUsageEvent.AppQualityInsightsFetchDetails.TimeFilter.UNKNOWN_FILTER;
    }

    @NotNull
    public final Duration getDuration() {
        Duration duration = Duration.between(this.startTime, this.endTime);
        Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"between(startTime, endTime)");
        return duration;
    }

    @NotNull
    public final Instant component1() {
        return this.startTime;
    }

    @NotNull
    public final Instant component2() {
        return this.endTime;
    }

    @NotNull
    public final Interval copy(@NotNull Instant startTime, @NotNull Instant endTime) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        return new Interval(startTime, endTime);
    }

    public static /* synthetic */ Interval copy$default(Interval interval, Instant instant, Instant instant2, int n, Object object) {
        if ((n & 1) != 0) {
            instant = interval.startTime;
        }
        if ((n & 2) != 0) {
            instant2 = interval.endTime;
        }
        return interval.copy(instant, instant2);
    }

    @NotNull
    public String toString() {
        return "Interval(startTime=" + this.startTime + ", endTime=" + this.endTime + ")";
    }

    public int hashCode() {
        int result2 = this.startTime.hashCode();
        result2 = result2 * 31 + this.endTime.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Interval)) {
            return false;
        }
        Interval interval = (Interval)other;
        if (!Intrinsics.areEqual((Object)this.startTime, (Object)interval.startTime)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.endTime, (Object)interval.endTime);
    }
}

