/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.datamodel;

import com.android.tools.idea.protobuf.Timestamp;
import com.google.services.firebase.insights.client.grpc.ProtobufUtilsKt;
import com.google.services.firebase.insights.datamodel.Device;
import com.google.services.firebase.insights.datamodel.EventData;
import com.google.services.firebase.insights.datamodel.OperatingSystemInfo;
import com.google.services.firebase.insights.datamodel.StacktraceGroup;
import com.google.services.firebase.insights.proto.OperatingSystem;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u0019\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/google/services/firebase/insights/datamodel/Event;", "", "eventData", "Lcom/google/services/firebase/insights/datamodel/EventData;", "stacktraceGroup", "Lcom/google/services/firebase/insights/datamodel/StacktraceGroup;", "(Lcom/google/services/firebase/insights/datamodel/EventData;Lcom/google/services/firebase/insights/datamodel/StacktraceGroup;)V", "getEventData", "()Lcom/google/services/firebase/insights/datamodel/EventData;", "getStacktraceGroup", "()Lcom/google/services/firebase/insights/datamodel/StacktraceGroup;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "Companion", "firebase"})
public final class Event {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final EventData eventData;
    @NotNull
    private final StacktraceGroup stacktraceGroup;

    public Event(@NotNull EventData eventData, @NotNull StacktraceGroup stacktraceGroup) {
        Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
        Intrinsics.checkNotNullParameter((Object)stacktraceGroup, (String)"stacktraceGroup");
        this.eventData = eventData;
        this.stacktraceGroup = stacktraceGroup;
    }

    public /* synthetic */ Event(EventData eventData, StacktraceGroup stacktraceGroup, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            eventData = new EventData(null, null, null, 7, null);
        }
        if ((n & 2) != 0) {
            stacktraceGroup = new StacktraceGroup(null, 1, null);
        }
        this(eventData, stacktraceGroup);
    }

    @NotNull
    public final EventData getEventData() {
        return this.eventData;
    }

    @NotNull
    public final StacktraceGroup getStacktraceGroup() {
        return this.stacktraceGroup;
    }

    @NotNull
    public final EventData component1() {
        return this.eventData;
    }

    @NotNull
    public final StacktraceGroup component2() {
        return this.stacktraceGroup;
    }

    @NotNull
    public final Event copy(@NotNull EventData eventData, @NotNull StacktraceGroup stacktraceGroup) {
        Intrinsics.checkNotNullParameter((Object)eventData, (String)"eventData");
        Intrinsics.checkNotNullParameter((Object)stacktraceGroup, (String)"stacktraceGroup");
        return new Event(eventData, stacktraceGroup);
    }

    public static /* synthetic */ Event copy$default(Event event, EventData eventData, StacktraceGroup stacktraceGroup, int n, Object object) {
        if ((n & 1) != 0) {
            eventData = event.eventData;
        }
        if ((n & 2) != 0) {
            stacktraceGroup = event.stacktraceGroup;
        }
        return event.copy(eventData, stacktraceGroup);
    }

    @NotNull
    public String toString() {
        return "Event(eventData=" + this.eventData + ", stacktraceGroup=" + this.stacktraceGroup + ")";
    }

    public int hashCode() {
        int result2 = this.eventData.hashCode();
        result2 = result2 * 31 + this.stacktraceGroup.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Event)) {
            return false;
        }
        Event event = (Event)other;
        if (!Intrinsics.areEqual((Object)this.eventData, (Object)event.eventData)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.stacktraceGroup, (Object)event.stacktraceGroup);
    }

    public Event() {
        this(null, null, 3, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/google/services/firebase/insights/datamodel/Event$Companion;", "", "()V", "fromProto", "Lcom/google/services/firebase/insights/datamodel/Event;", "proto", "Lcom/google/services/firebase/insights/proto/Event;", "firebase"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Event fromProto(@NotNull com.google.services.firebase.insights.proto.Event proto) {
            Intrinsics.checkNotNullParameter((Object)proto, (String)"proto");
            com.google.services.firebase.insights.proto.Device device = proto.getDevice();
            Intrinsics.checkNotNullExpressionValue((Object)device, (String)"proto.device");
            Device device2 = Device.Companion.fromProto(device);
            OperatingSystem operatingSystem = proto.getOperatingSystem();
            Intrinsics.checkNotNullExpressionValue((Object)operatingSystem, (String)"proto.operatingSystem");
            OperatingSystemInfo operatingSystemInfo = OperatingSystemInfo.Companion.fromProto(operatingSystem);
            Timestamp timestamp = proto.getEventTime();
            Intrinsics.checkNotNullExpressionValue((Object)timestamp, (String)"proto.eventTime");
            EventData eventData = new EventData(device2, operatingSystemInfo, ProtobufUtilsKt.toJavaInstant(timestamp));
            List list = proto.getExceptionsList();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"proto.exceptionsList");
            return new Event(eventData, StacktraceGroup.Companion.fromProto(list));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

