/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.client;

import com.google.services.firebase.insights.datamodel.Event;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.IssueDetails;
import com.google.services.firebase.insights.datamodel.IssueState;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\bH\u00c6\u0003J-\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0006\u0010\u0019\u001a\u00020\u001aJ\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001d"}, d2={"Lcom/google/services/firebase/insights/client/IssueDetailsValue;", "", "issueDetails", "Lcom/google/services/firebase/insights/datamodel/IssueDetails;", "sampleEvents", "Ljava/util/SortedSet;", "Lcom/google/services/firebase/insights/datamodel/Event;", "state", "Lcom/google/services/firebase/insights/datamodel/IssueState;", "(Lcom/google/services/firebase/insights/datamodel/IssueDetails;Ljava/util/SortedSet;Lcom/google/services/firebase/insights/datamodel/IssueState;)V", "getIssueDetails", "()Lcom/google/services/firebase/insights/datamodel/IssueDetails;", "getSampleEvents", "()Ljava/util/SortedSet;", "getState", "()Lcom/google/services/firebase/insights/datamodel/IssueState;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toIssue", "Lcom/google/services/firebase/insights/datamodel/Issue;", "toString", "", "firebase"})
final class IssueDetailsValue {
    @NotNull
    private final IssueDetails issueDetails;
    @NotNull
    private final SortedSet<Event> sampleEvents;
    @NotNull
    private final IssueState state;

    public IssueDetailsValue(@NotNull IssueDetails issueDetails, @NotNull SortedSet<Event> sampleEvents, @NotNull IssueState state) {
        Intrinsics.checkNotNullParameter((Object)issueDetails, (String)"issueDetails");
        Intrinsics.checkNotNullParameter(sampleEvents, (String)"sampleEvents");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        this.issueDetails = issueDetails;
        this.sampleEvents = sampleEvents;
        this.state = state;
    }

    @NotNull
    public final IssueDetails getIssueDetails() {
        return this.issueDetails;
    }

    @NotNull
    public final SortedSet<Event> getSampleEvents() {
        return this.sampleEvents;
    }

    @NotNull
    public final IssueState getState() {
        return this.state;
    }

    @NotNull
    public final Issue toIssue() {
        Event event = this.sampleEvents.first();
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"sampleEvents.first()");
        return new Issue(this.issueDetails, event, this.state, false, 8, null);
    }

    @NotNull
    public final IssueDetails component1() {
        return this.issueDetails;
    }

    @NotNull
    public final SortedSet<Event> component2() {
        return this.sampleEvents;
    }

    @NotNull
    public final IssueState component3() {
        return this.state;
    }

    @NotNull
    public final IssueDetailsValue copy(@NotNull IssueDetails issueDetails, @NotNull SortedSet<Event> sampleEvents, @NotNull IssueState state) {
        Intrinsics.checkNotNullParameter((Object)issueDetails, (String)"issueDetails");
        Intrinsics.checkNotNullParameter(sampleEvents, (String)"sampleEvents");
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        return new IssueDetailsValue(issueDetails, sampleEvents, state);
    }

    public static /* synthetic */ IssueDetailsValue copy$default(IssueDetailsValue issueDetailsValue, IssueDetails issueDetails, SortedSet sortedSet, IssueState issueState, int n, Object object) {
        if ((n & 1) != 0) {
            issueDetails = issueDetailsValue.issueDetails;
        }
        if ((n & 2) != 0) {
            sortedSet = issueDetailsValue.sampleEvents;
        }
        if ((n & 4) != 0) {
            issueState = issueDetailsValue.state;
        }
        return issueDetailsValue.copy(issueDetails, sortedSet, issueState);
    }

    @NotNull
    public String toString() {
        return "IssueDetailsValue(issueDetails=" + this.issueDetails + ", sampleEvents=" + this.sampleEvents + ", state=" + this.state + ")";
    }

    public int hashCode() {
        int result2 = this.issueDetails.hashCode();
        result2 = result2 * 31 + this.sampleEvents.hashCode();
        result2 = result2 * 31 + this.state.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IssueDetailsValue)) {
            return false;
        }
        IssueDetailsValue issueDetailsValue = (IssueDetailsValue)other;
        if (!Intrinsics.areEqual((Object)this.issueDetails, (Object)issueDetailsValue.issueDetails)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.sampleEvents, issueDetailsValue.sampleEvents)) {
            return false;
        }
        return this.state == issueDetailsValue.state;
    }
}

