/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.client;

import com.android.tools.idea.flags.StudioFlags;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.services.firebase.insights.FirebaseConnection;
import com.google.services.firebase.insights.client.CacheValue;
import com.google.services.firebase.insights.client.CrashlyticsCache;
import com.google.services.firebase.insights.client.CrashlyticsCacheImpl;
import com.google.services.firebase.insights.client.IssueDetailsValue;
import com.google.services.firebase.insights.client.IssueRequest;
import com.google.services.firebase.insights.datamodel.Event;
import com.google.services.firebase.insights.datamodel.Fatality;
import com.google.services.firebase.insights.datamodel.Interval;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.IssueDetails;
import com.google.services.firebase.insights.datamodel.IssueId;
import com.google.services.firebase.insights.datamodel.IssueState;
import com.google.services.firebase.insights.datamodel.Note;
import com.google.services.firebase.insights.datamodel.NoteId;
import com.google.services.firebase.insights.datamodel.SignalType;
import com.intellij.serviceContainer.NonInjectable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u000f\b\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J(\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u0015\u0012\u0004\u0012\u0002H\u00160\n\"\u0004\b\u0000\u0010\u0015\"\u0004\b\u0001\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J'\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u001dH\u0016\u00f8\u0001\u0000J \u0010!\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001d2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\fH\u0016J\u001c\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n2\u0006\u0010#\u001a\u00020\u000bH\u0002J\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010\u001d2\u0006\u0010%\u001a\u00020\u001bH\u0016J\u001e\u0010&\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dH\u0016J&\u0010(\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\f2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00130\u001dH\u0016J\u0018\u0010*\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000b2\u0006\u0010+\u001a\u00020,H\u0016J \u0010-\u001a\b\u0012\u0004\u0012\u00020\u00130\u001d*\b\u0012\u0004\u0012\u00020\u00130\u001d2\u0006\u0010.\u001a\u00020\u0013H\u0002J\u001a\u0010/\u001a\u000200*\u0002012\f\u00102\u001a\b\u0012\u0004\u0012\u0002030\u001dH\u0002J\u0014\u00104\u001a\u000200*\u00020\b2\u0006\u00105\u001a\u000206H\u0002J\u0014\u00107\u001a\u000200*\u0002012\u0006\u00108\u001a\u000209H\u0002J\u0016\u0010:\u001a\u00020;*\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020\u001eH\u0002J\f\u0010=\u001a\u00020;*\u00020\u001eH\u0002R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\t\u001a\u001a\u0012\u0004\u0012\u00020\u000b\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006>"}, d2={"Lcom/google/services/firebase/insights/client/CrashlyticsCacheImpl;", "Lcom/google/services/firebase/insights/client/CrashlyticsCache;", "()V", "maxIssuesCount", "", "(I)V", "comparator", "Ljava/util/Comparator;", "Lcom/google/services/firebase/insights/datamodel/Event;", "compositeIssuesCache", "Lcom/github/benmanes/caffeine/cache/Cache;", "Lcom/google/services/firebase/insights/FirebaseConnection;", "", "Lcom/google/services/firebase/insights/client/CacheValue;", "addNote", "", "connection", "issueId", "note", "Lcom/google/services/firebase/insights/datamodel/Note;", "createNew", "K", "V", "maximumSize", "", "getEvent", "issueRequest", "Lcom/google/services/firebase/insights/client/IssueRequest;", "getIssues", "", "Lcom/google/services/firebase/insights/datamodel/Issue;", "issueIds", "Lcom/google/services/firebase/insights/datamodel/IssueId;", "getNotes", "getOrCreateIssuesCache", "firebaseConnection", "getTopIssues", "request", "populateIssues", "issues", "populateNotes", "notes", "removeNote", "noteId", "Lcom/google/services/firebase/insights/datamodel/NoteId;", "insertByDecreasingTimestamp", "newNote", "matchErrorType", "", "Lcom/google/services/firebase/insights/datamodel/IssueDetails;", "eventTypes", "Lcom/google/services/firebase/insights/datamodel/Fatality;", "matchInterval", "interval", "Lcom/google/services/firebase/insights/datamodel/Interval;", "matchSignalType", "signal", "Lcom/google/services/firebase/insights/datamodel/SignalType;", "reconcileWith", "Lcom/google/services/firebase/insights/client/IssueDetailsValue;", "issue", "toNewIssueDetailsValue", "firebase"})
public final class CrashlyticsCacheImpl
implements CrashlyticsCache {
    private final int maxIssuesCount;
    @NotNull
    private final Cache<FirebaseConnection, Cache<String, CacheValue>> compositeIssuesCache;
    @NotNull
    private final Comparator<Event> comparator;

    @NonInjectable
    public CrashlyticsCacheImpl(int maxIssuesCount) {
        this.maxIssuesCount = maxIssuesCount;
        this.compositeIssuesCache = this.createNew(20L);
        this.comparator = comparator.1.INSTANCE;
    }

    public CrashlyticsCacheImpl() {
        this(50);
    }

    @Override
    @Nullable
    public List<Issue> getTopIssues(@NotNull IssueRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        if (!((Boolean)StudioFlags.OFFLINE_MODE_SUPPORT_ENABLED.get()).booleanValue()) {
            return null;
        }
        Object object = (Cache)this.compositeIssuesCache.getIfPresent((Object)request.getConnection());
        if (object == null || (object = object.asMap()) == null || (object = object.values()) == null) {
            return null;
        }
        Object allIssues = object;
        Function1[] function1Array = new Function1[]{getTopIssues.2.INSTANCE, getTopIssues.3.INSTANCE};
        return SequencesKt.toList((Sequence)SequencesKt.take((Sequence)SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)allIssues)), (Function1)((Function1)new Function1<CacheValue, Issue>(this, request){
            final /* synthetic */ CrashlyticsCacheImpl this$0;
            final /* synthetic */ IssueRequest $request;
            {
                this.this$0 = $receiver;
                this.$request = $request;
                super(1);
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final Issue invoke(CacheValue it) {
                Object v1;
                IssueDetailsValue cachedIssue;
                block3: {
                    void $this$firstOrNull$iv;
                    IssueDetailsValue issueDetailsValue = it.getIssueDetails();
                    if (issueDetailsValue == null) {
                        return null;
                    }
                    cachedIssue = issueDetailsValue;
                    Iterable iterable = cachedIssue.getSampleEvents();
                    CrashlyticsCacheImpl crashlyticsCacheImpl = this.this$0;
                    IssueRequest issueRequest = this.$request;
                    boolean $i$f$firstOrNull = false;
                    for (T element$iv : $this$firstOrNull$iv) {
                        Event event = (Event)element$iv;
                        boolean bl = false;
                        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"event");
                        if (!CrashlyticsCacheImpl.access$matchInterval(crashlyticsCacheImpl, event, issueRequest.getFilters().getInterval())) continue;
                        v1 = element$iv;
                        break block3;
                    }
                    v1 = null;
                }
                Event event = v1;
                if (event == null) {
                    return null;
                }
                Event matchingEvent = event;
                return CrashlyticsCacheImpl.access$matchErrorType(this.this$0, cachedIssue.getIssueDetails(), this.$request.getFilters().getEventTypes()) && CrashlyticsCacheImpl.access$matchSignalType(this.this$0, cachedIssue.getIssueDetails(), this.$request.getFilters().getSignal()) ? new Issue(cachedIssue.getIssueDetails(), matchingEvent, cachedIssue.getState(), false, 8, null) : (Issue)null;
            }
        })), (Comparator)ComparisonsKt.compareBy((Function1[])function1Array)), (Function1)getTopIssues.4.INSTANCE), (int)this.maxIssuesCount));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Issue> getIssues(@NotNull FirebaseConnection connection, @NotNull List<IssueId> issueIds) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(issueIds, (String)"issueIds");
        Cache cache = (Cache)this.compositeIssuesCache.getIfPresent((Object)connection);
        ConcurrentMap concurrentMap = cache != null ? cache.asMap() : null;
        if (concurrentMap == null) {
            return CollectionsKt.emptyList();
        }
        ConcurrentMap cache2 = concurrentMap;
        Iterable $this$mapNotNull$iv = issueIds;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Issue issue;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = ((IssueId)element$iv$iv).unbox-impl();
            boolean bl2 = false;
            if ((CacheValue)cache2.get(it) != null) {
                CacheValue cacheValue;
                boolean bl3 = false;
                IssueDetailsValue issueDetailsValue = cacheValue.getIssueDetails();
                issue = issueDetailsValue != null ? issueDetailsValue.toIssue() : null;
            } else {
                issue = null;
            }
            if (issue == null) continue;
            Issue it$iv$iv = issue;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void populateIssues(@NotNull FirebaseConnection connection, @NotNull List<Issue> issues2) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter(issues2, (String)"issues");
        if (!((Boolean)StudioFlags.OFFLINE_MODE_SUPPORT_ENABLED.get()).booleanValue()) {
            return;
        }
        ConcurrentMap issuesCache = this.getOrCreateIssuesCache(connection).asMap();
        Iterable $this$forEach$iv = issues2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Issue newIssue = (Issue)element$iv;
            boolean bl = false;
            issuesCache.compute(newIssue.getIssueDetails().getId(), new BiFunction(this, newIssue){
                final /* synthetic */ CrashlyticsCacheImpl this$0;
                final /* synthetic */ Issue $newIssue;
                {
                    this.this$0 = $receiver;
                    this.$newIssue = $newIssue;
                }

                @Nullable
                public final CacheValue apply(String string, @Nullable CacheValue oldValue) {
                    CacheValue cacheValue = oldValue;
                    CacheValue cacheValue2 = oldValue;
                    return new CacheValue(CrashlyticsCacheImpl.access$reconcileWith(this.this$0, cacheValue != null ? cacheValue.getIssueDetails() : null, this.$newIssue), cacheValue2 != null ? cacheValue2.getNotes() : null);
                }
            });
        }
    }

    @Override
    @Nullable
    public Event getEvent(@NotNull IssueRequest issueRequest, @NotNull String issueId) {
        Object v0;
        block3: {
            SortedSet<Event> sortedSet;
            Object object;
            CacheValue cacheValue;
            Intrinsics.checkNotNullParameter((Object)issueRequest, (String)"issueRequest");
            Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
            if (!((Boolean)StudioFlags.OFFLINE_MODE_SUPPORT_ENABLED.get()).booleanValue()) {
                return null;
            }
            Cache cache = (Cache)this.compositeIssuesCache.getIfPresent((Object)issueRequest.getConnection());
            if (cache == null || (cacheValue = (CacheValue)cache.getIfPresent((Object)issueId)) == null || (object = cacheValue.getIssueDetails()) == null || (sortedSet = ((IssueDetailsValue)object).getSampleEvents()) == null) {
                return null;
            }
            SortedSet<Event> cachedEvents = sortedSet;
            Iterable $this$firstOrNull$iv = cachedEvents;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Event it = (Event)element$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                if (!this.matchInterval(it, issueRequest.getFilters().getInterval())) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        return v0;
    }

    @Override
    @Nullable
    public List<Note> getNotes(@NotNull FirebaseConnection connection, @NotNull String issueId) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        if (!((Boolean)StudioFlags.OFFLINE_MODE_SUPPORT_ENABLED.get()).booleanValue()) {
            return null;
        }
        Object object = (Cache)this.compositeIssuesCache.getIfPresent((Object)connection);
        return object != null && (object = (CacheValue)object.getIfPresent((Object)issueId)) != null ? ((CacheValue)object).getNotes() : null;
    }

    @Override
    public void populateNotes(@NotNull FirebaseConnection connection, @NotNull String issueId, @NotNull List<Note> notes) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        Intrinsics.checkNotNullParameter(notes, (String)"notes");
        if (!((Boolean)StudioFlags.OFFLINE_MODE_SUPPORT_ENABLED.get()).booleanValue()) {
            return;
        }
        ConcurrentMap issuesCache = this.getOrCreateIssuesCache(connection).asMap();
        issuesCache.compute(issueId, new BiFunction(notes){
            final /* synthetic */ List<Note> $notes;
            {
                this.$notes = $notes;
            }

            @Nullable
            public final CacheValue apply(String string, @Nullable CacheValue oldValue) {
                if (oldValue == null) {
                    boolean bl = false;
                    String string2 = "Notes are always populated after the issues.";
                    throw new IllegalStateException(string2.toString());
                }
                return CacheValue.copy$default(oldValue, null, this.$notes, 1, null);
            }
        });
    }

    @Override
    public void addNote(@NotNull FirebaseConnection connection, @NotNull String issueId, @NotNull Note note) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)issueId, (String)"issueId");
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        ConcurrentMap issuesCache = this.getOrCreateIssuesCache(connection).asMap();
        issuesCache.compute(issueId, new BiFunction(this, note){
            final /* synthetic */ CrashlyticsCacheImpl this$0;
            final /* synthetic */ Note $note;
            {
                this.this$0 = $receiver;
                this.$note = $note;
            }

            @Nullable
            public final CacheValue apply(String string, @Nullable CacheValue oldValue) {
                List list;
                if (oldValue == null) {
                    boolean bl = false;
                    String string2 = "Issue should exist for this note by this time.";
                    throw new IllegalStateException(string2.toString());
                }
                List<Note> list2 = oldValue.getNotes();
                return CacheValue.copy$default(oldValue, null, list2 != null && (list = CrashlyticsCacheImpl.access$insertByDecreasingTimestamp(this.this$0, list2, this.$note)) != null ? list : CollectionsKt.listOf((Object)this.$note), 1, null);
            }
        });
    }

    @Override
    public void removeNote(@NotNull FirebaseConnection connection, @NotNull NoteId noteId) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)noteId, (String)"noteId");
        ConcurrentMap issuesCache = this.getOrCreateIssuesCache(connection).asMap();
        issuesCache.compute(noteId.getIssueId-s7_ZKiI(), new BiFunction(noteId){
            final /* synthetic */ NoteId $noteId;
            {
                this.$noteId = $noteId;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public final CacheValue apply(String string, @Nullable CacheValue oldValue) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                if (oldValue == null) {
                    boolean $i$a$-checkNotNull-CrashlyticsCacheImpl$removeNote$1$32 = false;
                    String $i$a$-checkNotNull-CrashlyticsCacheImpl$removeNote$1$32 = "Issue should exist for this note by this time.";
                    throw new IllegalStateException($i$a$-checkNotNull-CrashlyticsCacheImpl$removeNote$1$32.toString());
                }
                if (oldValue.getNotes() == null) {
                    boolean bl = false;
                    String string2 = "Notes should already be populated.";
                    throw new IllegalStateException(string2.toString());
                }
                Iterable $i$a$-checkNotNull-CrashlyticsCacheImpl$removeNote$1$32 = oldValue.getNotes();
                NoteId noteId = this.$noteId;
                IssueDetailsValue issueDetailsValue = null;
                CacheValue cacheValue = oldValue;
                boolean $i$f$filterNot = false;
                void var6_12 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterNotTo = false;
                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                    Note it = (Note)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.getId().getNoteId(), (Object)noteId.getNoteId())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List list = (List)destination$iv$iv;
                return CacheValue.copy$default(cacheValue, issueDetailsValue, list, 1, null);
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    private final IssueDetailsValue reconcileWith(IssueDetailsValue $this$reconcileWith, Issue issue) {
        void $this$reconcileWith_u24lambda_u2d4;
        IssueDetails issueDetails;
        Object object;
        if ($this$reconcileWith == null) {
            return this.toNewIssueDetailsValue(issue);
        }
        if (issue.getIssueDetails().getEventsCount() < $this$reconcileWith.getIssueDetails().getEventsCount()) {
            object = issue.getIssueDetails();
            long l = $this$reconcileWith.getIssueDetails().getEventsCount();
            long l2 = $this$reconcileWith.getIssueDetails().getImpactedDevicesCount();
            issueDetails = IssueDetails.copy$default((IssueDetails)object, null, null, null, null, null, null, null, l2, l, null, null, 0L, 3711, null);
        } else {
            issueDetails = issue.getIssueDetails();
        }
        Object object2 = object = $this$reconcileWith.getSampleEvents();
        IssueDetails issueDetails2 = issueDetails;
        boolean bl = false;
        $this$reconcileWith_u24lambda_u2d4.add(issue.getSampleEvent());
        IssueState issueState = issue.getState();
        Object object3 = object;
        IssueDetails issueDetails3 = issueDetails2;
        return new IssueDetailsValue(issueDetails3, (SortedSet<Event>)object3, issueState);
    }

    /*
     * WARNING - void declaration
     */
    private final List<Note> insertByDecreasingTimestamp(List<Note> $this$insertByDecreasingTimestamp, Note newNote) {
        List result2 = CollectionsKt.toMutableList((Collection)$this$insertByDecreasingTimestamp);
        Iterable $this$forEachIndexed$iv = $this$insertByDecreasingTimestamp;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void note;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Note note2 = (Note)item$iv;
            int index = n;
            boolean bl = false;
            if (!note.getTimestamp().isBefore(newNote.getTimestamp())) continue;
            result2.add(index, newNote);
            return result2;
        }
        result2.add(newNote);
        return result2;
    }

    /*
     * WARNING - void declaration
     */
    private final IssueDetailsValue toNewIssueDetailsValue(Issue $this$toNewIssueDetailsValue) {
        void $this$toNewIssueDetailsValue_u24lambda_u2d6;
        TreeSet<Event> treeSet;
        TreeSet<Event> treeSet2 = treeSet = new TreeSet<Event>(this.comparator);
        IssueDetails issueDetails = $this$toNewIssueDetailsValue.getIssueDetails();
        boolean bl = false;
        $this$toNewIssueDetailsValue_u24lambda_u2d6.add($this$toNewIssueDetailsValue.getSampleEvent());
        IssueState issueState = $this$toNewIssueDetailsValue.getState();
        SortedSet sortedSet = treeSet;
        IssueDetails issueDetails2 = issueDetails;
        return new IssueDetailsValue(issueDetails2, sortedSet, issueState);
    }

    private final boolean matchInterval(Event $this$matchInterval, Interval interval) {
        Instant time = $this$matchInterval.getEventData().getEventTime();
        return time.isAfter(interval.getStartTime()) && time.isBefore(interval.getEndTime());
    }

    private final boolean matchErrorType(IssueDetails $this$matchErrorType, List<? extends Fatality> eventTypes) {
        return eventTypes.contains((Object)$this$matchErrorType.getFatality());
    }

    private final boolean matchSignalType(IssueDetails $this$matchSignalType, SignalType signal) {
        return $this$matchSignalType.getSignals().contains((Object)signal) || signal == SignalType.SIGNAL_UNSPECIFIED;
    }

    private final Cache<String, CacheValue> getOrCreateIssuesCache(FirebaseConnection firebaseConnection) {
        Object object = this.compositeIssuesCache.get((Object)firebaseConnection, new Function(this){
            final /* synthetic */ CrashlyticsCacheImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public final Cache<String, CacheValue> apply(FirebaseConnection it) {
                return CrashlyticsCacheImpl.access$createNew(this.this$0, 1000L);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"private fun getOrCreateI\u2026IMUM_ISSUES_CACHE_SIZE) }");
        return (Cache)object;
    }

    private final <K, V> Cache<K, V> createNew(long maximumSize) {
        Cache cache = Caffeine.newBuilder().maximumSize(maximumSize).build();
        Intrinsics.checkNotNullExpressionValue((Object)cache, (String)"newBuilder().maximumSize(maximumSize).build()");
        return cache;
    }

    public static final /* synthetic */ boolean access$matchErrorType(CrashlyticsCacheImpl $this, IssueDetails $receiver, List eventTypes) {
        return $this.matchErrorType($receiver, eventTypes);
    }

    public static final /* synthetic */ boolean access$matchSignalType(CrashlyticsCacheImpl $this, IssueDetails $receiver, SignalType signal) {
        return $this.matchSignalType($receiver, signal);
    }

    public static final /* synthetic */ boolean access$matchInterval(CrashlyticsCacheImpl $this, Event $receiver, Interval interval) {
        return $this.matchInterval($receiver, interval);
    }

    public static final /* synthetic */ List access$insertByDecreasingTimestamp(CrashlyticsCacheImpl $this, List $receiver, Note newNote) {
        return $this.insertByDecreasingTimestamp($receiver, newNote);
    }

    public static final /* synthetic */ Cache access$createNew(CrashlyticsCacheImpl $this, long maximumSize) {
        return $this.createNew(maximumSize);
    }

    public static final /* synthetic */ IssueDetailsValue access$reconcileWith(CrashlyticsCacheImpl $this, IssueDetailsValue $receiver, Issue issue) {
        return $this.reconcileWith($receiver, issue);
    }
}

