/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.analysis;

import com.google.services.firebase.insights.analysis.Cause;
import com.google.services.firebase.insights.datamodel.Frame;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.intentions.style.inference.InferenceProcessUtilKt;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UArrayAccessExpression;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBinaryExpressionWithType;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UBreakExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCallableReferenceExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UClassInitializer;
import org.jetbrains.uast.UClassLiteralExpression;
import org.jetbrains.uast.UContinueExpression;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UDeclarationsExpression;
import org.jetbrains.uast.UDoWhileExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UEnumConstant;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UExpressionList;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UFile;
import org.jetbrains.uast.UForEachExpression;
import org.jetbrains.uast.UForExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UImportStatement;
import org.jetbrains.uast.ULabeledExpression;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UObjectLiteralExpression;
import org.jetbrains.uast.UParameter;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPostfixExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.USwitchClauseExpression;
import org.jetbrains.uast.USwitchExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UTypeReferenceExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UWhileExpression;
import org.jetbrains.uast.UastCallKind;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a \u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u001a\"\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\"\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002\"\u001b\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001*\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006\u0011"}, d2={"candidateFileNames", "", "", "Lcom/intellij/psi/PsiFile;", "getCandidateFileNames", "(Lcom/intellij/psi/PsiFile;)Ljava/util/Set;", "findMatchingCause", "Lorg/jetbrains/uast/UElement;", "element", "cause", "Lcom/google/services/firebase/insights/analysis/Cause;", "range", "Lcom/intellij/openapi/util/TextRange;", "findMatchingMethodCall", "Lcom/google/services/firebase/insights/analysis/Cause$Frame;", "findMatchingThrow", "Lcom/google/services/firebase/insights/analysis/Cause$Throwable;", "firebase"})
public final class UtilKt {
    @Nullable
    public static final UElement findMatchingCause(@NotNull UElement element, @NotNull Cause cause, @NotNull TextRange range) {
        UElement uElement;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Cause cause2 = cause;
        if (cause2 instanceof Cause.Frame) {
            uElement = UtilKt.findMatchingMethodCall(element, (Cause.Frame)cause, range);
        } else if (cause2 instanceof Cause.Throwable) {
            uElement = UtilKt.findMatchingThrow(element, (Cause.Throwable)cause, range);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uElement;
    }

    private static final UElement findMatchingThrow(UElement element, Cause.Throwable cause, TextRange range) {
        ProgressManager.checkCanceled();
        AtomicReference<UElement> foundChild = new AtomicReference<UElement>();
        element.accept(new UastVisitor(range, cause, foundChild){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ Cause.Throwable $cause;
            final /* synthetic */ AtomicReference<UElement> $foundChild;
            {
                this.$range = $range;
                this.$cause = $cause;
                this.$foundChild = $foundChild;
            }

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            public boolean visitThrowExpression(@NotNull UThrowExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                if (!(psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.intersects(this.$range) : false)) {
                    return false;
                }
                UExpression exception = node.getThrownExpression();
                if (!(exception instanceof UCallExpression)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)((UCallExpression)exception).getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                    UReferenceExpression uReferenceExpression = ((UCallExpression)exception).getClassReference();
                    PsiElement psiElement2 = uReferenceExpression != null ? uReferenceExpression.resolve() : null;
                    PsiClass psiClass = psiElement2 instanceof PsiClass ? (PsiClass)psiElement2 : null;
                    if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)this.$cause.getExceptionType())) {
                        this.$foundChild.set((UElement)node);
                        return true;
                    }
                }
                PsiMethod psiMethod = ((UCallExpression)exception).resolve();
                PsiClass psiClass = InferenceProcessUtilKt.resolve((PsiType)(psiMethod != null ? psiMethod.getReturnType() : null));
                if (Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)this.$cause.getExceptionType())) {
                    this.$foundChild.set((UElement)node);
                    return true;
                }
                return false;
            }

            public void afterVisitAnnotation(@NotNull UAnnotation node) {
                UastVisitor.DefaultImpls.afterVisitAnnotation((UastVisitor)this, (UAnnotation)node);
            }

            public void afterVisitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                UastVisitor.DefaultImpls.afterVisitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
            }

            public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
                UastVisitor.DefaultImpls.afterVisitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
            }

            public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                UastVisitor.DefaultImpls.afterVisitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
            }

            public void afterVisitBlockExpression(@NotNull UBlockExpression node) {
                UastVisitor.DefaultImpls.afterVisitBlockExpression((UastVisitor)this, (UBlockExpression)node);
            }

            public void afterVisitBreakExpression(@NotNull UBreakExpression node) {
                UastVisitor.DefaultImpls.afterVisitBreakExpression((UastVisitor)this, (UBreakExpression)node);
            }

            public void afterVisitCallExpression(@NotNull UCallExpression node) {
                UastVisitor.DefaultImpls.afterVisitCallExpression((UastVisitor)this, (UCallExpression)node);
            }

            public void afterVisitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
            }

            public void afterVisitCatchClause(@NotNull UCatchClause node) {
                UastVisitor.DefaultImpls.afterVisitCatchClause((UastVisitor)this, (UCatchClause)node);
            }

            public void afterVisitClass(@NotNull UClass node) {
                UastVisitor.DefaultImpls.afterVisitClass((UastVisitor)this, (UClass)node);
            }

            public void afterVisitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                UastVisitor.DefaultImpls.afterVisitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
            }

            public void afterVisitContinueExpression(@NotNull UContinueExpression node) {
                UastVisitor.DefaultImpls.afterVisitContinueExpression((UastVisitor)this, (UContinueExpression)node);
            }

            public void afterVisitDeclaration(@NotNull UDeclaration node) {
                UastVisitor.DefaultImpls.afterVisitDeclaration((UastVisitor)this, (UDeclaration)node);
            }

            public void afterVisitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                UastVisitor.DefaultImpls.afterVisitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
            }

            public void afterVisitDoWhileExpression(@NotNull UDoWhileExpression node) {
                UastVisitor.DefaultImpls.afterVisitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
            }

            public void afterVisitElement(@NotNull UElement node) {
                UastVisitor.DefaultImpls.afterVisitElement((UastVisitor)this, (UElement)node);
            }

            public void afterVisitEnumConstant(@NotNull UEnumConstant node) {
                UastVisitor.DefaultImpls.afterVisitEnumConstant((UastVisitor)this, (UEnumConstant)node);
            }

            public void afterVisitExpression(@NotNull UExpression node) {
                UastVisitor.DefaultImpls.afterVisitExpression((UastVisitor)this, (UExpression)node);
            }

            public void afterVisitExpressionList(@NotNull UExpressionList node) {
                UastVisitor.DefaultImpls.afterVisitExpressionList((UastVisitor)this, (UExpressionList)node);
            }

            public void afterVisitField(@NotNull UField node) {
                UastVisitor.DefaultImpls.afterVisitField((UastVisitor)this, (UField)node);
            }

            public void afterVisitFile(@NotNull UFile node) {
                UastVisitor.DefaultImpls.afterVisitFile((UastVisitor)this, (UFile)node);
            }

            public void afterVisitForEachExpression(@NotNull UForEachExpression node) {
                UastVisitor.DefaultImpls.afterVisitForEachExpression((UastVisitor)this, (UForEachExpression)node);
            }

            public void afterVisitForExpression(@NotNull UForExpression node) {
                UastVisitor.DefaultImpls.afterVisitForExpression((UastVisitor)this, (UForExpression)node);
            }

            public void afterVisitIfExpression(@NotNull UIfExpression node) {
                UastVisitor.DefaultImpls.afterVisitIfExpression((UastVisitor)this, (UIfExpression)node);
            }

            public void afterVisitImportStatement(@NotNull UImportStatement node) {
                UastVisitor.DefaultImpls.afterVisitImportStatement((UastVisitor)this, (UImportStatement)node);
            }

            public void afterVisitInitializer(@NotNull UClassInitializer node) {
                UastVisitor.DefaultImpls.afterVisitInitializer((UastVisitor)this, (UClassInitializer)node);
            }

            public void afterVisitLabeledExpression(@NotNull ULabeledExpression node) {
                UastVisitor.DefaultImpls.afterVisitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
            }

            public void afterVisitLambdaExpression(@NotNull ULambdaExpression node) {
                UastVisitor.DefaultImpls.afterVisitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
            }

            public void afterVisitLiteralExpression(@NotNull ULiteralExpression node) {
                UastVisitor.DefaultImpls.afterVisitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
            }

            public void afterVisitLocalVariable(@NotNull ULocalVariable node) {
                UastVisitor.DefaultImpls.afterVisitLocalVariable((UastVisitor)this, (ULocalVariable)node);
            }

            public void afterVisitMethod(@NotNull UMethod node) {
                UastVisitor.DefaultImpls.afterVisitMethod((UastVisitor)this, (UMethod)node);
            }

            public void afterVisitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                UastVisitor.DefaultImpls.afterVisitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
            }

            public void afterVisitParameter(@NotNull UParameter node) {
                UastVisitor.DefaultImpls.afterVisitParameter((UastVisitor)this, (UParameter)node);
            }

            public void afterVisitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                UastVisitor.DefaultImpls.afterVisitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
            }

            public void afterVisitPolyadicExpression(@NotNull UPolyadicExpression node) {
                UastVisitor.DefaultImpls.afterVisitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
            }

            public void afterVisitPostfixExpression(@NotNull UPostfixExpression node) {
                UastVisitor.DefaultImpls.afterVisitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
            }

            public void afterVisitPrefixExpression(@NotNull UPrefixExpression node) {
                UastVisitor.DefaultImpls.afterVisitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
            }

            public void afterVisitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
            }

            public void afterVisitReturnExpression(@NotNull UReturnExpression node) {
                UastVisitor.DefaultImpls.afterVisitReturnExpression((UastVisitor)this, (UReturnExpression)node);
            }

            public void afterVisitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
            }

            public void afterVisitSuperExpression(@NotNull USuperExpression node) {
                UastVisitor.DefaultImpls.afterVisitSuperExpression((UastVisitor)this, (USuperExpression)node);
            }

            public void afterVisitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                UastVisitor.DefaultImpls.afterVisitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
            }

            public void afterVisitSwitchExpression(@NotNull USwitchExpression node) {
                UastVisitor.DefaultImpls.afterVisitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
            }

            public void afterVisitThisExpression(@NotNull UThisExpression node) {
                UastVisitor.DefaultImpls.afterVisitThisExpression((UastVisitor)this, (UThisExpression)node);
            }

            public void afterVisitThrowExpression(@NotNull UThrowExpression node) {
                UastVisitor.DefaultImpls.afterVisitThrowExpression((UastVisitor)this, (UThrowExpression)node);
            }

            public void afterVisitTryExpression(@NotNull UTryExpression node) {
                UastVisitor.DefaultImpls.afterVisitTryExpression((UastVisitor)this, (UTryExpression)node);
            }

            public void afterVisitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
            }

            public void afterVisitUnaryExpression(@NotNull UUnaryExpression node) {
                UastVisitor.DefaultImpls.afterVisitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
            }

            public void afterVisitVariable(@NotNull UVariable node) {
                UastVisitor.DefaultImpls.afterVisitVariable((UastVisitor)this, (UVariable)node);
            }

            public void afterVisitWhileExpression(@NotNull UWhileExpression node) {
                UastVisitor.DefaultImpls.afterVisitWhileExpression((UastVisitor)this, (UWhileExpression)node);
            }

            public boolean visitAnnotation(@NotNull UAnnotation node) {
                return UastVisitor.DefaultImpls.visitAnnotation((UastVisitor)this, (UAnnotation)node);
            }

            public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                return UastVisitor.DefaultImpls.visitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
            }

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                return UastVisitor.DefaultImpls.visitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
            }

            public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                return UastVisitor.DefaultImpls.visitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
            }

            public boolean visitBlockExpression(@NotNull UBlockExpression node) {
                return UastVisitor.DefaultImpls.visitBlockExpression((UastVisitor)this, (UBlockExpression)node);
            }

            public boolean visitBreakExpression(@NotNull UBreakExpression node) {
                return UastVisitor.DefaultImpls.visitBreakExpression((UastVisitor)this, (UBreakExpression)node);
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                return UastVisitor.DefaultImpls.visitCallExpression((UastVisitor)this, (UCallExpression)node);
            }

            public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
            }

            public boolean visitCatchClause(@NotNull UCatchClause node) {
                return UastVisitor.DefaultImpls.visitCatchClause((UastVisitor)this, (UCatchClause)node);
            }

            public boolean visitClass(@NotNull UClass node) {
                return UastVisitor.DefaultImpls.visitClass((UastVisitor)this, (UClass)node);
            }

            public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                return UastVisitor.DefaultImpls.visitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
            }

            public boolean visitContinueExpression(@NotNull UContinueExpression node) {
                return UastVisitor.DefaultImpls.visitContinueExpression((UastVisitor)this, (UContinueExpression)node);
            }

            public boolean visitDeclaration(@NotNull UDeclaration node) {
                return UastVisitor.DefaultImpls.visitDeclaration((UastVisitor)this, (UDeclaration)node);
            }

            public boolean visitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                return UastVisitor.DefaultImpls.visitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
            }

            public boolean visitDoWhileExpression(@NotNull UDoWhileExpression node) {
                return UastVisitor.DefaultImpls.visitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
            }

            public boolean visitEnumConstant(@NotNull UEnumConstant node) {
                return UastVisitor.DefaultImpls.visitEnumConstant((UastVisitor)this, (UEnumConstant)node);
            }

            public boolean visitExpression(@NotNull UExpression node) {
                return UastVisitor.DefaultImpls.visitExpression((UastVisitor)this, (UExpression)node);
            }

            public boolean visitExpressionList(@NotNull UExpressionList node) {
                return UastVisitor.DefaultImpls.visitExpressionList((UastVisitor)this, (UExpressionList)node);
            }

            public boolean visitField(@NotNull UField node) {
                return UastVisitor.DefaultImpls.visitField((UastVisitor)this, (UField)node);
            }

            public boolean visitFile(@NotNull UFile node) {
                return UastVisitor.DefaultImpls.visitFile((UastVisitor)this, (UFile)node);
            }

            public boolean visitForEachExpression(@NotNull UForEachExpression node) {
                return UastVisitor.DefaultImpls.visitForEachExpression((UastVisitor)this, (UForEachExpression)node);
            }

            public boolean visitForExpression(@NotNull UForExpression node) {
                return UastVisitor.DefaultImpls.visitForExpression((UastVisitor)this, (UForExpression)node);
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                return UastVisitor.DefaultImpls.visitIfExpression((UastVisitor)this, (UIfExpression)node);
            }

            public boolean visitImportStatement(@NotNull UImportStatement node) {
                return UastVisitor.DefaultImpls.visitImportStatement((UastVisitor)this, (UImportStatement)node);
            }

            public boolean visitInitializer(@NotNull UClassInitializer node) {
                return UastVisitor.DefaultImpls.visitInitializer((UastVisitor)this, (UClassInitializer)node);
            }

            public boolean visitLabeledExpression(@NotNull ULabeledExpression node) {
                return UastVisitor.DefaultImpls.visitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
            }

            public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                return UastVisitor.DefaultImpls.visitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
            }

            public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                return UastVisitor.DefaultImpls.visitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
            }

            public boolean visitLocalVariable(@NotNull ULocalVariable node) {
                return UastVisitor.DefaultImpls.visitLocalVariable((UastVisitor)this, (ULocalVariable)node);
            }

            public boolean visitMethod(@NotNull UMethod node) {
                return UastVisitor.DefaultImpls.visitMethod((UastVisitor)this, (UMethod)node);
            }

            public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                return UastVisitor.DefaultImpls.visitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
            }

            public boolean visitParameter(@NotNull UParameter node) {
                return UastVisitor.DefaultImpls.visitParameter((UastVisitor)this, (UParameter)node);
            }

            public boolean visitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                return UastVisitor.DefaultImpls.visitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
            }

            public boolean visitPolyadicExpression(@NotNull UPolyadicExpression node) {
                return UastVisitor.DefaultImpls.visitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
            }

            public boolean visitPostfixExpression(@NotNull UPostfixExpression node) {
                return UastVisitor.DefaultImpls.visitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
            }

            public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                return UastVisitor.DefaultImpls.visitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
            }

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
            }

            public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                return UastVisitor.DefaultImpls.visitReturnExpression((UastVisitor)this, (UReturnExpression)node);
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
            }

            public boolean visitSuperExpression(@NotNull USuperExpression node) {
                return UastVisitor.DefaultImpls.visitSuperExpression((UastVisitor)this, (USuperExpression)node);
            }

            public boolean visitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                return UastVisitor.DefaultImpls.visitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
            }

            public boolean visitSwitchExpression(@NotNull USwitchExpression node) {
                return UastVisitor.DefaultImpls.visitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
            }

            public boolean visitThisExpression(@NotNull UThisExpression node) {
                return UastVisitor.DefaultImpls.visitThisExpression((UastVisitor)this, (UThisExpression)node);
            }

            public boolean visitTryExpression(@NotNull UTryExpression node) {
                return UastVisitor.DefaultImpls.visitTryExpression((UastVisitor)this, (UTryExpression)node);
            }

            public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
            }

            public boolean visitUnaryExpression(@NotNull UUnaryExpression node) {
                return UastVisitor.DefaultImpls.visitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
            }

            public boolean visitVariable(@NotNull UVariable node) {
                return UastVisitor.DefaultImpls.visitVariable((UastVisitor)this, (UVariable)node);
            }

            public boolean visitWhileExpression(@NotNull UWhileExpression node) {
                return UastVisitor.DefaultImpls.visitWhileExpression((UastVisitor)this, (UWhileExpression)node);
            }
        });
        UElement uElement = foundChild.get();
        if (uElement != null) {
            UElement it = uElement;
            boolean bl = false;
            return it;
        }
        UElement $this$getParentOfType$iv = element;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UThrowExpression uThrowExpression = (UThrowExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UThrowExpression.class, (boolean)strict$iv);
        if (uThrowExpression == null) {
            return null;
        }
        return UtilKt.findMatchingThrow((UElement)uThrowExpression, cause, range);
    }

    private static final UElement findMatchingMethodCall(UElement element, Cause.Frame cause, TextRange range) {
        ProgressManager.checkCanceled();
        AtomicReference<UElement> foundChild = new AtomicReference<UElement>();
        element.accept(new UastVisitor(range, cause, foundChild){
            final /* synthetic */ TextRange $range;
            final /* synthetic */ Cause.Frame $cause;
            final /* synthetic */ AtomicReference<UElement> $foundChild;
            {
                this.$range = $range;
                this.$cause = $cause;
                this.$foundChild = $foundChild;
            }

            public boolean visitElement(@NotNull UElement node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                return false;
            }

            public boolean visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                PsiElement psiElement = node.getSourcePsi();
                if (!(psiElement != null && (psiElement = psiElement.getTextRange()) != null ? psiElement.intersects(this.$range) : false)) {
                    return false;
                }
                if (Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.METHOD_CALL) || Intrinsics.areEqual((Object)node.getKind(), (Object)UastCallKind.CONSTRUCTOR_CALL)) {
                    PsiMethod psiMethod = node.resolve();
                    if (psiMethod == null) {
                        return false;
                    }
                    PsiMethod psiMethod2 = psiMethod;
                    Cause.Frame frame = this.$cause;
                    AtomicReference<UElement> atomicReference = this.$foundChild;
                    PsiMethod $this$visitCallExpression_u24lambda_u2d0 = psiMethod2;
                    boolean bl = false;
                    Frame frame2 = frame.getFrame();
                    Object object = $this$visitCallExpression_u24lambda_u2d0.getContainingClass();
                    if (object == null || (object = object.getQualifiedName()) == null) {
                        object = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"containingClass?.qualifiedName ?: \"\"");
                    String string = $this$visitCallExpression_u24lambda_u2d0.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name");
                    if (frame2.matches((String)object, string)) {
                        atomicReference.set((UElement)node);
                        return true;
                    }
                }
                return false;
            }

            public void afterVisitAnnotation(@NotNull UAnnotation node) {
                UastVisitor.DefaultImpls.afterVisitAnnotation((UastVisitor)this, (UAnnotation)node);
            }

            public void afterVisitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                UastVisitor.DefaultImpls.afterVisitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
            }

            public void afterVisitBinaryExpression(@NotNull UBinaryExpression node) {
                UastVisitor.DefaultImpls.afterVisitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
            }

            public void afterVisitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                UastVisitor.DefaultImpls.afterVisitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
            }

            public void afterVisitBlockExpression(@NotNull UBlockExpression node) {
                UastVisitor.DefaultImpls.afterVisitBlockExpression((UastVisitor)this, (UBlockExpression)node);
            }

            public void afterVisitBreakExpression(@NotNull UBreakExpression node) {
                UastVisitor.DefaultImpls.afterVisitBreakExpression((UastVisitor)this, (UBreakExpression)node);
            }

            public void afterVisitCallExpression(@NotNull UCallExpression node) {
                UastVisitor.DefaultImpls.afterVisitCallExpression((UastVisitor)this, (UCallExpression)node);
            }

            public void afterVisitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
            }

            public void afterVisitCatchClause(@NotNull UCatchClause node) {
                UastVisitor.DefaultImpls.afterVisitCatchClause((UastVisitor)this, (UCatchClause)node);
            }

            public void afterVisitClass(@NotNull UClass node) {
                UastVisitor.DefaultImpls.afterVisitClass((UastVisitor)this, (UClass)node);
            }

            public void afterVisitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                UastVisitor.DefaultImpls.afterVisitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
            }

            public void afterVisitContinueExpression(@NotNull UContinueExpression node) {
                UastVisitor.DefaultImpls.afterVisitContinueExpression((UastVisitor)this, (UContinueExpression)node);
            }

            public void afterVisitDeclaration(@NotNull UDeclaration node) {
                UastVisitor.DefaultImpls.afterVisitDeclaration((UastVisitor)this, (UDeclaration)node);
            }

            public void afterVisitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                UastVisitor.DefaultImpls.afterVisitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
            }

            public void afterVisitDoWhileExpression(@NotNull UDoWhileExpression node) {
                UastVisitor.DefaultImpls.afterVisitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
            }

            public void afterVisitElement(@NotNull UElement node) {
                UastVisitor.DefaultImpls.afterVisitElement((UastVisitor)this, (UElement)node);
            }

            public void afterVisitEnumConstant(@NotNull UEnumConstant node) {
                UastVisitor.DefaultImpls.afterVisitEnumConstant((UastVisitor)this, (UEnumConstant)node);
            }

            public void afterVisitExpression(@NotNull UExpression node) {
                UastVisitor.DefaultImpls.afterVisitExpression((UastVisitor)this, (UExpression)node);
            }

            public void afterVisitExpressionList(@NotNull UExpressionList node) {
                UastVisitor.DefaultImpls.afterVisitExpressionList((UastVisitor)this, (UExpressionList)node);
            }

            public void afterVisitField(@NotNull UField node) {
                UastVisitor.DefaultImpls.afterVisitField((UastVisitor)this, (UField)node);
            }

            public void afterVisitFile(@NotNull UFile node) {
                UastVisitor.DefaultImpls.afterVisitFile((UastVisitor)this, (UFile)node);
            }

            public void afterVisitForEachExpression(@NotNull UForEachExpression node) {
                UastVisitor.DefaultImpls.afterVisitForEachExpression((UastVisitor)this, (UForEachExpression)node);
            }

            public void afterVisitForExpression(@NotNull UForExpression node) {
                UastVisitor.DefaultImpls.afterVisitForExpression((UastVisitor)this, (UForExpression)node);
            }

            public void afterVisitIfExpression(@NotNull UIfExpression node) {
                UastVisitor.DefaultImpls.afterVisitIfExpression((UastVisitor)this, (UIfExpression)node);
            }

            public void afterVisitImportStatement(@NotNull UImportStatement node) {
                UastVisitor.DefaultImpls.afterVisitImportStatement((UastVisitor)this, (UImportStatement)node);
            }

            public void afterVisitInitializer(@NotNull UClassInitializer node) {
                UastVisitor.DefaultImpls.afterVisitInitializer((UastVisitor)this, (UClassInitializer)node);
            }

            public void afterVisitLabeledExpression(@NotNull ULabeledExpression node) {
                UastVisitor.DefaultImpls.afterVisitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
            }

            public void afterVisitLambdaExpression(@NotNull ULambdaExpression node) {
                UastVisitor.DefaultImpls.afterVisitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
            }

            public void afterVisitLiteralExpression(@NotNull ULiteralExpression node) {
                UastVisitor.DefaultImpls.afterVisitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
            }

            public void afterVisitLocalVariable(@NotNull ULocalVariable node) {
                UastVisitor.DefaultImpls.afterVisitLocalVariable((UastVisitor)this, (ULocalVariable)node);
            }

            public void afterVisitMethod(@NotNull UMethod node) {
                UastVisitor.DefaultImpls.afterVisitMethod((UastVisitor)this, (UMethod)node);
            }

            public void afterVisitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                UastVisitor.DefaultImpls.afterVisitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
            }

            public void afterVisitParameter(@NotNull UParameter node) {
                UastVisitor.DefaultImpls.afterVisitParameter((UastVisitor)this, (UParameter)node);
            }

            public void afterVisitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                UastVisitor.DefaultImpls.afterVisitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
            }

            public void afterVisitPolyadicExpression(@NotNull UPolyadicExpression node) {
                UastVisitor.DefaultImpls.afterVisitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
            }

            public void afterVisitPostfixExpression(@NotNull UPostfixExpression node) {
                UastVisitor.DefaultImpls.afterVisitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
            }

            public void afterVisitPrefixExpression(@NotNull UPrefixExpression node) {
                UastVisitor.DefaultImpls.afterVisitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
            }

            public void afterVisitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
            }

            public void afterVisitReturnExpression(@NotNull UReturnExpression node) {
                UastVisitor.DefaultImpls.afterVisitReturnExpression((UastVisitor)this, (UReturnExpression)node);
            }

            public void afterVisitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
            }

            public void afterVisitSuperExpression(@NotNull USuperExpression node) {
                UastVisitor.DefaultImpls.afterVisitSuperExpression((UastVisitor)this, (USuperExpression)node);
            }

            public void afterVisitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                UastVisitor.DefaultImpls.afterVisitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
            }

            public void afterVisitSwitchExpression(@NotNull USwitchExpression node) {
                UastVisitor.DefaultImpls.afterVisitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
            }

            public void afterVisitThisExpression(@NotNull UThisExpression node) {
                UastVisitor.DefaultImpls.afterVisitThisExpression((UastVisitor)this, (UThisExpression)node);
            }

            public void afterVisitThrowExpression(@NotNull UThrowExpression node) {
                UastVisitor.DefaultImpls.afterVisitThrowExpression((UastVisitor)this, (UThrowExpression)node);
            }

            public void afterVisitTryExpression(@NotNull UTryExpression node) {
                UastVisitor.DefaultImpls.afterVisitTryExpression((UastVisitor)this, (UTryExpression)node);
            }

            public void afterVisitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                UastVisitor.DefaultImpls.afterVisitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
            }

            public void afterVisitUnaryExpression(@NotNull UUnaryExpression node) {
                UastVisitor.DefaultImpls.afterVisitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
            }

            public void afterVisitVariable(@NotNull UVariable node) {
                UastVisitor.DefaultImpls.afterVisitVariable((UastVisitor)this, (UVariable)node);
            }

            public void afterVisitWhileExpression(@NotNull UWhileExpression node) {
                UastVisitor.DefaultImpls.afterVisitWhileExpression((UastVisitor)this, (UWhileExpression)node);
            }

            public boolean visitAnnotation(@NotNull UAnnotation node) {
                return UastVisitor.DefaultImpls.visitAnnotation((UastVisitor)this, (UAnnotation)node);
            }

            public boolean visitArrayAccessExpression(@NotNull UArrayAccessExpression node) {
                return UastVisitor.DefaultImpls.visitArrayAccessExpression((UastVisitor)this, (UArrayAccessExpression)node);
            }

            public boolean visitBinaryExpression(@NotNull UBinaryExpression node) {
                return UastVisitor.DefaultImpls.visitBinaryExpression((UastVisitor)this, (UBinaryExpression)node);
            }

            public boolean visitBinaryExpressionWithType(@NotNull UBinaryExpressionWithType node) {
                return UastVisitor.DefaultImpls.visitBinaryExpressionWithType((UastVisitor)this, (UBinaryExpressionWithType)node);
            }

            public boolean visitBlockExpression(@NotNull UBlockExpression node) {
                return UastVisitor.DefaultImpls.visitBlockExpression((UastVisitor)this, (UBlockExpression)node);
            }

            public boolean visitBreakExpression(@NotNull UBreakExpression node) {
                return UastVisitor.DefaultImpls.visitBreakExpression((UastVisitor)this, (UBreakExpression)node);
            }

            public boolean visitCallableReferenceExpression(@NotNull UCallableReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitCallableReferenceExpression((UastVisitor)this, (UCallableReferenceExpression)node);
            }

            public boolean visitCatchClause(@NotNull UCatchClause node) {
                return UastVisitor.DefaultImpls.visitCatchClause((UastVisitor)this, (UCatchClause)node);
            }

            public boolean visitClass(@NotNull UClass node) {
                return UastVisitor.DefaultImpls.visitClass((UastVisitor)this, (UClass)node);
            }

            public boolean visitClassLiteralExpression(@NotNull UClassLiteralExpression node) {
                return UastVisitor.DefaultImpls.visitClassLiteralExpression((UastVisitor)this, (UClassLiteralExpression)node);
            }

            public boolean visitContinueExpression(@NotNull UContinueExpression node) {
                return UastVisitor.DefaultImpls.visitContinueExpression((UastVisitor)this, (UContinueExpression)node);
            }

            public boolean visitDeclaration(@NotNull UDeclaration node) {
                return UastVisitor.DefaultImpls.visitDeclaration((UastVisitor)this, (UDeclaration)node);
            }

            public boolean visitDeclarationsExpression(@NotNull UDeclarationsExpression node) {
                return UastVisitor.DefaultImpls.visitDeclarationsExpression((UastVisitor)this, (UDeclarationsExpression)node);
            }

            public boolean visitDoWhileExpression(@NotNull UDoWhileExpression node) {
                return UastVisitor.DefaultImpls.visitDoWhileExpression((UastVisitor)this, (UDoWhileExpression)node);
            }

            public boolean visitEnumConstant(@NotNull UEnumConstant node) {
                return UastVisitor.DefaultImpls.visitEnumConstant((UastVisitor)this, (UEnumConstant)node);
            }

            public boolean visitExpression(@NotNull UExpression node) {
                return UastVisitor.DefaultImpls.visitExpression((UastVisitor)this, (UExpression)node);
            }

            public boolean visitExpressionList(@NotNull UExpressionList node) {
                return UastVisitor.DefaultImpls.visitExpressionList((UastVisitor)this, (UExpressionList)node);
            }

            public boolean visitField(@NotNull UField node) {
                return UastVisitor.DefaultImpls.visitField((UastVisitor)this, (UField)node);
            }

            public boolean visitFile(@NotNull UFile node) {
                return UastVisitor.DefaultImpls.visitFile((UastVisitor)this, (UFile)node);
            }

            public boolean visitForEachExpression(@NotNull UForEachExpression node) {
                return UastVisitor.DefaultImpls.visitForEachExpression((UastVisitor)this, (UForEachExpression)node);
            }

            public boolean visitForExpression(@NotNull UForExpression node) {
                return UastVisitor.DefaultImpls.visitForExpression((UastVisitor)this, (UForExpression)node);
            }

            public boolean visitIfExpression(@NotNull UIfExpression node) {
                return UastVisitor.DefaultImpls.visitIfExpression((UastVisitor)this, (UIfExpression)node);
            }

            public boolean visitImportStatement(@NotNull UImportStatement node) {
                return UastVisitor.DefaultImpls.visitImportStatement((UastVisitor)this, (UImportStatement)node);
            }

            public boolean visitInitializer(@NotNull UClassInitializer node) {
                return UastVisitor.DefaultImpls.visitInitializer((UastVisitor)this, (UClassInitializer)node);
            }

            public boolean visitLabeledExpression(@NotNull ULabeledExpression node) {
                return UastVisitor.DefaultImpls.visitLabeledExpression((UastVisitor)this, (ULabeledExpression)node);
            }

            public boolean visitLambdaExpression(@NotNull ULambdaExpression node) {
                return UastVisitor.DefaultImpls.visitLambdaExpression((UastVisitor)this, (ULambdaExpression)node);
            }

            public boolean visitLiteralExpression(@NotNull ULiteralExpression node) {
                return UastVisitor.DefaultImpls.visitLiteralExpression((UastVisitor)this, (ULiteralExpression)node);
            }

            public boolean visitLocalVariable(@NotNull ULocalVariable node) {
                return UastVisitor.DefaultImpls.visitLocalVariable((UastVisitor)this, (ULocalVariable)node);
            }

            public boolean visitMethod(@NotNull UMethod node) {
                return UastVisitor.DefaultImpls.visitMethod((UastVisitor)this, (UMethod)node);
            }

            public boolean visitObjectLiteralExpression(@NotNull UObjectLiteralExpression node) {
                return UastVisitor.DefaultImpls.visitObjectLiteralExpression((UastVisitor)this, (UObjectLiteralExpression)node);
            }

            public boolean visitParameter(@NotNull UParameter node) {
                return UastVisitor.DefaultImpls.visitParameter((UastVisitor)this, (UParameter)node);
            }

            public boolean visitParenthesizedExpression(@NotNull UParenthesizedExpression node) {
                return UastVisitor.DefaultImpls.visitParenthesizedExpression((UastVisitor)this, (UParenthesizedExpression)node);
            }

            public boolean visitPolyadicExpression(@NotNull UPolyadicExpression node) {
                return UastVisitor.DefaultImpls.visitPolyadicExpression((UastVisitor)this, (UPolyadicExpression)node);
            }

            public boolean visitPostfixExpression(@NotNull UPostfixExpression node) {
                return UastVisitor.DefaultImpls.visitPostfixExpression((UastVisitor)this, (UPostfixExpression)node);
            }

            public boolean visitPrefixExpression(@NotNull UPrefixExpression node) {
                return UastVisitor.DefaultImpls.visitPrefixExpression((UastVisitor)this, (UPrefixExpression)node);
            }

            public boolean visitQualifiedReferenceExpression(@NotNull UQualifiedReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitQualifiedReferenceExpression((UastVisitor)this, (UQualifiedReferenceExpression)node);
            }

            public boolean visitReturnExpression(@NotNull UReturnExpression node) {
                return UastVisitor.DefaultImpls.visitReturnExpression((UastVisitor)this, (UReturnExpression)node);
            }

            public boolean visitSimpleNameReferenceExpression(@NotNull USimpleNameReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitSimpleNameReferenceExpression((UastVisitor)this, (USimpleNameReferenceExpression)node);
            }

            public boolean visitSuperExpression(@NotNull USuperExpression node) {
                return UastVisitor.DefaultImpls.visitSuperExpression((UastVisitor)this, (USuperExpression)node);
            }

            public boolean visitSwitchClauseExpression(@NotNull USwitchClauseExpression node) {
                return UastVisitor.DefaultImpls.visitSwitchClauseExpression((UastVisitor)this, (USwitchClauseExpression)node);
            }

            public boolean visitSwitchExpression(@NotNull USwitchExpression node) {
                return UastVisitor.DefaultImpls.visitSwitchExpression((UastVisitor)this, (USwitchExpression)node);
            }

            public boolean visitThisExpression(@NotNull UThisExpression node) {
                return UastVisitor.DefaultImpls.visitThisExpression((UastVisitor)this, (UThisExpression)node);
            }

            public boolean visitThrowExpression(@NotNull UThrowExpression node) {
                return UastVisitor.DefaultImpls.visitThrowExpression((UastVisitor)this, (UThrowExpression)node);
            }

            public boolean visitTryExpression(@NotNull UTryExpression node) {
                return UastVisitor.DefaultImpls.visitTryExpression((UastVisitor)this, (UTryExpression)node);
            }

            public boolean visitTypeReferenceExpression(@NotNull UTypeReferenceExpression node) {
                return UastVisitor.DefaultImpls.visitTypeReferenceExpression((UastVisitor)this, (UTypeReferenceExpression)node);
            }

            public boolean visitUnaryExpression(@NotNull UUnaryExpression node) {
                return UastVisitor.DefaultImpls.visitUnaryExpression((UastVisitor)this, (UUnaryExpression)node);
            }

            public boolean visitVariable(@NotNull UVariable node) {
                return UastVisitor.DefaultImpls.visitVariable((UastVisitor)this, (UVariable)node);
            }

            public boolean visitWhileExpression(@NotNull UWhileExpression node) {
                return UastVisitor.DefaultImpls.visitWhileExpression((UastVisitor)this, (UWhileExpression)node);
            }
        });
        UElement uElement = foundChild.get();
        if (uElement != null) {
            UElement it = uElement;
            boolean bl = false;
            return it;
        }
        UElement $this$getParentOfType$iv = element;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UThrowExpression uThrowExpression = (UThrowExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UThrowExpression.class, (boolean)strict$iv);
        if (uThrowExpression == null) {
            return null;
        }
        return UtilKt.findMatchingMethodCall((UElement)uThrowExpression, cause, range);
    }

    @NotNull
    public static final Set<String> getCandidateFileNames(@NotNull PsiFile $this$candidateFileNames) {
        Intrinsics.checkNotNullParameter((Object)$this$candidateFileNames, (String)"<this>");
        String string = $this$candidateFileNames.getVirtualFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"virtualFile.name");
        String baseName = StringsKt.substringBeforeLast$default((String)string, (String)".", null, (int)2, null);
        boolean bl = false;
        Object[] objectArray = new String[]{baseName + ".java", baseName + ".kt"};
        return SetsKt.setOf((Object[])objectArray);
    }
}

