/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.analysis;

import com.google.services.firebase.insights.analysis.Confidence;
import com.google.services.firebase.insights.analysis.CrashFrame;
import com.google.services.firebase.insights.analysis.CrashMatcher;
import com.google.services.firebase.insights.analysis.DelegatingConfidenceMatcher;
import com.google.services.firebase.insights.analysis.FullMatcher;
import com.google.services.firebase.insights.analysis.Match;
import com.google.services.firebase.insights.analysis.MethodMatcher;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.services.firebase.logs.FirebaseTrackerImpl;
import com.google.services.firebase.logs.FirebaseTrackerKt;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B#\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\u0004\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/google/services/firebase/insights/analysis/StackTraceAnalyzer;", "", "project", "Lcom/intellij/openapi/project/Project;", "matcher", "Lcom/google/services/firebase/insights/analysis/CrashMatcher;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "(Lcom/intellij/openapi/project/Project;Lcom/google/services/firebase/insights/analysis/CrashMatcher;Lcom/google/services/firebase/logs/FirebaseTracker;)V", "match", "Lcom/google/services/firebase/insights/analysis/Match;", "file", "Lcom/intellij/psi/PsiFile;", "crash", "Lcom/google/services/firebase/insights/analysis/CrashFrame;", "firebase"})
public final class StackTraceAnalyzer {
    @NotNull
    private final Project project;
    @TestOnly
    @NotNull
    private final CrashMatcher matcher;
    @NotNull
    private final FirebaseTracker tracker;

    @JvmOverloads
    public StackTraceAnalyzer(@NotNull Project project, @NotNull CrashMatcher matcher, @NotNull FirebaseTracker tracker) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        this.project = project;
        this.matcher = matcher;
        this.tracker = tracker;
    }

    public /* synthetic */ StackTraceAnalyzer(Project project, CrashMatcher crashMatcher, FirebaseTracker firebaseTracker, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            Object[] objectArray = new CrashMatcher[]{new FullMatcher(), new MethodMatcher()};
            crashMatcher = new DelegatingConfidenceMatcher(CollectionsKt.listOf((Object[])objectArray), Confidence.HIGH);
        }
        if ((n & 4) != 0) {
            firebaseTracker = FirebaseTrackerImpl.INSTANCE;
        }
        this(project, crashMatcher, firebaseTracker);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Match match(@NotNull PsiFile file, @NotNull CrashFrame crash) {
        void $this$match_u24lambda_u2d0;
        AppQualityInsightsUsageEvent.AppQualityInsightsMatcherDetails.Builder builder;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        Match match2 = this.matcher.match(file, crash);
        if (match2 == null) {
            return null;
        }
        Match match3 = match2;
        Project project = file.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.getProject()");
        AppQualityInsightsUsageEvent.AppQualityInsightsMatcherDetails.Builder builder2 = builder = AppQualityInsightsUsageEvent.AppQualityInsightsMatcherDetails.newBuilder();
        Project project2 = project;
        FirebaseTracker firebaseTracker = this.tracker;
        boolean bl = false;
        $this$match_u24lambda_u2d0.setConfidence(match3.getConfidence().toProto());
        $this$match_u24lambda_u2d0.setResolution(FirebaseTrackerKt.convertResolution(match3.getElement()));
        $this$match_u24lambda_u2d0.setSource(AppQualityInsightsUsageEvent.AppQualityInsightsMatcherDetails.MatcherSource.UNKNOWN_SOURCE);
        $this$match_u24lambda_u2d0.setCrashType(AppQualityInsightsUsageEvent.CrashType.FATAL);
        Unit unit = Unit.INSTANCE;
        AppQualityInsightsUsageEvent.AppQualityInsightsMatcherDetails appQualityInsightsMatcherDetails = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)appQualityInsightsMatcherDetails, (String)"newBuilder()\n        .ap\u2026       }\n        .build()");
        firebaseTracker.logMatchers(project2, appQualityInsightsMatcherDetails);
        return match3.getConfidence() == Confidence.HIGH ? match3 : null;
    }

    @JvmOverloads
    public StackTraceAnalyzer(@NotNull Project project, @NotNull CrashMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this(project, matcher, null, 4, null);
    }

    @JvmOverloads
    public StackTraceAnalyzer(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this(project, null, null, 6, null);
    }
}

