/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights.analysis;

import com.google.services.firebase.insights.analysis.Confidence;
import com.google.services.firebase.insights.analysis.CrashFrame;
import com.google.services.firebase.insights.analysis.CrashMatcher;
import com.google.services.firebase.insights.analysis.FullMatcher;
import com.google.services.firebase.insights.analysis.FullMatcher$match$;
import com.google.services.firebase.insights.analysis.Match;
import com.google.services.firebase.insights.analysis.UtilKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PsiLinesUtilsKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/google/services/firebase/insights/analysis/FullMatcher;", "Lcom/google/services/firebase/insights/analysis/CrashMatcher;", "()V", "match", "Lcom/google/services/firebase/insights/analysis/Match;", "file", "Lcom/intellij/psi/PsiFile;", "crash", "Lcom/google/services/firebase/insights/analysis/CrashFrame;", "firebase"})
public final class FullMatcher
implements CrashMatcher {
    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Match match(@NotNull PsiFile file, @NotNull CrashFrame crash) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)crash, (String)"crash");
        int it = (int)crash.getFrame().getLine();
        boolean bl = false;
        int line = it > 0 ? it - 1 : it;
        Integer n = PsiLinesUtilsKt.getLineStartOffset((PsiFile)file, (int)line);
        if (n == null) {
            return null;
        }
        int startOffset = n;
        Integer n2 = PsiLinesUtilsKt.getLineEndOffset((PsiFile)file, (int)line);
        if (n2 == null) {
            return null;
        }
        int endOffset = n2;
        if (endOffset < startOffset) {
            endOffset = startOffset + 1;
        }
        TextRange range = new TextRange(startOffset, endOffset);
        List elementsOnLine = PsiUtilsKt.elementsInRange((PsiFile)file, (TextRange)range);
        for (PsiElement element : elementsOnLine) {
            void $this$forEach$iv;
            UElement el;
            UElement uElement = UastContextKt.toUElement((PsiElement)element);
            if (uElement == null || UtilKt.findMatchingCause(uElement, crash.getCause(), range) == null) continue;
            Sequence $this$filterIsInstance$iv = SequencesKt.generateSequence((Object)el, (Function1)match.1.INSTANCE);
            boolean $i$f$filterIsInstance = false;
            $this$filterIsInstance$iv = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)match$$inlined$filterIsInstance$1.INSTANCE);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                UMethod parent = (UMethod)element$iv;
                boolean bl2 = false;
                UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)parent));
                String className = uClass != null ? uClass.getQualifiedName() : null;
                if (className == null || !crash.getFrame().matches(className, parent.getName())) continue;
                PsiElement psiElement = el.getSourcePsi();
                Object target = psiElement != null ? psiElement.getNavigationElement() : null;
                if (target == null) continue;
                String string = Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName();
                Intrinsics.checkNotNull((Object)string);
                return new Match((PsiElement)target, Confidence.HIGH, string);
            }
        }
        return null;
    }
}

