/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.FirebaseConnection;
import com.google.services.firebase.insights.IssueInFrame;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.ModuleInsightsControllerKt;
import com.google.services.firebase.insights.Selection;
import com.google.services.firebase.insights.analysis.Cause;
import com.google.services.firebase.insights.analysis.CrashFrame;
import com.google.services.firebase.insights.client.IssueRequest;
import com.google.services.firebase.insights.datamodel.CancellableTimeoutException;
import com.google.services.firebase.insights.datamodel.Device;
import com.google.services.firebase.insights.datamodel.ExceptionStack;
import com.google.services.firebase.insights.datamodel.FirebaseFilters;
import com.google.services.firebase.insights.datamodel.Frame;
import com.google.services.firebase.insights.datamodel.Interval;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.OperatingSystemInfo;
import com.google.services.firebase.insights.datamodel.RevertibleException;
import com.google.services.firebase.insights.datamodel.SignalType;
import com.google.services.firebase.insights.datamodel.Version;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a&\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u001a\u0018\u0010\b\u001a\u00020\t\"\u0004\b\u0000\u0010\n*\b\u0012\u0004\u0012\u0002H\n0\u0005H\u0000\u001a\f\u0010\u000b\u001a\u0004\u0018\u00010\f*\u00020\r\u00a8\u0006\u000e"}, d2={"computeIssuesPerFilename", "Lcom/google/common/collect/SetMultimap;", "", "Lcom/google/services/firebase/insights/IssueInFrame;", "issues", "Lcom/google/services/firebase/insights/LoadingState;", "Lcom/google/services/firebase/insights/Selection;", "Lcom/google/services/firebase/insights/datamodel/Issue;", "isCancellableTimeoutException", "", "T", "toIssueRequest", "Lcom/google/services/firebase/insights/client/IssueRequest;", "Lcom/google/services/firebase/insights/AppInsightsState;", "firebase"})
public final class ModuleInsightsControllerKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final SetMultimap<String, IssueInFrame> computeIssuesPerFilename(@NotNull LoadingState<Selection<Issue>> issues2) {
        SetMultimap setMultimap;
        Intrinsics.checkNotNullParameter(issues2, (String)"issues");
        if (issues2 instanceof LoadingState.Ready) {
            void var2_1;
            HashMultimap fileCache = HashMultimap.create();
            for (Issue issue : ((Selection)((LoadingState.Ready)issues2).getValue()).getItems()) {
                for (ExceptionStack exception : issue.getSampleEvent().getStacktraceGroup().getExceptions()) {
                    Frame previousFrame = null;
                    for (Frame frame : exception.getStacktrace().getFrames()) {
                        if (((CharSequence)frame.getFile()).length() > 0) {
                            fileCache.put((Object)frame.getFile(), (Object)new IssueInFrame(new CrashFrame(frame, previousFrame == null ? (Cause)new Cause.Throwable(exception.getType()) : (Cause)new Cause.Frame(previousFrame)), issue));
                        }
                        previousFrame = frame;
                    }
                }
            }
            void var1_9 = var2_1;
            Intrinsics.checkNotNullExpressionValue((Object)var1_9, (String)"{\n      val fileCache = \u2026  }\n      fileCache\n    }");
            setMultimap = (SetMultimap)var1_9;
        } else {
            ImmutableSetMultimap immutableSetMultimap = ImmutableSetMultimap.of();
            Intrinsics.checkNotNullExpressionValue((Object)immutableSetMultimap, (String)"of()");
            setMultimap = (SetMultimap)immutableSetMultimap;
        }
        return setMultimap;
    }

    @Nullable
    public static final IssueRequest toIssueRequest(@NotNull AppInsightsState $this$toIssueRequest) {
        Intrinsics.checkNotNullParameter((Object)$this$toIssueRequest, (String)"<this>");
        if ($this$toIssueRequest.getConnections().getSelected() == null || $this$toIssueRequest.getFilters().getTimeInterval().getSelected() == null) {
            return null;
        }
        Instant it = Instant.now();
        FirebaseConnection firebaseConnection = $this$toIssueRequest.getConnections().getSelected().getConnection();
        boolean bl = false;
        Instant instant = it.minus(Duration.ofDays($this$toIssueRequest.getFilters().getTimeInterval().getSelected().getNumDays()));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"it.minus(Duration.ofDays\u2026terval.selected.numDays))");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Interval interval = new Interval(instant, it);
        Set set = $this$toIssueRequest.getFilters().getVersions().allSelected() ? SetsKt.setOf((Object)Version.Companion.getALL()) : SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$toIssueRequest.getFilters().getVersions().getSelected()), (Function1)toIssueRequest.2.INSTANCE));
        Set set2 = $this$toIssueRequest.getFilters().getDevices().allSelected() ? SetsKt.setOf((Object)Device.Companion.getALL()) : SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$toIssueRequest.getFilters().getDevices().getSelected()), (Function1)toIssueRequest.3.INSTANCE));
        Set set3 = $this$toIssueRequest.getFilters().getOperatingSystems().allSelected() ? SetsKt.setOf((Object)OperatingSystemInfo.Companion.getALL()) : SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)$this$toIssueRequest.getFilters().getOperatingSystems().getSelected()), (Function1)toIssueRequest.4.INSTANCE));
        List list = CollectionsKt.toList((Iterable)$this$toIssueRequest.getFilters().getFatalityToggles().getSelected());
        SignalType signalType = $this$toIssueRequest.getFilters().getSignal().getSelected();
        if (signalType == null) {
            signalType = SignalType.SIGNAL_UNSPECIFIED;
        }
        SignalType signalType2 = signalType;
        List list2 = list;
        Set set4 = set3;
        Set set5 = set2;
        Set set6 = set;
        Interval interval2 = interval;
        FirebaseFilters firebaseFilters = new FirebaseFilters(interval2, set6, set5, set4, list2, signalType2);
        FirebaseConnection firebaseConnection2 = firebaseConnection;
        return new IssueRequest(firebaseConnection2, firebaseFilters);
    }

    public static final <T> boolean isCancellableTimeoutException(@NotNull LoadingState<? extends T> $this$isCancellableTimeoutException) {
        Intrinsics.checkNotNullParameter($this$isCancellableTimeoutException, (String)"<this>");
        return $this$isCancellableTimeoutException instanceof LoadingState.UnknownFailure && ((LoadingState.UnknownFailure)$this$isCancellableTimeoutException).getCause() instanceof RevertibleException && ((RevertibleException)((LoadingState.UnknownFailure)$this$isCancellableTimeoutException).getCause()).getCause() instanceof CancellableTimeoutException;
    }
}

