/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.SetMultimap;
import com.google.services.firebase.insights.AppInsightsModuleController;
import com.google.services.firebase.insights.AppInsightsState;
import com.google.services.firebase.insights.CrashlyticsInsight;
import com.google.services.firebase.insights.FirebaseApp;
import com.google.services.firebase.insights.FlowUtilKt;
import com.google.services.firebase.insights.IssueInFrame;
import com.google.services.firebase.insights.LoadingState;
import com.google.services.firebase.insights.ModuleInsightsController$special$;
import com.google.services.firebase.insights.ModuleInsightsControllerKt;
import com.google.services.firebase.insights.ModuleState;
import com.google.services.firebase.insights.VariantConnection;
import com.google.services.firebase.insights.analysis.StackTraceAnalyzer;
import com.google.services.firebase.insights.analysis.UtilKt;
import com.google.services.firebase.insights.client.CrashlyticsClient;
import com.google.services.firebase.insights.datamodel.ConnectionMode;
import com.google.services.firebase.insights.datamodel.Device;
import com.google.services.firebase.insights.datamodel.Fatality;
import com.google.services.firebase.insights.datamodel.Issue;
import com.google.services.firebase.insights.datamodel.IssueState;
import com.google.services.firebase.insights.datamodel.Note;
import com.google.services.firebase.insights.datamodel.OperatingSystemInfo;
import com.google.services.firebase.insights.datamodel.SignalType;
import com.google.services.firebase.insights.datamodel.TimeIntervalFilter;
import com.google.services.firebase.insights.datamodel.Version;
import com.google.services.firebase.insights.events.ActiveConnectionChanged;
import com.google.services.firebase.insights.events.AddNoteRequested;
import com.google.services.firebase.insights.events.ChangeEvent;
import com.google.services.firebase.insights.events.ConnectionsChanged;
import com.google.services.firebase.insights.events.DeleteNoteRequested;
import com.google.services.firebase.insights.events.DevicesChanged;
import com.google.services.firebase.insights.events.EnterOfflineMode;
import com.google.services.firebase.insights.events.ExplicitRefresh;
import com.google.services.firebase.insights.events.FatalityToggleChanged;
import com.google.services.firebase.insights.events.IntervalChanged;
import com.google.services.firebase.insights.events.IssueToggled;
import com.google.services.firebase.insights.events.OSesChanged;
import com.google.services.firebase.insights.events.ResetSnapshot;
import com.google.services.firebase.insights.events.SafeFiltersAdapter;
import com.google.services.firebase.insights.events.SelectedIssueChanged;
import com.google.services.firebase.insights.events.SignalChanged;
import com.google.services.firebase.insights.events.StateTransition;
import com.google.services.firebase.insights.events.VersionsChanged;
import com.google.services.firebase.insights.events.actions.Action;
import com.google.services.firebase.insights.events.actions.ActionContext;
import com.google.services.firebase.insights.events.actions.ActionDispatcher;
import com.google.services.firebase.insights.inspection.CrashToLineNaiveMapper;
import com.google.services.firebase.insights.ui.AppInsightsToolWindowFactory;
import com.google.services.firebase.logs.FirebaseTracker;
import com.google.services.firebase.logs.FirebaseTrackerImpl;
import com.google.wireless.android.sdk.stats.AppQualityInsightsUsageEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import kotlinx.coroutines.flow.SharingStarted;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00fa\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u009f\u0001\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\t\u0012\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000e\u0012\b\b\u0002\u0010\u0010\u001a\u00020\u0011\u0012\u000e\b\u0002\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013\u0012\b\b\u0002\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\u0019\u0012\u001c\b\u0002\u0010\u001a\u001a\u0016\u0012\u0004\u0012\u00020\u001c\u0012\u0006\u0012\u0004\u0018\u00010\u001d\u0012\u0004\u0012\u00020\u000f0\u001b\u00a2\u0006\u0002\u0010\u001eJ\u0018\u00103\u001a\u00020\u000f2\u0006\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\u001cH\u0016J\u0010\u00107\u001a\u00020\u000f2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00108\u001a\u00020\u000f2\u0006\u00109\u001a\u00020:H\u0016J\u0019\u0010;\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020&H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010=J\u0010\u0010>\u001a\u00020\u000f2\u0006\u0010<\u001a\u00020&H\u0002J\b\u0010?\u001a\u00020\u000fH\u0016J\u0016\u0010@\u001a\u00020\u000f2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020DJ\u0016\u0010E\u001a\b\u0012\u0004\u0012\u00020)0F2\u0006\u0010A\u001a\u00020BH\u0002J\u0010\u0010G\u001a\u00020\u000f2\u0006\u00104\u001a\u000205H\u0016J\b\u0010H\u001a\u00020\u000fH\u0016J\u001c\u0010I\u001a\b\u0012\u0004\u0012\u00020J0F2\u0006\u0010A\u001a\u00020B2\u0006\u0010\u0016\u001a\u00020\u0017J\u0010\u0010K\u001a\u00020\u000f2\u0006\u0010.\u001a\u000200H\u0016J\u0016\u0010L\u001a\u00020\u000f2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020O0NH\u0016J\u0010\u0010P\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020RH\u0016J\u001a\u0010S\u001a\u00020\u000f2\b\u0010Q\u001a\u0004\u0018\u0001052\u0006\u0010T\u001a\u00020UH\u0016J\u0016\u0010V\u001a\u00020\u000f2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020W0NH\u0016J\u0010\u0010X\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020YH\u0016J\u0010\u0010Z\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020[H\u0016J\u0016\u0010\\\u001a\u00020\u000f2\f\u0010M\u001a\b\u0012\u0004\u0012\u00020]0NH\u0016J\u0010\u0010^\u001a\u00020\u000f2\u0006\u0010Q\u001a\u00020_H\u0016J\u001c\u0010`\u001a\u00020\u000f2\u0012\u0010a\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)0(H\u0002R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u000e\u0010#\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u00118\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R \u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)0(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010,\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020)0(0-X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u0002000/X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006b"}, d2={"Lcom/google/services/firebase/insights/ModuleInsightsController;", "Lcom/google/services/firebase/insights/AppInsightsModuleController;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "dispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "crashlyticsClient", "Lcom/google/services/firebase/insights/client/CrashlyticsClient;", "appConnection", "Lkotlinx/coroutines/flow/Flow;", "Lcom/google/services/firebase/insights/FirebaseApp;", "offlineStatus", "Lcom/google/services/firebase/insights/datamodel/ConnectionMode;", "setOfflineMode", "Lkotlin/Function1;", "", "flowStart", "Lkotlinx/coroutines/flow/SharingStarted;", "onIssuesChanged", "Lkotlin/Function0;", "tracker", "Lcom/google/services/firebase/logs/FirebaseTracker;", "module", "Lcom/intellij/openapi/module/Module;", "clock", "Ljava/time/Clock;", "onErrorAction", "Lkotlin/Function2;", "", "Ljavax/swing/event/HyperlinkListener;", "(Lkotlinx/coroutines/CoroutineScope;Lkotlinx/coroutines/CoroutineDispatcher;Lcom/google/services/firebase/insights/client/CrashlyticsClient;Lkotlinx/coroutines/flow/Flow;Lkotlinx/coroutines/flow/Flow;Lkotlin/jvm/functions/Function1;Lkotlinx/coroutines/flow/SharingStarted;Lkotlin/jvm/functions/Function0;Lcom/google/services/firebase/logs/FirebaseTracker;Lcom/intellij/openapi/module/Module;Ljava/time/Clock;Lkotlin/jvm/functions/Function2;)V", "actionDispatcher", "Lcom/google/services/firebase/insights/events/actions/ActionDispatcher;", "getCoroutineScope", "()Lkotlinx/coroutines/CoroutineScope;", "dispatcherScope", "eventFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "Lcom/google/services/firebase/insights/events/ChangeEvent;", "issuesPerFilename", "Lcom/google/common/collect/SetMultimap;", "Lcom/google/services/firebase/insights/IssueInFrame;", "getIssuesPerFilename", "()Lcom/google/common/collect/SetMultimap;", "mutableIssuesPerFilename", "Ljava/util/concurrent/atomic/AtomicReference;", "state", "Lkotlinx/coroutines/flow/SharedFlow;", "Lcom/google/services/firebase/insights/AppInsightsState;", "getState", "()Lkotlinx/coroutines/flow/SharedFlow;", "addNote", "issue", "Lcom/google/services/firebase/insights/datamodel/Issue;", "message", "closeIssue", "deleteNote", "note", "Lcom/google/services/firebase/insights/datamodel/Note;", "doEmit", "event", "(Lcom/google/services/firebase/insights/events/ChangeEvent;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "emit", "enterOfflineMode", "insightsInFile", "file", "Lcom/intellij/psi/PsiFile;", "analyzer", "Lcom/google/services/firebase/insights/analysis/StackTraceAnalyzer;", "issuesForFile", "", "openIssue", "refresh", "retrieveLineMatches", "Lcom/google/services/firebase/insights/CrashlyticsInsight;", "revertToSnapshot", "selectDevices", "values", "", "Lcom/google/services/firebase/insights/datamodel/Device;", "selectFirebaseConnection", "value", "Lcom/google/services/firebase/insights/VariantConnection;", "selectIssue", "source", "Lcom/google/wireless/android/sdk/stats/AppQualityInsightsUsageEvent$AppQualityInsightsCrashOpenDetails$CrashOpenSource;", "selectOperatingSystems", "Lcom/google/services/firebase/insights/datamodel/OperatingSystemInfo;", "selectSignal", "Lcom/google/services/firebase/insights/datamodel/SignalType;", "selectTimeInterval", "Lcom/google/services/firebase/insights/datamodel/TimeIntervalFilter;", "selectVersions", "Lcom/google/services/firebase/insights/datamodel/Version;", "toggleFatality", "Lcom/google/services/firebase/insights/datamodel/Fatality;", "updateIssueIndex", "newIndex", "firebase"})
public final class ModuleInsightsController
implements AppInsightsModuleController {
    @NotNull
    private final CoroutineScope coroutineScope;
    @NotNull
    private final Function1<ConnectionMode, Unit> setOfflineMode;
    @TestOnly
    @NotNull
    private final SharingStarted flowStart;
    @NotNull
    private final Function0<Unit> onIssuesChanged;
    @NotNull
    private final FirebaseTracker tracker;
    @NotNull
    private final Module module;
    @NotNull
    private final Clock clock;
    @NotNull
    private final SharedFlow<AppInsightsState> state;
    @NotNull
    private final CoroutineScope dispatcherScope;
    @NotNull
    private final ActionDispatcher actionDispatcher;
    @NotNull
    private final MutableSharedFlow<ChangeEvent> eventFlow;
    @NotNull
    private final AtomicReference<SetMultimap<String, IssueInFrame>> mutableIssuesPerFilename;

    /*
     * WARNING - void declaration
     */
    public ModuleInsightsController(@NotNull CoroutineScope coroutineScope, @NotNull CoroutineDispatcher dispatcher, @NotNull CrashlyticsClient crashlyticsClient, @NotNull Flow<FirebaseApp> appConnection, @NotNull Flow<? extends ConnectionMode> offlineStatus, @NotNull Function1<? super ConnectionMode, Unit> setOfflineMode, @NotNull SharingStarted flowStart, @NotNull Function0<Unit> onIssuesChanged, @NotNull FirebaseTracker tracker, @NotNull Module module, @NotNull Clock clock, @NotNull Function2<? super String, ? super HyperlinkListener, Unit> onErrorAction) {
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)dispatcher, (String)"dispatcher");
        Intrinsics.checkNotNullParameter((Object)crashlyticsClient, (String)"crashlyticsClient");
        Intrinsics.checkNotNullParameter(appConnection, (String)"appConnection");
        Intrinsics.checkNotNullParameter(offlineStatus, (String)"offlineStatus");
        Intrinsics.checkNotNullParameter(setOfflineMode, (String)"setOfflineMode");
        Intrinsics.checkNotNullParameter((Object)flowStart, (String)"flowStart");
        Intrinsics.checkNotNullParameter(onIssuesChanged, (String)"onIssuesChanged");
        Intrinsics.checkNotNullParameter((Object)tracker, (String)"tracker");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
        Intrinsics.checkNotNullParameter(onErrorAction, (String)"onErrorAction");
        this.coroutineScope = coroutineScope;
        this.setOfflineMode = setOfflineMode;
        this.flowStart = flowStart;
        this.onIssuesChanged = onIssuesChanged;
        this.tracker = tracker;
        this.module = module;
        this.clock = clock;
        this.dispatcherScope = CoroutineScopeKt.CoroutineScope((CoroutineContext)this.getCoroutineScope().getCoroutineContext().plus((CoroutineContext)dispatcher));
        this.actionDispatcher = new ActionDispatcher(this.dispatcherScope, this.clock, crashlyticsClient, (Function2<? super ChangeEvent, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<ChangeEvent, Continuation<? super Unit>, Object>((Object)this){

            @Nullable
            public final Object invoke(@NotNull ChangeEvent p0, @NotNull Continuation<? super Unit> $completion) {
                return ModuleInsightsController.access$doEmit((ModuleInsightsController)this.receiver, p0, $completion);
            }
        }), onErrorAction, this.tracker);
        this.eventFlow = SharedFlowKt.MutableSharedFlow$default((int)0, (int)2, null, (int)5, null);
        this.mutableIssuesPerFilename = new AtomicReference<ImmutableSetMultimap>(ImmutableSetMultimap.of());
        ModuleState initialState = new ModuleState(null, null, 3, null);
        Flow<ModuleState> flow = new Flow[3];
        flow[0] = (Flow)this.eventFlow;
        Object $this$map$iv2 = appConnection;
        boolean $i$f$map = false;
        Flow<FirebaseApp> $this$unsafeTransform$iv$iv = $this$map$iv2;
        boolean $i$f$unsafeTransform = false;
        boolean $i$f$unsafeFlow = false;
        flow[1] = (Flow)new Flow<ConnectionsChanged>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                void $this$collect$iv;
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u2d1 = collector;
                boolean bl = false;
                Flow flow = this.$this_unsafeTransform$inlined;
                Continuation $completion$iv = $completion;
                boolean $i$f$collect = false;
                Object object = $this$collect$iv.collect((FlowCollector)new FlowCollector<FirebaseApp>($this$unsafeTransform_u24lambda_u2d1){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof special$$inlined$map$1$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$1$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                value = value;
                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                var8_9 = value;
                                $this$map_u24lambda_u2d4 = this.$this_unsafeFlow$inlined;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var11_13 = $this$map_u24lambda_u2d4;
                                (Continuation)$continuation;
                                it = (FirebaseApp)value;
                                $i$a$-map-ModuleInsightsController$3 = false;
                                $continuation.label = 1;
                                v0 = var11_13.emit((Object)new ConnectionsChanged(it), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl32
                            }
                            case 1: {
                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl32:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion$iv);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        $this$map$iv2 = offlineStatus;
        $i$f$map = false;
        $this$unsafeTransform$iv$iv = $this$map$iv2;
        $i$f$unsafeTransform = false;
        $i$f$unsafeFlow = false;
        flow[2] = (Flow)new Flow<ChangeEvent>($this$unsafeTransform$iv$iv){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                void $this$collect$iv;
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u2d1 = collector;
                boolean bl = false;
                Flow flow = this.$this_unsafeTransform$inlined;
                Continuation $completion$iv = $completion;
                boolean $i$f$collect = false;
                Object object = $this$collect$iv.collect((FlowCollector)new FlowCollector<ConnectionMode>($this$unsafeTransform_u24lambda_u2d1){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof special$$inlined$map$2$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$2$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                value = value;
                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                var8_9 = value;
                                $this$map_u24lambda_u2d4 = this.$this_unsafeFlow$inlined;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var11_13 = $this$map_u24lambda_u2d4;
                                (Continuation)$continuation;
                                it = (ConnectionMode)value;
                                $i$a$-map-ModuleInsightsController$4 = false;
                                $continuation.label = 1;
                                v0 = var11_13.emit((Object)it.toEvent(), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl32
                            }
                            case 1: {
                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl32:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion$iv);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        };
        flow = FlowUtilKt.fold(FlowKt.merge((Flow[])flow), initialState, (Function3)new Function3<ModuleState, ChangeEvent, Continuation<? super ModuleState>, Object>(this, null){
            int label;
            /* synthetic */ Object L$0;
            /* synthetic */ Object L$1;
            final /* synthetic */ ModuleInsightsController this$0;
            {
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        ModuleState moduleState = (ModuleState)this.L$0;
                        ChangeEvent event = (ChangeEvent)this.L$1;
                        AppInsightsState currentState = moduleState.component1();
                        AppInsightsState lastGoodState = moduleState.component2();
                        Logger.getInstance(ModuleInsightsController.class).info("Got event " + event + " for " + this.this$0.module + ".");
                        StateTransition<Action> stateTransition = event.transition(currentState, this.this$0.tracker);
                        AppInsightsState newState2 = stateTransition.component1();
                        Action action2 = stateTransition.component2();
                        if (!Intrinsics.areEqual(currentState.getIssues(), newState2.getIssues())) {
                            this.this$0.updateIssueIndex((SetMultimap<String, IssueInFrame>)ModuleInsightsControllerKt.computeIssuesPerFilename(newState2.getIssues().map(1.INSTANCE)));
                        }
                        if (currentState.getMode() != newState2.getMode()) {
                            this.this$0.setOfflineMode.invoke((Object)newState2.getMode());
                        }
                        ModuleState moduleState2 = new ModuleState(newState2, newState2.getIssues() instanceof LoadingState.Ready && newState2.getCurrentNotes() instanceof LoadingState.Ready ? newState2 : lastGoodState);
                        ModuleInsightsController moduleInsightsController = this.this$0;
                        ModuleState moduleState3 = moduleState2;
                        boolean bl = false;
                        AppInsightsState currentState2 = moduleState3.component1();
                        AppInsightsState lastGoodState2 = moduleState3.component2();
                        this.L$0 = moduleState2;
                        this.label = 1;
                        Object object3 = moduleInsightsController.actionDispatcher.dispatch(new ActionContext(action2, currentState2, lastGoodState2), (Continuation<? super Unit>)this);
                        if (object3 != object2) return moduleState2;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        boolean bl = false;
                        ModuleState moduleState2 = (ModuleState)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return moduleState2;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @Nullable
            public final Object invoke(@NotNull ModuleState p1, @NotNull ChangeEvent p2, @Nullable Continuation<? super ModuleState> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p1;
                var4_4.L$1 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        });
        boolean $i$f$map2 = false;
        void $this$unsafeTransform$iv$iv2 = $this$map$iv;
        boolean $i$f$unsafeTransform2 = false;
        boolean $i$f$unsafeFlow2 = false;
        this.state = FlowKt.shareIn((Flow)FlowKt.distinctUntilChanged((Flow)((Flow)new Flow<AppInsightsState>((Flow)$this$unsafeTransform$iv$iv2){
            final /* synthetic */ Flow $this_unsafeTransform$inlined;
            {
                this.$this_unsafeTransform$inlined = flow;
            }

            /*
             * WARNING - void declaration
             */
            @Nullable
            public Object collect(@NotNull FlowCollector collector, @NotNull Continuation $completion) {
                void $this$collect$iv;
                Continuation continuation = $completion;
                FlowCollector $this$unsafeTransform_u24lambda_u2d1 = collector;
                boolean bl = false;
                Flow flow = this.$this_unsafeTransform$inlined;
                Continuation $completion$iv = $completion;
                boolean $i$f$collect = false;
                Object object = $this$collect$iv.collect((FlowCollector)new FlowCollector<ModuleState>($this$unsafeTransform_u24lambda_u2d1){
                    final /* synthetic */ FlowCollector $this_unsafeFlow$inlined;
                    {
                        this.$this_unsafeFlow$inlined = flowCollector;
                    }

                    /*
                     * Unable to fully structure code
                     */
                    @Nullable
                    public Object emit(Object var1_1, @NotNull Continuation var2_2) {
                        if (!(var2_2 instanceof special$$inlined$map$3$2$1)) ** GOTO lbl-1000
                        var3_3 = var2_2;
                        if ((var3_3.label & -2147483648) != 0) {
                            var3_3.label -= -2147483648;
                        } else lbl-1000:
                        // 2 sources

                        {
                            $continuation = new ContinuationImpl(this, var2_2){
                                /* synthetic */ Object result;
                                int label;
                                Object L$0;
                                final /* synthetic */ special$$inlined$map$3$2 this$0;
                                {
                                    this.this$0 = this$0;
                                    super($completion);
                                }

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    this.result = $result;
                                    this.label |= Integer.MIN_VALUE;
                                    return this.this$0.emit(null, (Continuation)this);
                                }
                            };
                        }
                        $result = $continuation.result;
                        var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch ($continuation.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                value = value;
                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                var8_9 = value;
                                $this$map_u24lambda_u2d4 = this.$this_unsafeFlow$inlined;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                var11_13 = $this$map_u24lambda_u2d4;
                                (Continuation)$continuation;
                                it = (ModuleState)value;
                                $i$a$-map-ModuleInsightsController$6 = false;
                                $continuation.label = 1;
                                v0 = var11_13.emit((Object)it.getCurrentState(), (Continuation)$continuation);
                                if (v0 == var5_5) {
                                    return var5_5;
                                }
                                ** GOTO lbl32
                            }
                            case 1: {
                                $i$a$-collect-FlowKt__EmittersKt$unsafeTransform$1$1 = false;
                                $i$a$-unsafeTransform-FlowKt__TransformKt$map$1 = false;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl32:
                                // 2 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }
                }, $completion$iv);
                if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                    return object;
                }
                return Unit.INSTANCE;
            }
        })), (CoroutineScope)this.dispatcherScope, (SharingStarted)this.flowStart, (int)1);
    }

    public /* synthetic */ ModuleInsightsController(CoroutineScope coroutineScope, CoroutineDispatcher coroutineDispatcher, CrashlyticsClient crashlyticsClient, Flow flow, Flow flow2, Function1 function1, SharingStarted sharingStarted, Function0 function0, FirebaseTracker firebaseTracker, final Module module, Clock clock, Function2 function2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            sharingStarted = SharingStarted.Companion.getEagerly();
        }
        if ((n & 0x80) != 0) {
            function0 = 1.INSTANCE;
        }
        if ((n & 0x100) != 0) {
            firebaseTracker = FirebaseTrackerImpl.INSTANCE;
        }
        if ((n & 0x800) != 0) {
            function2 = (Function2)new Function2<String, HyperlinkListener, Unit>(){

                public final void invoke(@NotNull String msg, @Nullable HyperlinkListener hyperlinkListener) {
                    Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
                    Project project = module.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
                    AppInsightsToolWindowFactory.Companion.showErrorBalloon(project, msg, hyperlinkListener);
                }
            };
        }
        this(coroutineScope, coroutineDispatcher, crashlyticsClient, (Flow<FirebaseApp>)flow, (Flow<? extends ConnectionMode>)flow2, (Function1<? super ConnectionMode, Unit>)function1, sharingStarted, (Function0<Unit>)function0, firebaseTracker, module, clock, (Function2<? super String, ? super HyperlinkListener, Unit>)function2);
    }

    @Override
    @NotNull
    public CoroutineScope getCoroutineScope() {
        return this.coroutineScope;
    }

    @NotNull
    public SharedFlow<AppInsightsState> getState() {
        return this.state;
    }

    private final SetMultimap<String, IssueInFrame> getIssuesPerFilename() {
        SetMultimap<String, IssueInFrame> setMultimap = this.mutableIssuesPerFilename.get();
        Intrinsics.checkNotNullExpressionValue(setMultimap, (String)"mutableIssuesPerFilename.get()");
        return setMultimap;
    }

    private final void updateIssueIndex(SetMultimap<String, IssueInFrame> newIndex) {
        if (!Intrinsics.areEqual(this.mutableIssuesPerFilename.getAndSet(newIndex), newIndex)) {
            this.onIssuesChanged.invoke();
        }
    }

    @Override
    public void selectVersions(@NotNull Set<Version> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.emit(new VersionsChanged(values));
    }

    @Override
    public void selectDevices(@NotNull Set<Device> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.emit(new DevicesChanged(values));
    }

    @Override
    public void selectOperatingSystems(@NotNull Set<OperatingSystemInfo> values) {
        Intrinsics.checkNotNullParameter(values, (String)"values");
        this.emit(new OSesChanged(values));
    }

    @Override
    public void selectSignal(@NotNull SignalType value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.emit(new SignalChanged(value));
    }

    @Override
    public void selectFirebaseConnection(@NotNull VariantConnection value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.emit(new ActiveConnectionChanged(value));
    }

    @Override
    public void toggleFatality(@NotNull Fatality value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.emit(new FatalityToggleChanged(value));
    }

    @Override
    public void openIssue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        this.emit(new IssueToggled(issue.getId-s7_ZKiI(), IssueState.OPENING, null));
    }

    @Override
    public void closeIssue(@NotNull Issue issue) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        this.emit(new IssueToggled(issue.getId-s7_ZKiI(), IssueState.CLOSING, null));
    }

    @Override
    public void enterOfflineMode() {
        this.emit(EnterOfflineMode.INSTANCE);
    }

    @Override
    public void addNote(@NotNull Issue issue, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.emit(new AddNoteRequested(issue.getId-s7_ZKiI(), message, this.clock, null));
    }

    @Override
    public void deleteNote(@NotNull Note note) {
        Intrinsics.checkNotNullParameter((Object)note, (String)"note");
        this.emit(new DeleteNoteRequested(note.getId()));
    }

    @Override
    public void selectTimeInterval(@NotNull TimeIntervalFilter value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        this.emit(new IntervalChanged(value));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void selectIssue(@Nullable Issue value, @NotNull AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails.CrashOpenSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (value != null) {
            void $this$selectIssue_u24lambda_u2d3;
            AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails.Builder builder;
            Project project = this.module.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails.Builder builder2 = builder = AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails.newBuilder();
            Project project2 = project;
            FirebaseTracker firebaseTracker = this.tracker;
            boolean bl = false;
            $this$selectIssue_u24lambda_u2d3.setSource(source);
            $this$selectIssue_u24lambda_u2d3.setCrashType(value.getIssueDetails().getFatality().toCrashType());
            Unit unit = Unit.INSTANCE;
            AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails appQualityInsightsCrashOpenDetails = builder.build();
            Intrinsics.checkNotNullExpressionValue((Object)appQualityInsightsCrashOpenDetails, (String)"newBuilder()\n          .\u2026     }\n          .build()");
            firebaseTracker.logCrashListDetailView(project2, appQualityInsightsCrashOpenDetails);
        }
        this.emit(new SelectedIssueChanged(value));
    }

    @Override
    public void refresh() {
        this.emit(ExplicitRefresh.INSTANCE);
    }

    @Override
    public void revertToSnapshot(@NotNull AppInsightsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.emit(new ResetSnapshot(state));
    }

    private final void emit(ChangeEvent event) {
        BuildersKt.launch$default((CoroutineScope)this.dispatcherScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, event, null){
            int label;
            final /* synthetic */ ModuleInsightsController this$0;
            final /* synthetic */ ChangeEvent $event;
            {
                this.this$0 = $receiver;
                this.$event = $event;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ModuleInsightsController.access$doEmit(this.this$0, this.$event, (Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final Object doEmit(ChangeEvent event, Continuation<? super Unit> $completion) {
        Object object = this.eventFlow.emit((Object)new SafeFiltersAdapter(event), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @NotNull
    public final List<CrashlyticsInsight> retrieveLineMatches(@NotNull PsiFile file, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        return new CrashToLineNaiveMapper((Function1<? super PsiFile, ? extends List<IssueInFrame>>)((Function1)new Function1<PsiFile, List<? extends IssueInFrame>>((Object)this){

            @NotNull
            public final List<IssueInFrame> invoke(@NotNull PsiFile p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return ModuleInsightsController.access$issuesForFile((ModuleInsightsController)this.receiver, p0);
            }
        }), (Function1<? super Issue, Unit>)((Function1)new Function1<Issue, Unit>(this, module){
            final /* synthetic */ ModuleInsightsController this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(1);
            }

            public final void invoke(@NotNull Issue issue) {
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                this.this$0.selectIssue(issue, AppQualityInsightsUsageEvent.AppQualityInsightsCrashOpenDetails.CrashOpenSource.INSPECTION);
                AppInsightsToolWindowFactory.Companion.setActiveTabFromModule(this.$module);
            }
        })).retrieve(file);
    }

    /*
     * WARNING - void declaration
     */
    public final void insightsInFile(@NotNull PsiFile file, @NotNull StackTraceAnalyzer analyzer) {
        Iterable iterable;
        List<IssueInFrame> list;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)analyzer, (String)"analyzer");
        List<IssueInFrame> issues2 = list = this.issuesForFile(file);
        boolean bl = false;
        if (!issues2.isEmpty()) {
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = issues2;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                CharSequence charSequence;
                void it;
                IssueInFrame issueInFrame = (IssueInFrame)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                CharSequence charSequence2 = it.getIssue().getIssueDetails().getSubtitle();
                if (charSequence2.length() == 0) {
                    boolean bl3 = false;
                    charSequence = "<missingSubtitle>";
                } else {
                    charSequence = charSequence2;
                }
                collection.add((String)charSequence);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object accumulator$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void value;
                String $i$f$mapTo2 = (String)iterator$iv.next();
                String acc = (String)accumulator$iv;
                boolean bl4 = false;
                accumulator$iv = acc + "\n" + (String)value;
            }
            String formattedIssues = (String)accumulator$iv;
            Logger.getInstance(ModuleInsightsController.class).debug("Found " + issues2.size() + " issues related to " + file.getName() + " [\n" + formattedIssues + "], analyzing...");
        }
        Iterable $this$onEach$iv = list;
        boolean $i$f$onEach = false;
        Iterable $this$onEach_u24lambda_u2d16$iv = iterable = $this$onEach$iv;
        boolean bl5 = false;
        for (Object element$iv : $this$onEach_u24lambda_u2d16$iv) {
            IssueInFrame it = (IssueInFrame)element$iv;
            boolean bl6 = false;
            analyzer.match(file, it.getCrashFrame());
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IssueInFrame> issuesForFile(PsiFile file) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = UtilKt.getCandidateFileNames(file);
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            Set set = this.getIssuesPerFilename().get((Object)it);
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"issuesPerFilename.get(it)");
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ Object access$doEmit(ModuleInsightsController $this, ChangeEvent event, Continuation $completion) {
        return $this.doEmit(event, (Continuation<? super Unit>)$completion);
    }

    public static final /* synthetic */ List access$issuesForFile(ModuleInsightsController $this, PsiFile file) {
        return $this.issuesForFile(file);
    }
}

