/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.insights;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\r\u001a\u00020\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J1\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\u0010\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0019\u001a\u00020\u0003H\u0002J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\u001b"}, d2={"Lcom/google/services/firebase/insights/FirebaseConnection;", "", "appId", "", "mobileSdkAppId", "projectId", "projectNumber", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getAppId", "()Ljava/lang/String;", "getMobileSdkAppId", "getProjectId", "getProjectNumber", "clientId", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "stripProjectName", "projectName", "toString", "firebase"})
public final class FirebaseConnection {
    @NotNull
    private final String appId;
    @NotNull
    private final String mobileSdkAppId;
    @NotNull
    private final String projectId;
    @NotNull
    private final String projectNumber;

    public FirebaseConnection(@NotNull String appId, @NotNull String mobileSdkAppId, @NotNull String projectId, @NotNull String projectNumber) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)mobileSdkAppId, (String)"mobileSdkAppId");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)projectNumber, (String)"projectNumber");
        this.appId = appId;
        this.mobileSdkAppId = mobileSdkAppId;
        this.projectId = projectId;
        this.projectNumber = projectNumber;
    }

    @NotNull
    public final String getAppId() {
        return this.appId;
    }

    @NotNull
    public final String getMobileSdkAppId() {
        return this.mobileSdkAppId;
    }

    @NotNull
    public final String getProjectId() {
        return this.projectId;
    }

    @NotNull
    public final String getProjectNumber() {
        return this.projectNumber;
    }

    @NotNull
    public final String clientId() {
        return "android:" + this.appId;
    }

    @NotNull
    public String toString() {
        return "[" + this.stripProjectName(this.projectId) + "] " + this.appId;
    }

    private final String stripProjectName(String projectName) {
        return StringsKt.substringBeforeLast$default((String)projectName, (char)'-', null, (int)2, null);
    }

    @NotNull
    public final String component1() {
        return this.appId;
    }

    @NotNull
    public final String component2() {
        return this.mobileSdkAppId;
    }

    @NotNull
    public final String component3() {
        return this.projectId;
    }

    @NotNull
    public final String component4() {
        return this.projectNumber;
    }

    @NotNull
    public final FirebaseConnection copy(@NotNull String appId, @NotNull String mobileSdkAppId, @NotNull String projectId, @NotNull String projectNumber) {
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        Intrinsics.checkNotNullParameter((Object)mobileSdkAppId, (String)"mobileSdkAppId");
        Intrinsics.checkNotNullParameter((Object)projectId, (String)"projectId");
        Intrinsics.checkNotNullParameter((Object)projectNumber, (String)"projectNumber");
        return new FirebaseConnection(appId, mobileSdkAppId, projectId, projectNumber);
    }

    public static /* synthetic */ FirebaseConnection copy$default(FirebaseConnection firebaseConnection, String string, String string2, String string3, String string4, int n, Object object) {
        if ((n & 1) != 0) {
            string = firebaseConnection.appId;
        }
        if ((n & 2) != 0) {
            string2 = firebaseConnection.mobileSdkAppId;
        }
        if ((n & 4) != 0) {
            string3 = firebaseConnection.projectId;
        }
        if ((n & 8) != 0) {
            string4 = firebaseConnection.projectNumber;
        }
        return firebaseConnection.copy(string, string2, string3, string4);
    }

    public int hashCode() {
        int result2 = this.appId.hashCode();
        result2 = result2 * 31 + this.mobileSdkAppId.hashCode();
        result2 = result2 * 31 + this.projectId.hashCode();
        result2 = result2 * 31 + this.projectNumber.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FirebaseConnection)) {
            return false;
        }
        FirebaseConnection firebaseConnection = (FirebaseConnection)other;
        if (!Intrinsics.areEqual((Object)this.appId, (Object)firebaseConnection.appId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.mobileSdkAppId, (Object)firebaseConnection.mobileSdkAppId)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.projectId, (Object)firebaseConnection.projectId)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.projectNumber, (Object)firebaseConnection.projectNumber);
    }
}

