/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.consolereceiver;

import com.google.api.client.repackaged.org.mortbay.jetty.Connector;
import com.google.api.client.repackaged.org.mortbay.jetty.Server;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.consolereceiver.ReceiverResult;
import com.google.services.firebase.consolereceiver.callback.CancellableReceiverHandlerFactory;
import com.google.services.firebase.consolereceiver.callback.ReceiverCallback;
import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CancellableReceiver
implements AutoCloseable,
ReceiverCallback {
    private static final Logger LOGGER = Logger.getInstance(CancellableReceiver.class);
    private static final String LOCALHOST = "localhost";
    private Server server;
    private int port;
    private final Lock lock = new ReentrantLock();
    private final Condition gotValidRequestFromConsole = this.lock.newCondition();
    private CancellableReceiverHandlerFactory callbackHandlerFactory;
    private ReceiverResult processResult;

    public CancellableReceiver(CancellableReceiverHandlerFactory callbackHandlerFactory) {
        this(0, callbackHandlerFactory);
    }

    @Override
    public void onSuccess(String successMessage) {
        try {
            this.lock.lock();
            this.processResult = new ReceiverResult(ReceiverResult.Status.SUCCESS, successMessage, null);
            this.gotValidRequestFromConsole.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void onFailure(String errorMessage, Throwable exception) {
        try {
            this.lock.lock();
            this.processResult = new ReceiverResult(ReceiverResult.Status.ERROR, errorMessage, exception);
            this.gotValidRequestFromConsole.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    public CancellableReceiver(int port, CancellableReceiverHandlerFactory callbackHandlerFactory) {
        this.port = port;
        this.callbackHandlerFactory = callbackHandlerFactory;
    }

    public void start() throws Exception {
        this.server = new Server(this.port);
        Connector connector = this.server.getConnectors()[0];
        connector.setHost(LOCALHOST);
        this.server.addHandler(this.callbackHandlerFactory.getCallbackHandler(this));
        this.server.start();
        this.port = connector.getLocalPort();
    }

    public int getPort() {
        return this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReceiverResult waitForRequest(Cancellable cancellableProcess) {
        this.lock.lock();
        try {
            while (!this.gotValidRequestFromConsole.await(1L, TimeUnit.SECONDS)) {
                if (!cancellableProcess.isCancelled()) continue;
                this.gotValidRequestFromConsole.signal();
                ReceiverResult receiverResult = new ReceiverResult(ReceiverResult.Status.CANCELLED, FirebaseBundle.message("firebaseService.userNotification.connectedCancelled", new Object[0]), null);
                return receiverResult;
            }
        }
        catch (InterruptedException e) {
            LOGGER.warn("CancellableServerReceiver interrupted.", (Throwable)e);
            this.gotValidRequestFromConsole.signal();
            ReceiverResult receiverResult = new ReceiverResult(ReceiverResult.Status.ERROR, FirebaseBundle.message("firebaseService.userNotification.connectedCancelled", new Object[0]), e);
            return receiverResult;
        }
        finally {
            this.lock.unlock();
        }
        if (this.processResult == null) {
            throw new IllegalStateException("Receiver processed terminated without a valid state.");
        }
        return this.processResult;
    }

    @Override
    public void close() throws Exception {
        if (this.server != null) {
            try {
                this.server.stop();
            }
            catch (Exception e) {
                LOGGER.error("Couldn't stop server", (Throwable)e);
            }
        }
        this.lock.lock();
        try {
            this.gotValidRequestFromConsole.signal();
        }
        finally {
            this.lock.unlock();
        }
        this.server = null;
    }

    public static interface Cancellable {
        public boolean isCancelled();
    }
}

