/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.config;

import com.android.tools.idea.projectsystem.AndroidProjectRootUtil;
import com.google.common.base.Charsets;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.config.AndroidConfigManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AndroidConfigManagerImpl
implements AndroidConfigManager {
    private static final Logger LOGGER = Logger.getInstance(AndroidConfigManagerImpl.class);

    @Override
    public void writeAndroidConfig(@NotNull String config, @NotNull Module androidApplicationModule) throws IOException {
        String moduleDir = AndroidProjectRootUtil.getModuleDirPath((Module)androidApplicationModule);
        if (moduleDir == null) {
            throw new RuntimeException(FirebaseBundle.message("firebaseConnectAction.userError.couldNotFindProjectRoot", new Object[0]));
        }
        File jsonFile = new File(moduleDir, "google-services.json");
        LOGGER.info("Firebase config to be written to: " + jsonFile.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(jsonFile);){
            fos.write(config.getBytes(Charsets.UTF_8));
        }
        catch (IOException exception) {
            LOGGER.error("Couldn't write downloaded Firebase configuration to file system", (Throwable)exception);
            throw new IOException(FirebaseBundle.message("firebaseConnectAction.userError.couldNotWriteConfig", jsonFile.getAbsolutePath()), exception);
        }
    }
}

