/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.action.connect;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.gradle.project.sync.hyperlink.OpenUrlHyperlink;
import com.android.tools.idea.model.AndroidModel;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.action.connect.ConnectProjectCallbackHandler;
import com.google.services.firebase.action.connect.FirebaseConnectStateManager;
import com.google.services.firebase.action.connect.FirebaseConnectSupportKt;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.consolereceiver.CancellableReceiver;
import com.google.services.firebase.consolereceiver.ReceiverResult;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.services.firebase.view.SelectModuleDialog;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.Messages;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JTextPane;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetConfiguration;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0002\u000e\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u001c\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00060\fH\u0002J\u0012\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/google/services/firebase/action/connect/FirebaseConnectSupport;", "", "()V", "connectToFirebase", "", "androidModule", "Lcom/intellij/openapi/module/Module;", "project", "Lcom/intellij/openapi/project/Project;", "filterEligibleModules", "", "modules", "", "getAndroidModuleToConnect", "ConnectDialogTask", "PrepareConnectDialogTask", "firebase"})
public final class FirebaseConnectSupport {
    @NotNull
    public static final FirebaseConnectSupport INSTANCE = new FirebaseConnectSupport();

    private FirebaseConnectSupport() {
    }

    @JvmStatic
    @UiThread
    public static final void connectToFirebase(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().assertIsDispatchThread();
        Module module = INSTANCE.getAndroidModuleToConnect(project);
        if (module == null) {
            return;
        }
        Module androidModule = module;
        FirebaseConnectSupport.connectToFirebase(androidModule);
    }

    @JvmStatic
    @UiThread
    public static final void connectToFirebase(@NotNull Module androidModule) {
        String applicationId;
        Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
        try {
            FirebaseUiUtils.checkGradleState(androidModule);
        }
        catch (FirebaseUiUtils.GradleStateException exception) {
            Messages.showWarningDialog((Project)androidModule.getProject(), (String)FirebaseBundle.message("firebaseService.userError.gradleSyncNeeded", new Object[0]), (String)FirebaseBundle.message("firebase.service.dialog.title", new Object[0]));
            return;
        }
        AndroidModel androidModel = AndroidModel.get((Module)androidModule);
        String string = applicationId = androidModel != null ? androidModel.getApplicationId() : null;
        if (Intrinsics.areEqual((Object)applicationId, (Object)"uninitialized.application.id")) {
            ApplicationManager.getApplication().invokeLater(new Runnable(androidModule){
                final /* synthetic */ Module $androidModule;
                {
                    this.$androidModule = $androidModule;
                }

                public final void run() {
                    if (Messages.showOkCancelDialog((Project)this.$androidModule.getProject(), (String)FirebaseBundle.message("connect.gradlebuild.dialog.message", new Object[0]), (String)FirebaseBundle.message("connect.gradlebuild.dialog.title", new Object[0]), (String)FirebaseBundle.message("connect.gradlebuild.dialog.button.OKLabel", new Object[0]), (String)"Cancel", null) == 0) {
                        Project project = this.$androidModule.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"androidModule.project");
                        GradleBuildInvoker.Companion.getInstance(project).assemble(TestCompileType.ALL);
                    }
                }
            });
            return;
        }
        new PrepareConnectDialogTask(androidModule).queue();
    }

    private final Module getAndroidModuleToConnect(Project project) {
        List list = GradleProjectInfo.getInstance((Project)project).getAndroidModules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstance(project).androidModules");
        List<Module> eligibleModules = this.filterEligibleModules(list);
        if (eligibleModules.isEmpty()) {
            FirebaseUiUtils.showTrackedErrorBalloon(project, null, "firebaseConnectAction.userError.couldNotFindAndroidModule", new Object[0]);
            return null;
        }
        Module module = (Module)CollectionsKt.singleOrNull(eligibleModules);
        if (module == null) {
            FirebaseConnectSupport $this$getAndroidModuleToConnect_u24lambda_u2d0 = this;
            boolean bl = false;
            SelectModuleDialog moduleDialog = new SelectModuleDialog(project, (Collection<? extends Module>)eligibleModules);
            module = moduleDialog.showAndGet() ? moduleDialog.getSelectedModule() : (Module)null;
        }
        return module;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Module> filterEligibleModules(Collection<? extends Module> modules) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = modules;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Module input = (Module)element$iv$iv;
            boolean bl = false;
            AndroidFacet androidFacet = AndroidFacet.getInstance((Module)input);
            boolean bl2 = androidFacet != null && (androidFacet = (AndroidFacetConfiguration)androidFacet.getConfiguration()) != null ? androidFacet.isAppProject() : false;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J \u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0003H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/google/services/firebase/action/connect/FirebaseConnectSupport$PrepareConnectDialogTask;", "Lcom/intellij/openapi/progress/Task$Backgroundable;", "androidModule", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/openapi/module/Module;)V", "run", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "showAlreadyConnectedDialog", "packageName", "", "projectDisplayName", "androidApplicationModule", "firebase"})
    private static final class PrepareConnectDialogTask
    extends Task.Backgroundable {
        @NotNull
        private final Module androidModule;

        public PrepareConnectDialogTask(@NotNull Module androidModule) {
            Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
            super(androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.action.preconnect.start", new Object[0]));
            this.androidModule = androidModule;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            Object packageName;
            FirebaseConfig firebaseConfig;
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            indicator.setIndeterminate(true);
            try {
                firebaseConfig = new FirebaseConfig(this.androidModule);
            }
            catch (FirebaseLocalConfig.InvalidLocalConfigException configException) {
                Project project = this.androidModule.getProject();
                String string = configException.getMessage();
                if (string == null) {
                    string = "";
                }
                FirebaseUiUtils.showErrorBalloon(project, string, (Throwable)((Object)configException));
                return;
            }
            FirebaseConfig firebaseConfig2 = firebaseConfig;
            if (indicator.isCanceled()) {
                return;
            }
            if (firebaseConfig2.getRegisterableAndroidClients().isEmpty()) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.error.no.clients", new Object[0]), null);
                return;
            }
            Set<AndroidClient> set = firebaseConfig2.getRegisterableAndroidClients();
            Intrinsics.checkNotNullExpressionValue(set, (String)"firebaseConfig.registerableAndroidClients");
            Object object = (AndroidClient)CollectionsKt.firstOrNull((Iterable)set);
            if (object == null || (object = ((AndroidClient)object).getPackageName()) == null) {
                object = "";
            }
            if (((CharSequence)(packageName = object)).length() == 0) {
                FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), "AndroidClientFound does not contain a package name", null);
                return;
            }
            String string = firebaseConfig2.getLocalFirebaseConfigProjectId();
            if (string != null) {
                String it = string;
                boolean bl = false;
                this.showAlreadyConnectedDialog((String)packageName, it, this.androidModule);
                return;
            }
            new ConnectDialogTask(this.androidModule, (String)packageName).queue();
        }

        private final void showAlreadyConnectedDialog(String packageName, String projectDisplayName, Module androidApplicationModule) {
            String EXTRA_CSS = "body { padding-bottom: 10px; background-color: " + UIUtils.getCssColor((Color)UIUtils.getAsStandardBackgroundColor()) + "; width: 500px; }";
            ApplicationManager.getApplication().invokeLater(new Runnable(projectDisplayName, EXTRA_CSS, androidApplicationModule, packageName){
                final /* synthetic */ String $projectDisplayName;
                final /* synthetic */ String $EXTRA_CSS;
                final /* synthetic */ Module $androidApplicationModule;
                final /* synthetic */ String $packageName;
                {
                    this.$projectDisplayName = $projectDisplayName;
                    this.$EXTRA_CSS = $EXTRA_CSS;
                    this.$androidApplicationModule = $androidApplicationModule;
                    this.$packageName = $packageName;
                }

                public final void run() {
                    JTextPane dialogBody = new JTextPane();
                    Object[] objectArray = new Object[]{this.$projectDisplayName};
                    UIUtils.setHtml((JEditorPane)dialogBody, (String)FirebaseBundle.message("connect.reconnect.dialog.matchFoundWithName", objectArray), (String)this.$EXTRA_CSS);
                    DialogBuilder dialogBuilder = new DialogBuilder(this.$androidApplicationModule.getProject());
                    dialogBuilder.setTitle(FirebaseBundle.message("connect.reconnect.dialog.title", new Object[0]));
                    dialogBuilder.setCenterPanel((JComponent)dialogBody);
                    dialogBuilder.removeAllActions();
                    dialogBuilder.addOkAction();
                    dialogBuilder.addCancelAction();
                    if (dialogBuilder.show() == 0) {
                        new ConnectDialogTask(this.$androidApplicationModule, this.$packageName).queue();
                    }
                }
            });
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u001c\u0010\n\u001a\u00020\u00052\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\fH\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/google/services/firebase/action/connect/FirebaseConnectSupport$ConnectDialogTask;", "Lcom/intellij/openapi/progress/Task$Modal;", "androidModule", "Lcom/intellij/openapi/module/Module;", "packageName", "", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "generateConsoleConnectUrl", "localPort", "", "mapAsUrlParameters", "params", "", "run", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "firebase"})
    private static final class ConnectDialogTask
    extends Task.Modal {
        @NotNull
        private final Module androidModule;
        @NotNull
        private final String packageName;

        public ConnectDialogTask(@NotNull Module androidModule, @NotNull String packageName) {
            Intrinsics.checkNotNullParameter((Object)androidModule, (String)"androidModule");
            Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
            super(androidModule.getProject(), FirebaseBundle.message("ui.connect.dialog.action.connect.start", new Object[0]), true);
            this.androidModule = androidModule;
            this.packageName = packageName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator progressIndicator) {
            Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
            try {
                AutoCloseable autoCloseable = new CancellableReceiver(ConnectProjectCallbackHandler.getFactory(this.androidModule));
                Throwable throwable = null;
                try {
                    CancellableReceiver server = (CancellableReceiver)autoCloseable;
                    boolean bl = false;
                    server.start();
                    BrowserUtil.browse((String)this.generateConsoleConnectUrl(server.getPort(), this.packageName));
                    ReceiverResult result2 = server.waitForRequest(new CancellableReceiver.Cancellable(progressIndicator){
                        final /* synthetic */ ProgressIndicator $progressIndicator;
                        {
                            this.$progressIndicator = $progressIndicator;
                        }

                        public final boolean isCancelled() {
                            return this.$progressIndicator.isCanceled();
                        }
                    });
                    if (result2.status == ReceiverResult.Status.SUCCESS) {
                        FirebaseUiUtils.showInfoBalloonWithLink(this.androidModule.getProject(), result2.resultMessage, new OpenUrlHyperlink("https://firebase.google.com/docs/android/setup", FirebaseBundle.message("firebase.service.notification.connect.process.complete.learnMore", new Object[0])));
                        FirebaseConnectStateManager.setCompletableState(this.androidModule, false);
                    } else {
                        FirebaseUiUtils.showErrorBalloon(this.androidModule.getProject(), result2.resultMessage, result2.exception);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
                }
            }
            catch (Exception e) {
                FirebaseConnectSupportKt.access$getLOGGER$p().warn("Exception while running FirebaseConnect local server.", (Throwable)e);
            }
        }

        private final String generateConsoleConnectUrl(int localPort, String packageName) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"forceCheckTos", (Object)"true"), TuplesKt.to((Object)"localPort", (Object)String.valueOf(localPort)), TuplesKt.to((Object)"packageName", (Object)packageName), TuplesKt.to((Object)"projectDisplayName", (Object)this.androidModule.getProject().getName())};
            String params = this.mapAsUrlParameters(MapsKt.mapOf((Pair[])pairArray));
            return "https://console.firebase.google.com/u/0/androidstudio/connectapp?" + params;
        }

        /*
         * WARNING - void declaration
         */
        private final String mapAsUrlParameters(Map<String, String> params) {
            void $this$mapTo$iv$iv;
            Map<String, String> $this$map$iv = params;
            boolean $i$f$map = false;
            Map<String, String> map2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String key = (String)entry.getKey();
                String value = (String)entry.getValue();
                collection.add(key + "=" + value);
            }
            return CollectionsKt.joinToString$default((Iterable)((List)destination$iv$iv), (CharSequence)"&", null, null, (int)0, null, null, (int)62, null);
        }
    }
}

