/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class FirebaseLogcatFilterProvider
implements LogcatFilterProvider {
    private static final AndroidLogcatFilter FILTER = new FirebaseLogcatFilter();

    @NotNull
    public AndroidLogcatFilter getFilter() {
        return FILTER;
    }

    private static class FirebaseLogcatFilter
    implements AndroidLogcatFilter {
        private static final Pattern TAG_PATTERN = Pattern.compile("FA|FirebaseRemoteConfig|StorageTask|NetworkRequest|Connection|PersistentConnection|WebSocket|RunLoop|Persistence|BackgroundTask|RepoOperation|Transaction|DataOperation|SyncTree|EventRaiser|FirebaseDatabase|ClassMapper|FirebaseMessaging|FirebaseInstanceId|AppInviteAgent|AppInstallOperation|AppInviteLogger|AppInviteAnalytics|AppInviteActivity|FirebaseAppIndex");

        private FirebaseLogcatFilter() {
        }

        @NotNull
        public String getName() {
            return "Firebase";
        }

        public boolean isApplicable(@NotNull LogCatMessage logCatMessage) {
            return TAG_PATTERN.matcher(logCatMessage.getHeader().getTag()).find();
        }
    }
}

