/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseTutorialBundle;
import com.google.services.firebase.FirebaseTutorialBundleCacheManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseBundleCreator
implements AssistantBundleCreator {
    private static final String TUTORIAL_REPLACEMENT_PROPERTY = "firebase.tutorialbundle";
    private static final String TUTORIAL_CONFIG_FILENAME = "/firebase_tutorial_bundle.xml";
    private FirebaseTutorialBundleCacheManager bundleManager = null;
    @NotNull
    public static final String BUNDLE_ID = "DeveloperServices.Firebase";

    private static Logger getLog() {
        return Logger.getInstance(FirebaseBundleCreator.class);
    }

    @NotNull
    public String getBundleId() {
        return BUNDLE_ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TutorialBundleData getBundle(@NotNull Project project) {
        FirebaseTutorialBundle myBundle = null;
        if (this.bundleManager == null) {
            this.bundleManager = new FirebaseTutorialBundleCacheManager();
        }
        InputStream inputStream = null;
        try {
            inputStream = this.getStreamForBundle(project);
            myBundle = FirebaseTutorialBundle.parse(inputStream, FirebaseTutorialBundle.class);
            myBundle.setIconProvider(this.bundleManager);
        }
        catch (IOException | JAXBException e) {
            FirebaseBundleCreator.getLog().error("Unable to parse /firebase_tutorial_bundle.xml to read services configuration.", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                FirebaseBundleCreator.getLog().warn((Throwable)e);
            }
        }
        return myBundle;
    }

    @Nullable
    public URL getConfig() {
        return null;
    }

    @NotNull
    public AnalyticsProvider getAnalyticsProvider() {
        return new FirebaseAnalyticsProvider();
    }

    private InputStream getStreamForBundle(Project project) throws IOException {
        URL resource = this.getClass().getResource(TUTORIAL_CONFIG_FILENAME);
        if (resource == null) {
            throw new RuntimeException(String.format("Could not find service file %1$s", TUTORIAL_CONFIG_FILENAME));
        }
        String replacementBundlePath = System.getProperty(TUTORIAL_REPLACEMENT_PROPERTY);
        if (replacementBundlePath != null) {
            File bundleFile = new File(replacementBundlePath);
            if (!bundleFile.exists()) {
                throw new RuntimeException(String.format("Could not find service file replaced by properties %1$s", replacementBundlePath));
            }
            return new FileInputStream(bundleFile);
        }
        this.bundleManager.updateTutorialBundleAsync(project);
        if (this.bundleManager.cacheHasBundle()) {
            return this.bundleManager.getStreamForBundle();
        }
        return resource.openStream();
    }
}

