/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.util;

import com.android.utils.Pair;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringHelper {
    public static String trimQuotations(String org) {
        if (org.length() > 2 && org.charAt(0) == '\"' && org.charAt(org.length() - 1) == '\"') {
            return org.substring(1, org.length() - 1);
        }
        return org;
    }

    public static String boxString(@NotNull String str) {
        return "\"" + StringUtil.escapeStringCharacters((String)str) + "\"";
    }

    public static String lowerCaseFirstCharacter(String originalString) {
        if (originalString.isEmpty()) {
            return originalString;
        }
        return originalString.substring(0, 1).toLowerCase() + (originalString.length() > 1 ? originalString.substring(1) : "");
    }

    @NotNull
    public static String getClassName(@NotNull String qualifiedClassName) {
        return qualifiedClassName.substring(qualifiedClassName.lastIndexOf(46) + 1);
    }

    @NotNull
    public static String getPackageName(@NotNull String qualifiedClassName) {
        int lastSeparatorIndex = qualifiedClassName.lastIndexOf(46);
        return lastSeparatorIndex != -1 ? qualifiedClassName.substring(0, lastSeparatorIndex) : "";
    }

    @Nullable
    public static Pair<String, String> parseId(@NotNull String resourceId) {
        String idMarker = ":id/";
        int idMarkerIndex = resourceId.indexOf(":id/");
        if (idMarkerIndex == -1) {
            return null;
        }
        return Pair.of((Object)resourceId.substring(0, idMarkerIndex), (Object)resourceId.substring(idMarkerIndex + ":id/".length()));
    }
}

