/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.ddmlib.IDevice;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.android.AndroidModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.api.dependencies.ArtifactDependencySpec;
import com.android.tools.idea.gradle.dsl.api.dependencies.DependencyModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.DependencyScopeType;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.android.uiautomator.UiAutomatorModel;
import com.android.uiautomator.tree.BasicTreeNode;
import com.android.uiautomator.tree.UiNode;
import com.google.common.collect.ImmutableList;
import com.google.gct.testrecorder.codegen.TestCodeGenerator;
import com.google.gct.testrecorder.event.ElementAction;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.event.TestRecorderEventListener;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.google.gct.testrecorder.ui.ScreenshotCallback;
import com.google.gct.testrecorder.ui.ScreenshotPanel;
import com.google.gct.testrecorder.ui.TestClassNameInputDialog;
import com.google.gct.testrecorder.ui.TestRecorderAction;
import com.google.gct.testrecorder.ui.TestRecorderListRenderer;
import com.google.gct.testrecorder.ui.TestRecorderScreenshotTask;
import com.google.gct.testrecorder.util.ClassHelper;
import com.google.gct.testrecorder.util.ImageHelper;
import com.google.gct.testrecorder.util.StringHelper;
import com.google.gct.testrecorder.util.UiAutomatorNodeHelper;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.GradleSyncStats;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.ex.FileSaverDialogImpl;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import com.intellij.psi.PsiClass;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.sun.jdi.request.BreakpointRequest;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecordingDialog
extends DialogWrapper
implements TestRecorderEventListener {
    private static final long ANIMATION_INTERVAL = 400L;
    private static final int ANIMATION_TIMER_INTERVAL = 10;
    private static final String ESPRESSO_CORE_CUSTOM_ARTIFACT_NAME = "espresso";
    private static final String ESPRESSO_CORE_CUSTOM_GROUP_NAME = "com.jakewharton.espresso";
    public static final String TEST_INSTRUMENTATION_RUNNER = "android.support.test.runner.AndroidJUnitRunner";
    public static final String ANDROIDX_TEST_INSTRUMENTATION_RUNNER = "androidx.test.runner.AndroidJUnitRunner";
    private static final GradleVersion MIN_ESPRESSO_CORE_VERSION_FOR_LARGE_TEST = GradleVersion.parse((String)"2.2.2");
    private static final GradleVersion MIN_RULES_VERSION_FOR_LARGE_TEST = GradleVersion.parse((String)"0.5");
    private static final GradleVersion MIN_ESPRESSO_CORE_VERSION_FOR_GRANT_PERMISSION_RULE = GradleVersion.parse((String)"3.0.0");
    private static final GradleVersion MIN_RULES_VERSION_FOR_GRANT_PERMISSION_RULE = GradleVersion.parse((String)"1.0.0");
    private static final GradleVersion MIN_ANDROIDX_ESPRESSO_CORE_VERSION = GradleVersion.parse((String)"3.3.0");
    private static final GradleVersion MIN_ANDROIDX_RULES_VERSION = GradleVersion.parse((String)"1.3.0");
    private static final GradleVersion MIN_ANDROIDX_EXT_JUNIT_VERSION = GradleVersion.parse((String)"1.1.3");
    private static String espressoCoreVersion = null;
    private static String androidxEspressoCoreVersion = null;
    private static String rulesVersion = null;
    private static String androidxRulesVersion = null;
    private static String androidxExtJunitVersion = null;
    public static final ImmutableList<ArtifactDependencySpec> ESPRESSO_CORE_EXCLUDES = ImmutableList.of((Object)RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS, null));
    public static final ImmutableList<ArtifactDependencySpec> ESPRESSO_CONTRIB_EXCLUDES = ImmutableList.of((Object)RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.SUPPORT_ANNOTATIONS, null), (Object)RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.SUPPORT_V4, null), (Object)RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.DESIGN, null), (Object)RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.RECYCLERVIEW_V7, null));
    private static final String TEST_RECORDING_DIALOG_TITLE = "Record Your Test";
    private static final String SCRIPT_RECORDING_DIALOG_TITLE = "Record Your Robo Script";
    private static final String DEFAULT_MESSAGE = "Select an element from screenshot";
    private final Project myProject;
    private final AndroidFacet myFacet;
    private final IDevice myDevice;
    private final String myPackageName;
    private final String myLaunchedActivityName;
    private final boolean myIsRecordingTest;
    private DebuggerSession myDebuggerSession;
    private boolean myAssertionMode;
    private int myAssertionIndex;
    private LinkedHashMap<BasicTreeNode, Integer> myNodeIndentMap;
    private DefaultComboBoxModel myElementComboBoxModel;
    private final DefaultListModel<ElementAction> myActionListModel;
    private boolean myIsRecording = true;
    private boolean myWasEverPaused = false;
    private boolean myNeedsContribDependency = false;
    private boolean myUsesAnyEspressoDependency = false;
    private boolean myUsesAndroidxDependency = false;
    private boolean myUsesGrantPermissionRule = false;
    private GradleVersion myMinEspressoCoreVersion = MIN_ESPRESSO_CORE_VERSION_FOR_LARGE_TEST;
    private final GradleVersion myMinAndroidxEspressoCoreVersion = MIN_ANDROIDX_ESPRESSO_CORE_VERSION;
    private GradleVersion myMinRulesVersion = MIN_RULES_VERSION_FOR_LARGE_TEST;
    private final GradleVersion myMinAndroidxRulesVersion = MIN_ANDROIDX_RULES_VERSION;
    private final GradleVersion myMinAndroidxExtJunitVersion = MIN_ANDROIDX_EXT_JUNIT_VERSION;
    private JPanel myRootPanel;
    private ScreenshotPanel myScreenshotPanel;
    private JPanel myActionListPanel;
    private JBScrollPane myScrollPane;
    private JBList<ElementAction> myActionList;
    private JPanel myAssertionPanel;
    private JPanel myButtonsPanel;
    private JButton myAddAssertionButton;
    private JButton myTakeScreenshotButton;
    private JPanel myEditAssertionPanel;
    private JComboBox myAssertionElementComboBox;
    private JComboBox myAssertionRuleComboBox;
    private JPanel myTextFieldWrapper;
    private JTextField myAssertionTextField;
    private JButton mySaveAssertionButton;
    private JButton myCancelButton;
    private JButton mySaveAssertionAndAddAnotherButton;
    private JPanel myRecordingPanel;
    private JButton myRecordPauseButton;

    public RecordingDialog(AndroidFacet facet, IDevice device, String packageName, String launchedActivityName, boolean isRecordingTest) {
        super(facet.getModule().getProject(), true, DialogWrapper.IdeModalityType.MODELESS);
        this.$$$setupUI$$$();
        this.myProject = facet.getModule().getProject();
        this.myFacet = facet;
        this.myDevice = device;
        this.myPackageName = packageName;
        this.myLaunchedActivityName = launchedActivityName;
        this.myIsRecordingTest = isRecordingTest;
        this.myAssertionMode = false;
        this.init();
        this.setTitle(this.myIsRecordingTest ? TEST_RECORDING_DIALOG_TITLE : SCRIPT_RECORDING_DIALOG_TITLE);
        this.getRootPane().setDefaultButton(this.getButton(this.getOKAction()));
        this.myTakeScreenshotButton.setVisible(false);
        this.myActionList.setEmptyText("No actions recorded yet.");
        this.myActionListModel = new DefaultListModel();
        this.myActionList.setModel(this.myActionListModel);
        this.myActionList.setCellRenderer((ListCellRenderer)new TestRecorderListRenderer());
        if (!this.myIsRecordingTest) {
            this.myAssertionPanel.setVisible(false);
            this.myRecordPauseButton.setVisible(false);
        } else {
            this.myRecordPauseButton.setVisible(TestRecorderSettings.getInstance().ENABLE_TEST_FRAGMENT_RECORDING);
        }
        this.myRecordPauseButton.setIcon(AllIcons.Actions.Pause);
        this.myRecordPauseButton.addActionListener(e -> {
            this.myWasEverPaused = true;
            this.myIsRecording = !this.myIsRecording;
            this.updateRecordPauseButton();
            this.toggleDebugging();
        });
        this.myAddAssertionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new TestRecorderScreenshotTask(RecordingDialog.this.myProject, RecordingDialog.this.myDevice, RecordingDialog.this.myPackageName, new ScreenshotCallback(){

                    @Override
                    public void onSuccess(BufferedImage initialImage, UiAutomatorModel model) {
                        RecordingDialog.this.myAssertionMode = true;
                        RecordingDialog.this.getRootPane().setDefaultButton(RecordingDialog.this.mySaveAssertionAndAddAnotherButton);
                        BasicTreeNode root = model.getXmlRootNode();
                        String applicationId = RecordingDialog.this.getApplicationId("");
                        if (!applicationId.isEmpty() && !applicationId.equals(UiAutomatorNodeHelper.getAppPackageName(root))) {
                            Messages.showMessageDialog((Component)RecordingDialog.this.myRootPanel, (String)"Out-of-app assertions are not supported and will break the generated Espresso test.", (String)"Warning: adding an out-of-app assertion", null);
                        }
                        BufferedImage preparedImage = ImageHelper.rotateImage(initialImage, UiAutomatorNodeHelper.getRotation(root));
                        RecordingDialog.this.myScreenshotPanel.updateScreenShot(preparedImage, model);
                        RecordingDialog.this.myNodeIndentMap = UiAutomatorNodeHelper.createElementLevelMap(root);
                        RecordingDialog.this.myElementComboBoxModel = new DefaultComboBoxModel<Object>(RecordingDialog.this.myNodeIndentMap.keySet().toArray());
                        RecordingDialog.this.myElementComboBoxModel.insertElementAt(RecordingDialog.DEFAULT_MESSAGE, 0);
                        CardLayout cardLayout = (CardLayout)RecordingDialog.this.myAssertionPanel.getLayout();
                        cardLayout.show(RecordingDialog.this.myAssertionPanel, "myEditAssertionPanel");
                        RecordingDialog.this.setUpEmptyAssertionPanel();
                        RecordingDialog.this.myAssertionIndex = RecordingDialog.this.myActionListModel.size();
                        RecordingDialog.this.revealScreenshotPanel(preparedImage.getWidth(), preparedImage.getHeight());
                    }
                }).queue();
            }
        });
        this.myTakeScreenshotButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
            }
        });
        this.mySaveAssertionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordingDialog.this.exitAssertionMode(true);
                RecordingDialog.this.hideScreenshotPanel();
            }
        });
        this.mySaveAssertionAndAddAnotherButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordingDialog.this.myActionListModel.add(RecordingDialog.this.myAssertionIndex, RecordingDialog.this.buildAssertionForCurrentSelection());
                RecordingDialog.this.myActionList.ensureIndexIsVisible(RecordingDialog.this.myAssertionIndex);
                ++RecordingDialog.this.myAssertionIndex;
            }
        });
        this.myCancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                RecordingDialog.this.exitAssertionMode(false);
                RecordingDialog.this.hideScreenshotPanel();
            }
        });
        this.myAssertionElementComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object element = RecordingDialog.this.myAssertionElementComboBox.getSelectedItem();
                if (element instanceof BasicTreeNode) {
                    BasicTreeNode node = (BasicTreeNode)element;
                    RecordingDialog.this.myScreenshotPanel.setSelectedNodeAndRepaint(node);
                    if (UiAutomatorNodeHelper.isTextView(node)) {
                        CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                        cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myAssertionTextField");
                        RecordingDialog.this.myAssertionTextField.setText(UiAutomatorNodeHelper.getText(node));
                        RecordingDialog.this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITH_TEXT));
                    } else {
                        CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                        cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myPlaceHolder");
                        RecordingDialog.this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITHOUT_TEXT));
                    }
                    RecordingDialog.this.mySaveAssertionButton.setEnabled(true);
                    RecordingDialog.this.mySaveAssertionAndAddAnotherButton.setEnabled(true);
                    RecordingDialog.this.myAssertionTextField.setForeground((Color)JBColor.BLACK);
                } else {
                    RecordingDialog.this.myScreenshotPanel.clearSelectionAndRepaint();
                }
            }
        });
        this.myAssertionElementComboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value instanceof BasicTreeNode) {
                    String resourceId;
                    BasicTreeNode node = (BasicTreeNode)value;
                    int indent = RecordingDialog.this.myNodeIndentMap.get(node);
                    String prefix = StringUtils.repeat((String)"  ", (int)indent);
                    if (index == -1) {
                        prefix = "";
                    }
                    String nodeString = (resourceId = UiAutomatorNodeHelper.getResourceId(node)).isEmpty() ? UiAutomatorNodeHelper.getClassName(node) : resourceId;
                    return super.getListCellRendererComponent((JList<?>)list, prefix + nodeString, index, isSelected, cellHasFocus);
                }
                return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            }
        });
        this.myAssertionRuleComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                Object selectedItem = RecordingDialog.this.myAssertionRuleComboBox.getSelectedItem();
                if (selectedItem == null) {
                    return;
                }
                String rule = selectedItem.toString();
                if ("text is".equals(rule)) {
                    CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                    cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myAssertionTextField");
                } else {
                    CardLayout cardLayout = (CardLayout)RecordingDialog.this.myTextFieldWrapper.getLayout();
                    cardLayout.show(RecordingDialog.this.myTextFieldWrapper, "myPlaceHolder");
                }
            }
        });
    }

    private static String getEspressoCoreVersion() {
        if (espressoCoreVersion == null) {
            espressoCoreVersion = RecordingDialog.getLatestDependencyVersion(GoogleMavenArtifactId.ESPRESSO_CORE, "3.0.2");
        }
        return espressoCoreVersion;
    }

    private static String getAndroidxEspressoCoreVersion() {
        if (androidxEspressoCoreVersion == null) {
            androidxEspressoCoreVersion = RecordingDialog.getLatestDependencyVersion(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE, "3.3.0");
        }
        return androidxEspressoCoreVersion;
    }

    private static String getRulesVersion() {
        if (rulesVersion == null) {
            rulesVersion = RecordingDialog.getLatestDependencyVersion(GoogleMavenArtifactId.TEST_RULES, "1.0.2");
        }
        return rulesVersion;
    }

    private static String getAndroidxRulesVersion() {
        if (androidxRulesVersion == null) {
            androidxRulesVersion = RecordingDialog.getLatestDependencyVersion(GoogleMavenArtifactId.ANDROIDX_TEST_RULES, "1.3.0");
        }
        return androidxRulesVersion;
    }

    private static String getAndroidxExtJunitVersion() {
        if (androidxExtJunitVersion == null) {
            androidxExtJunitVersion = RecordingDialog.getLatestDependencyVersion(GoogleMavenArtifactId.ANDROIDX_TEST_EXT_JUNIT, "1.1.3");
        }
        return androidxExtJunitVersion;
    }

    public void setDebuggerSession(DebuggerSession debuggerSession) {
        this.myDebuggerSession = debuggerSession;
        this.myIsRecording = this.myDebuggerSession != null;
        this.myRecordPauseButton.setEnabled(this.myIsRecording);
        this.updateRecordPauseButton();
    }

    private void updateRecordPauseButton() {
        if (this.myIsRecording) {
            this.myRecordPauseButton.setText("Pause");
            this.myRecordPauseButton.setIcon(AllIcons.Actions.Pause);
        } else {
            this.myRecordPauseButton.setText("Resume");
            this.myRecordPauseButton.setIcon(TestRecorderAction.TEST_RECORDER_ICON);
        }
    }

    private void toggleDebugging() {
        if (this.myDebuggerSession != null) {
            List<BreakpointRequest> requests = this.myDebuggerSession.getProcess().getRequestsManager().getVMRequestManager().breakpointRequests();
            for (BreakpointRequest request : requests) {
                request.setEnabled(this.myIsRecording);
            }
        }
    }

    private static String getLatestDependencyVersion(GoogleMavenArtifactId artifactId, String fallbackVersion) {
        GradleCoordinate gradleCoordinate;
        String latestDependencyCoordinate = RepositoryUrlManager.get().getArtifactStringCoordinate(artifactId, true);
        if (latestDependencyCoordinate != null && (gradleCoordinate = GradleCoordinate.parseCoordinateString((String)latestDependencyCoordinate)) != null) {
            return gradleCoordinate.getRevision();
        }
        return fallbackVersion;
    }

    static String getJsonForActions(Project project, List<ElementAction> actions) {
        ArrayList<TestRecorderEvent> testRecorderEvents = new ArrayList<TestRecorderEvent>();
        for (ElementAction action : actions) {
            if (!(action instanceof TestRecorderEvent)) continue;
            testRecorderEvents.add((TestRecorderEvent)action);
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(ElementDescriptor.class, (Object)new ElementDescriptorSerializer(project));
        return gsonBuilder.setPrettyPrinting().create().toJson(testRecorderEvents);
    }

    @NotNull
    private static ArtifactDependencySpec createArtifactDependencySpec(@NotNull GoogleMavenArtifactId artifactId, @Nullable String version) {
        return ArtifactDependencySpec.create((String)artifactId.getMavenArtifactId(), (String)artifactId.getMavenGroupId(), (String)version);
    }

    @NotNull
    protected String getHelpId() {
        return this.myIsRecordingTest ? "https://developer.android.com/r/studio-ui/test-recorder.html" : "https://firebase.google.com/docs/test-lab/robo-ux-test#scripting";
    }

    protected void doHelpAction() {
        BrowserUtil.browse((String)this.getHelpId());
    }

    protected void doOKAction() {
        if (this.myIsRecordingTest) {
            AndroidModel androidModel;
            GradleBuildModel gradleBuildModel;
            Manifest manifest;
            TestClassNameInputDialog chooser = new TestClassNameInputDialog(this.myFacet.getModule(), this.myLaunchedActivityName);
            chooser.show();
            PsiClass testClass = chooser.getTestClass();
            if (testClass == null) {
                return;
            }
            Module testClassModule = chooser.getTestClassModule();
            String resourcePackageName = "unknown";
            AndroidFacet testClassFacet = AndroidFacet.getInstance((Module)testClassModule);
            if (testClassFacet != null && (manifest = Manifest.getMainManifest((AndroidFacet)testClassFacet)) != null) {
                resourcePackageName = manifest.getPackage().getStringValue();
            }
            String applicationId = this.getApplicationId(resourcePackageName);
            if (resourcePackageName == null) {
                resourcePackageName = applicationId;
            }
            if ((gradleBuildModel = GradleBuildModel.get((Module)testClassModule)) != null && !this.hasAllRequiredEspressoDependencies(androidModel = gradleBuildModel.android(), ProjectSystemUtil.getModuleSystem((Module)testClassModule))) {
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_MISSING_ESPRESSO_DEPENDENCIES), (Project)this.myProject));
                if (((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)"Missing or obsolete Espresso dependencies", (String)"Some dependencies for running Espresso tests are missing or obsolete.\nWould you like to automatically add/update Espresso dependencies for this app?\nTo complete the set up, Gradle might ask you to install the missing libraries.\nPlease click on the corresponding link(s) to install them.").icon(null)).ask((Component)this.myRootPanel)) {
                    this.setupEspresso(gradleBuildModel);
                }
            }
            super.doOKAction();
            new TestCodeGenerator(resourcePackageName, applicationId, testClassModule, testClass, this.getAllModelActions(), this.myLaunchedActivityName, this.myWasEverPaused, chooser.isKotlinTestClass(), this.myUsesAndroidxDependency).generate();
        } else {
            FileSaverDescriptor descriptor = new FileSaverDescriptor("Save Robo Script", "Save Robo script to a file", new String[]{"json"});
            FileSaverDialogImpl fileSaverDialog = new FileSaverDialogImpl(descriptor, this.myProject);
            VirtualFileWrapper fileWrapper = fileSaverDialog.save((VirtualFile)null, StringHelper.getClassName(this.myLaunchedActivityName) + "_robo_script");
            if (fileWrapper != null) {
                try {
                    FileUtils.write((File)fileWrapper.getFile(), (CharSequence)RecordingDialog.getJsonForActions(this.myProject, this.getAllModelActions()));
                }
                catch (Exception ex) {
                    String message = StringUtils.isEmpty((String)ex.getMessage()) ? "Unknown error" : ex.getMessage();
                    Messages.showMessageDialog((Component)this.myRootPanel, (String)message, (String)"Could not save Robo script to a file", null);
                }
            }
            if (fileSaverDialog.isOK()) {
                UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_SAVE_ROBO_SCRIPT), (Project)this.myProject));
                super.doOKAction();
            }
        }
    }

    private String getApplicationId(String defaultId) {
        try {
            return ProjectSystemUtil.getModuleSystem((AndroidFacet)this.myFacet).getApplicationIdProvider().getPackageName();
        }
        catch (Exception e) {
            return defaultId;
        }
    }

    private List<ElementAction> getAllModelActions() {
        return Collections.list(this.myActionListModel.elements());
    }

    private void exitAssertionMode(boolean shouldAddAssertion) {
        this.myAssertionMode = false;
        this.getRootPane().setDefaultButton(this.getButton(this.getOKAction()));
        CardLayout cardLayout = (CardLayout)this.myAssertionPanel.getLayout();
        cardLayout.show(this.myAssertionPanel, "myButtonsPanel");
        if (shouldAddAssertion) {
            this.myActionListModel.add(this.myAssertionIndex, this.buildAssertionForCurrentSelection());
            this.myActionList.ensureIndexIsVisible(this.myAssertionIndex);
        } else {
            this.myActionList.ensureIndexIsVisible(this.myActionListModel.size() - 1);
        }
    }

    private void revealScreenshotPanel(int imageWidth, int imageHeight) {
        this.myRecordingPanel.setMinimumSize(new Dimension(this.myRecordingPanel.getWidth(), this.myRecordingPanel.getHeight()));
        this.myScreenshotPanel.setVisible(true);
        final int screenshotPanelTotalHeight = this.myRootPanel.getHeight();
        int scaledImageWidth = imageHeight <= screenshotPanelTotalHeight ? imageWidth : (int)((double)(imageWidth * screenshotPanelTotalHeight) / (double)imageHeight);
        final int screenshotPanelTotalWidth = scaledImageWidth > screenshotPanelTotalHeight ? screenshotPanelTotalHeight : scaledImageWidth;
        final Timer t = new Timer(10, null);
        final long start = System.currentTimeMillis();
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed > 400L || SystemInfoRt.isMac) {
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension(screenshotPanelTotalWidth, screenshotPanelTotalHeight));
                    t.stop();
                } else {
                    double percentRevealed = (double)elapsed / 400.0;
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension((int)((double)screenshotPanelTotalWidth * percentRevealed), screenshotPanelTotalHeight));
                }
                RecordingDialog.this.myScreenshotPanel.clearSelectionAndRepaint();
                RecordingDialog.this.getWindow().pack();
                RecordingDialog.this.myAssertionElementComboBox.requestFocusInWindow();
            }
        });
        t.start();
    }

    private void hideScreenshotPanel() {
        final int screenshotPanelInitialWidth = this.myScreenshotPanel.getWidth();
        final int screenshotPanelInitialHeight = this.myScreenshotPanel.getHeight();
        final int marginWidth = ((FlowLayout)this.myScreenshotPanel.getLayout()).getHgap() * 2;
        final int windowInitialWidth = this.getWindow().getWidth();
        final Timer t = new Timer(10, null);
        final long start = System.currentTimeMillis();
        t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                long elapsed = System.currentTimeMillis() - start;
                if (elapsed > 400L || SystemInfoRt.isMac) {
                    RecordingDialog.this.myScreenshotPanel.setVisible(false);
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension(0, 0));
                    RecordingDialog.this.getWindow().setMinimumSize(new Dimension(windowInitialWidth - screenshotPanelInitialWidth - marginWidth, RecordingDialog.this.getWindow().getHeight()));
                    t.stop();
                } else {
                    double percentHidden = (double)elapsed / 400.0;
                    RecordingDialog.this.myScreenshotPanel.setMinimumSize(new Dimension((int)((double)screenshotPanelInitialWidth * (1.0 - percentHidden)), screenshotPanelInitialHeight));
                    RecordingDialog.this.getWindow().setMinimumSize(new Dimension(windowInitialWidth - (int)((double)screenshotPanelInitialWidth * percentHidden) - marginWidth, RecordingDialog.this.getWindow().getHeight()));
                }
                RecordingDialog.this.myScreenshotPanel.clearSelectionAndRepaint();
                RecordingDialog.this.getWindow().pack();
            }
        });
        t.start();
    }

    private void createUIComponents() {
        this.myScreenshotPanel = new ScreenshotPanel(this);
        this.myScreenshotPanel.setPreferredSize(new Dimension(0, 0));
        this.myScreenshotPanel.setVisible(false);
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBDimension initialSize = JBUI.size((int)450, (int)600);
        this.myRootPanel.setPreferredSize((Dimension)initialSize);
        this.myRecordingPanel.setMinimumSize((Dimension)initialSize);
        return this.myRootPanel;
    }

    private boolean hasAllRequiredEspressoDependencies(@NotNull AndroidModel androidModel, @NotNull AndroidModuleSystem androidModuleSystem) {
        this.initializeDependencyRequirements();
        return !(!this.hasUptodateEspressoCoreDependency(androidModuleSystem) || !this.hasUptodateRulesDependency(androidModuleSystem) || this.myNeedsContribDependency && !this.hasUptodateEspressoContribDependency(androidModuleSystem) || this.myUsesAndroidxDependency && this.myUsesGrantPermissionRule && !this.hasUptodateAndroidxRulesDependency(androidModuleSystem) || !RecordingDialog.hasSetInstrumentationRunner(androidModel));
    }

    private void initializeDependencyRequirements() {
        this.myNeedsContribDependency = false;
        this.myUsesAnyEspressoDependency = false;
        this.myUsesAndroidxDependency = false;
        this.myUsesGrantPermissionRule = false;
        this.myMinEspressoCoreVersion = MIN_ESPRESSO_CORE_VERSION_FOR_LARGE_TEST;
        this.myMinRulesVersion = MIN_RULES_VERSION_FOR_LARGE_TEST;
        for (ElementAction action : this.getAllModelActions()) {
            if (!(action instanceof TestRecorderEvent)) continue;
            TestRecorderEvent testRecorderEvent = (TestRecorderEvent)action;
            if (testRecorderEvent.getElementRecyclerViewChildPosition() != -1) {
                this.myNeedsContribDependency = true;
                continue;
            }
            if (!testRecorderEvent.isPermissionsRequest()) continue;
            this.myUsesGrantPermissionRule = true;
            this.myMinEspressoCoreVersion = MIN_ESPRESSO_CORE_VERSION_FOR_GRANT_PERMISSION_RULE;
            this.myMinRulesVersion = MIN_RULES_VERSION_FOR_GRANT_PERMISSION_RULE;
        }
    }

    private boolean hasUptodateEspressoCoreDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
        String artifact = GoogleMavenArtifactId.ESPRESSO_CORE.toString();
        String androidxArtifact = GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE.toString();
        return this.hasUptodateDependency(androidModuleSystem, artifact, androidxArtifact, this.myMinEspressoCoreVersion, this.myMinAndroidxEspressoCoreVersion);
    }

    private boolean hasUptodateRulesDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
        String artifact = GoogleMavenArtifactId.TEST_RULES.toString();
        String androidxArtifact = GoogleMavenArtifactId.ANDROIDX_TEST_EXT_JUNIT.toString();
        return this.hasUptodateDependency(androidModuleSystem, artifact, androidxArtifact, this.myMinRulesVersion, this.myMinAndroidxExtJunitVersion);
    }

    private boolean hasUptodateEspressoContribDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
        String artifact = GoogleMavenArtifactId.ESPRESSO_CONTRIB.toString();
        String androidxArtifact = GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB.toString();
        return this.hasUptodateDependency(androidModuleSystem, artifact, androidxArtifact, this.myMinEspressoCoreVersion, this.myMinAndroidxEspressoCoreVersion);
    }

    private boolean hasUptodateAndroidxRulesDependency(@NotNull AndroidModuleSystem androidModuleSystem) {
        String androidxArtifact = GoogleMavenArtifactId.ANDROIDX_TEST_RULES.toString();
        return this.hasUptodateDependency(androidModuleSystem, "", androidxArtifact, this.myMinRulesVersion, this.myMinAndroidxRulesVersion);
    }

    private static boolean hasSetInstrumentationRunner(@NotNull AndroidModel androidModel) {
        String testInstrumentationRunner = (String)androidModel.defaultConfig().testInstrumentationRunner().getValue(GradlePropertyModel.STRING_TYPE);
        return testInstrumentationRunner != null && !testInstrumentationRunner.isEmpty();
    }

    private boolean hasUptodateDependency(@NotNull AndroidModuleSystem androidModuleSystem, String artifact, String androidxArtifact, GradleVersion minVersion, GradleVersion androidxMinVersion) {
        GradleVersion dependencyVersion = RecordingDialog.getDependencyVersion(androidModuleSystem, artifact);
        if (dependencyVersion != null) {
            this.myUsesAnyEspressoDependency = true;
            return dependencyVersion.compareTo(minVersion) >= 0;
        }
        GradleVersion androidxDependencyVersion = RecordingDialog.getDependencyVersion(androidModuleSystem, androidxArtifact);
        if (androidxDependencyVersion != null) {
            this.myUsesAnyEspressoDependency = true;
            this.myUsesAndroidxDependency = true;
            return androidxDependencyVersion.compareTo(androidxMinVersion) >= 0;
        }
        return false;
    }

    @Nullable
    private static GradleVersion getDependencyVersion(@NotNull AndroidModuleSystem androidModuleSystem, String artifact) {
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)(artifact + ":+"));
        if (coordinate == null) {
            return null;
        }
        GradleCoordinate resolvedDependency = androidModuleSystem.getResolvedDependency(coordinate, DependencyScopeType.ANDROID_TEST);
        if (resolvedDependency == null) {
            return null;
        }
        return resolvedDependency.getVersion();
    }

    private GoogleMavenArtifactId getEspressoArtifactId() {
        return this.myUsesAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE : GoogleMavenArtifactId.ESPRESSO_CORE;
    }

    private String getEspressoArtifactUpdateVersion() {
        return this.myUsesAndroidxDependency ? RecordingDialog.getAndroidxEspressoCoreVersion() : RecordingDialog.getEspressoCoreVersion();
    }

    private GoogleMavenArtifactId getEspressoContribArtifactId() {
        return this.myUsesAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB : GoogleMavenArtifactId.ESPRESSO_CONTRIB;
    }

    private GoogleMavenArtifactId getTestRulesArtifactId() {
        return this.myUsesAndroidxDependency ? GoogleMavenArtifactId.ANDROIDX_TEST_EXT_JUNIT : GoogleMavenArtifactId.TEST_RULES;
    }

    private String getTestRulesArtifactUpdateVersion() {
        return this.myUsesAndroidxDependency ? RecordingDialog.getAndroidxExtJunitVersion() : RecordingDialog.getRulesVersion();
    }

    private void setupEspresso(final @NotNull GradleBuildModel gradleBuildModel) {
        if (!this.myUsesAnyEspressoDependency) {
            AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem((Module)this.myFacet.getModule());
            for (GoogleMavenArtifactId artifactId : GoogleMavenArtifactId.values()) {
                GradleCoordinate coordinate;
                if (!artifactId.getMavenGroupId().startsWith("androidx.") && !artifactId.getMavenGroupId().equals("com.google.android.material") || (coordinate = moduleSystem.getResolvedDependency(artifactId.getCoordinate("+"))) == null) continue;
                this.myUsesAndroidxDependency = true;
                break;
            }
        }
        new Task.Modal(this.myProject, "Setting up Espresso", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Adding Espresso dependencies");
                indicator.setIndeterminate(true);
                try {
                    Thread.sleep(500L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                WriteCommandAction.runWriteCommandAction((Project)this.myProject, () -> {
                    AndroidModel androidModel;
                    this.addOrUpdateEspressoCoreDependency();
                    this.addOrUpdateRulesDependency();
                    if (RecordingDialog.this.myNeedsContribDependency) {
                        this.addOrUpdateEspressoContribDependency();
                    }
                    if (RecordingDialog.this.myUsesAndroidxDependency && RecordingDialog.this.myUsesGrantPermissionRule) {
                        this.addOrUpdateAndroidxRulesDependency();
                    }
                    if ((androidModel = gradleBuildModel.android()) != null && !RecordingDialog.hasSetInstrumentationRunner(androidModel)) {
                        androidModel.defaultConfig().testInstrumentationRunner().setValue((Object)(RecordingDialog.this.myUsesAndroidxDependency ? RecordingDialog.ANDROIDX_TEST_INSTRUMENTATION_RUNNER : RecordingDialog.TEST_INSTRUMENTATION_RUNNER));
                    }
                    gradleBuildModel.applyChanges();
                    if (this.myProject != null) {
                        ProjectSystemUtil.getProjectSystem((Project)this.myProject).getSyncManager().syncProject(new ProjectSystemSyncManager.SyncReason(GradleSyncStats.Trigger.TRIGGER_ESPRESSO_SETUP));
                    }
                });
            }

            private void addOrUpdateEspressoCoreDependency() {
                boolean hasUpdatedEspressoCoreVersion = false;
                for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                    if (RecordingDialog.ESPRESSO_CORE_CUSTOM_GROUP_NAME.equals(artifact.group().toString()) && RecordingDialog.ESPRESSO_CORE_CUSTOM_ARTIFACT_NAME.equals(artifact.name().forceString())) {
                        gradleBuildModel.dependencies().remove((DependencyModel)artifact);
                        continue;
                    }
                    if (this.isMatchingArtifact(artifact, RecordingDialog.this.getEspressoArtifactId())) {
                        artifact.version().setValue((Object)RecordingDialog.this.getEspressoArtifactUpdateVersion());
                        hasUpdatedEspressoCoreVersion = true;
                        continue;
                    }
                    if (this.isMatchingArtifact(artifact, RecordingDialog.this.getEspressoContribArtifactId())) {
                        artifact.version().setValue((Object)RecordingDialog.this.getEspressoArtifactUpdateVersion());
                        continue;
                    }
                    if (this.isMatchingArtifact(artifact, RecordingDialog.this.getTestRulesArtifactId())) {
                        artifact.version().setValue((Object)RecordingDialog.this.getTestRulesArtifactUpdateVersion());
                        continue;
                    }
                    if (!this.isMatchingArtifact(artifact, GoogleMavenArtifactId.ANDROIDX_TEST_RULES)) continue;
                    artifact.version().setValue((Object)RecordingDialog.getAndroidxRulesVersion());
                }
                if (!hasUpdatedEspressoCoreVersion) {
                    if (RecordingDialog.this.myUsesAndroidxDependency) {
                        gradleBuildModel.dependencies().addArtifact("androidTestImplementation", RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CORE, RecordingDialog.getAndroidxEspressoCoreVersion()));
                    } else {
                        gradleBuildModel.dependencies().addArtifact("androidTestImplementation", RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.ESPRESSO_CORE, RecordingDialog.getEspressoCoreVersion()), ESPRESSO_CORE_EXCLUDES);
                    }
                }
            }

            private void addOrUpdateRulesDependency() {
                for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                    if (!this.isMatchingArtifact(artifact, RecordingDialog.this.getTestRulesArtifactId())) continue;
                    artifact.version().setValue((Object)RecordingDialog.this.getTestRulesArtifactUpdateVersion());
                    return;
                }
                gradleBuildModel.dependencies().addArtifact("androidTestImplementation", RecordingDialog.createArtifactDependencySpec(RecordingDialog.this.getTestRulesArtifactId(), RecordingDialog.this.getTestRulesArtifactUpdateVersion()));
            }

            private void addOrUpdateAndroidxRulesDependency() {
                for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                    if (!this.isMatchingArtifact(artifact, GoogleMavenArtifactId.ANDROIDX_TEST_RULES)) continue;
                    artifact.version().setValue((Object)RecordingDialog.getAndroidxRulesVersion());
                    return;
                }
                gradleBuildModel.dependencies().addArtifact("androidTestImplementation", RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_TEST_RULES, RecordingDialog.getAndroidxRulesVersion()));
            }

            private void addOrUpdateEspressoContribDependency() {
                for (ArtifactDependencyModel artifact : gradleBuildModel.dependencies().artifacts()) {
                    if (!this.isMatchingArtifact(artifact, RecordingDialog.this.getEspressoContribArtifactId())) continue;
                    artifact.version().setValue((Object)RecordingDialog.this.getEspressoArtifactUpdateVersion());
                    return;
                }
                if (RecordingDialog.this.myUsesAndroidxDependency) {
                    gradleBuildModel.dependencies().addArtifact("androidTestImplementation", RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.ANDROIDX_ESPRESSO_CONTRIB, RecordingDialog.getAndroidxEspressoCoreVersion()));
                } else {
                    gradleBuildModel.dependencies().addArtifact("androidTestImplementation", RecordingDialog.createArtifactDependencySpec(GoogleMavenArtifactId.ESPRESSO_CONTRIB, RecordingDialog.getEspressoCoreVersion()), ESPRESSO_CONTRIB_EXCLUDES);
                }
            }

            private boolean isMatchingArtifact(ArtifactDependencyModel artifact, GoogleMavenArtifactId artifactId) {
                return artifactId.getMavenGroupId().equals(artifact.group().toString()) && artifactId.getMavenArtifactId().equals(artifact.name().forceString());
            }
        }.queue();
    }

    private TestRecorderAssertion buildAssertionForCurrentSelection() {
        UiNode node = (UiNode)this.myAssertionElementComboBox.getSelectedItem();
        String rule = "exists";
        Object assertionRuleSelectedItem = this.myAssertionRuleComboBox.getSelectedItem();
        if (assertionRuleSelectedItem != null) {
            rule = assertionRuleSelectedItem.toString();
        }
        TestRecorderAssertion assertion = new TestRecorderAssertion(rule);
        this.addElementDescriptors(assertion, node);
        if ("text is".equals(rule)) {
            assertion.setText(this.myAssertionTextField.getText());
        }
        return assertion;
    }

    private void addElementDescriptors(TestRecorderAssertion assertion, UiNode node) {
        if (node == null || assertion.getElementDescriptorsCount() >= TestRecorderSettings.getInstance().ASSERTION_DEPTH) {
            return;
        }
        String className = UiAutomatorNodeHelper.getClassName((BasicTreeNode)node);
        String resourceId = UiAutomatorNodeHelper.getResourceId((BasicTreeNode)node);
        String text = UiAutomatorNodeHelper.getText((BasicTreeNode)node);
        String contentDescription = UiAutomatorNodeHelper.getContentDescription((BasicTreeNode)node);
        int viewGroupChildPosition = UiAutomatorNodeHelper.getViewGroupChildPosition((BasicTreeNode)node);
        if (!(className.isEmpty() && resourceId.isEmpty() && text.isEmpty() && contentDescription.isEmpty() && viewGroupChildPosition == -1)) {
            assertion.addElementDescriptor(new ElementDescriptor(className, -1, -1, viewGroupChildPosition, resourceId, contentDescription, text));
            if (node.getParent() instanceof UiNode) {
                this.addElementDescriptors(assertion, (UiNode)node.getParent());
            }
        }
    }

    protected void setUpEmptyAssertionPanel() {
        this.myAssertionElementComboBox.setModel(this.myElementComboBoxModel);
        this.myAssertionElementComboBox.setSelectedIndex(0);
        this.myAssertionElementComboBox.setForeground((Color)JBColor.BLACK);
        this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel());
        CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
        cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
        this.mySaveAssertionButton.setEnabled(false);
        this.mySaveAssertionAndAddAnotherButton.setEnabled(false);
    }

    protected void setUpAssertionPanel(BasicTreeNode node) {
        this.myAssertionElementComboBox.setModel(this.myElementComboBoxModel);
        this.myAssertionElementComboBox.setSelectedItem(node);
        this.myAssertionElementComboBox.setForeground((Color)JBColor.BLACK);
        this.mySaveAssertionButton.setEnabled(true);
        this.mySaveAssertionAndAddAnotherButton.setEnabled(true);
        CardLayout cardLayout = (CardLayout)this.myTextFieldWrapper.getLayout();
        if (UiAutomatorNodeHelper.isTextView(node)) {
            cardLayout.show(this.myTextFieldWrapper, "myAssertionTextField");
            this.myAssertionTextField.setText(UiAutomatorNodeHelper.getText(node));
            this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITH_TEXT));
        } else {
            cardLayout.show(this.myTextFieldWrapper, "myPlaceHolder");
            this.myAssertionRuleComboBox.setModel(new DefaultComboBoxModel<String>(TestRecorderAssertion.ASSERTION_RULES_WITHOUT_TEXT));
        }
    }

    public boolean isAssertionMode() {
        return this.myAssertionMode;
    }

    @Override
    public void onEvent(final TestRecorderEvent event) {
        if (!TestRecorderEvent.SUPPORTED_EVENTS.contains(event.getEventType())) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (RecordingDialog.this.myActionListModel.isEmpty()) {
                    RecordingDialog.this.myActionListModel.addElement(event);
                } else {
                    ElementAction lastAction = RecordingDialog.this.myActionListModel.lastElement();
                    if (lastAction instanceof TestRecorderEvent && ((TestRecorderEvent)lastAction).canMerge(event)) {
                        ((TestRecorderEvent)lastAction).merge(event);
                        RecordingDialog.this.myActionList.repaint();
                    } else {
                        RecordingDialog.this.myActionListModel.addElement(event);
                    }
                }
                RecordingDialog.this.myActionList.ensureIndexIsVisible(RecordingDialog.this.myActionList.getItemsCount() - 1);
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JPanel jPanel;
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JComboBox jComboBox2;
        JPanel jPanel2;
        JButton jButton4;
        JButton jButton5;
        JPanel jPanel3;
        JPanel jPanel4;
        JButton jButton6;
        JBList jBList;
        JBScrollPane jBScrollPane;
        JPanel jPanel5;
        JPanel jPanel6;
        JPanel jPanel7;
        this.createUIComponents();
        this.myRootPanel = jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myRecordingPanel = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel7.add((Component)jPanel6, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(596, 306), null));
        this.myActionListPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(539, 132), null));
        this.myScrollPane = jBScrollPane = new JBScrollPane();
        jPanel5.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(238, 128), null));
        this.myActionList = jBList = new JBList();
        jBList.setSelectionMode(0);
        jBScrollPane.setViewportView((Component)jBList);
        this.myRecordPauseButton = jButton6 = new JButton();
        jButton6.setHideActionText(false);
        jButton6.setText("Pause");
        jPanel5.add((Component)jButton6, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, new Dimension(-1, 40), null));
        this.myAssertionPanel = jPanel4 = new JPanel();
        jPanel4.setLayout(new CardLayout(0, 0));
        jPanel6.add((Component)jPanel4, new GridConstraints(1, 0, 1, 1, 2, 1, 3, 0, null, new Dimension(539, 150), null));
        this.myButtonsPanel = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel3, "myButtonsPanel");
        ((CardLayout)jPanel4.getLayout()).show(jPanel4, "myButtonsPanel");
        this.myAddAssertionButton = jButton5 = new JButton();
        jButton5.setText("Add Assertion");
        jPanel3.add((Component)jButton5, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myTakeScreenshotButton = jButton4 = new JButton();
        jButton4.setText("Take Screenshot");
        jPanel3.add((Component)jButton4, new GridConstraints(1, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel3.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel8, new GridConstraints(0, 0, 1, 5, 1, 1, 3, 0, new Dimension(-1, 5), new Dimension(-1, 5), new Dimension(-1, 5)));
        this.myEditAssertionPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(4, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel2, "myEditAssertionPanel");
        jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Edit assertion", 0, 0, null, null));
        this.myAssertionRuleComboBox = jComboBox2 = new JComboBox();
        jPanel2.add(jComboBox2, new GridConstraints(1, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(230, 25), null));
        JPanel jPanel9 = new JPanel();
        jPanel9.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel9, new GridConstraints(3, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(230, 35), null));
        this.mySaveAssertionButton = jButton3 = new JButton();
        jButton3.setText("Save Assertion");
        jPanel9.add((Component)jButton3, new GridConstraints(0, 2, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel9.add((Component)spacer2, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 1, null, null, null));
        this.mySaveAssertionAndAddAnotherButton = jButton2 = new JButton();
        jButton2.setText("Save and Add Another");
        jPanel9.add((Component)jButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myCancelButton = jButton = new JButton();
        jButton.setText("Cancel");
        jPanel9.add((Component)jButton, new GridConstraints(0, 3, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myTextFieldWrapper = jPanel = new JPanel();
        jPanel.setLayout(new CardLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, new Dimension(230, 24), null));
        this.myAssertionTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, "myAssertionTextField");
        JPanel jPanel10 = new JPanel();
        jPanel10.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel10, "myPlaceHolder");
        this.myAssertionElementComboBox = jComboBox = new JComboBox();
        jPanel2.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, new Dimension(230, 25), null));
        ScreenshotPanel screenshotPanel = this.myScreenshotPanel;
        jPanel7.add((Component)screenshotPanel, new GridConstraints(0, 1, 1, 1, 4, 2, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRootPanel;
    }

    private static class ElementDescriptorSerializer
    implements JsonSerializer<ElementDescriptor> {
        private final Project myProject;

        public ElementDescriptorSerializer(Project project) {
            this.myProject = project;
        }

        public JsonElement serialize(ElementDescriptor elementDescriptor, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("className", ClassHelper.getInternalName(this.myProject, elementDescriptor.getClassName()));
            jsonObject.addProperty("recyclerViewChildPosition", (Number)elementDescriptor.getRecyclerViewChildPosition());
            jsonObject.addProperty("adapterViewChildPosition", (Number)elementDescriptor.getAdapterViewChildPosition());
            jsonObject.addProperty("groupViewChildPosition", (Number)elementDescriptor.getGroupViewChildPosition());
            jsonObject.addProperty("resourceId", elementDescriptor.getResourceId());
            jsonObject.addProperty("contentDescription", elementDescriptor.getContentDescription());
            jsonObject.addProperty("text", elementDescriptor.getText());
            return jsonObject;
        }
    }
}

