/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.debugger;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.gct.testrecorder.debugger.BreakpointDescriptor;
import com.google.gct.testrecorder.event.ElementDescriptor;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.event.TestRecorderEventListener;
import com.google.gct.testrecorder.settings.TestRecorderSettings;
import com.google.gct.testrecorder.ui.TestRecorderScreenshotTask;
import com.intellij.concurrency.JobScheduler;
import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.LocatableEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreakpointCommand
extends DebuggerCommandImpl {
    private static final Logger LOGGER = Logger.getInstance(BreakpointCommand.class);
    private static final String PARENT_NODE_CALL = ".getParent()";
    private static final List<String> LAZILY_LOADED_CLASSES = ImmutableList.of((Object)"android.support.v4.view.ViewPager", (Object)"android.view.ViewRootImpl$SendWindowContentChangedAccessibilityEvent");
    private static final int MAX_SCHEDULE_ATTEMPTS = 20;
    private static final long INTER_ATTEMPTS_WAIT = 500L;
    private static final int ESPRESSO_IDLE_DELAY = 15;
    private static final int MAX_DELAY_TIME = 7000;
    private final DebugProcessImpl myDebugProcess;
    private final BreakpointDescriptor myBreakpointDescriptor;
    private volatile TestRecorderEventListener myEventListener;
    private volatile BreakpointRequest myRequest;
    private int myCurrentScheduleAttempt = 0;
    private volatile boolean myIsDisabled = false;
    private static TestRecorderEvent preparatoryTextChangeEvent;

    public BreakpointCommand(DebugProcessImpl debugProcess, BreakpointDescriptor breakpointDescriptor) {
        this.myDebugProcess = debugProcess;
        this.myBreakpointDescriptor = breakpointDescriptor;
    }

    public void disable() {
        this.myIsDisabled = true;
        if (this.myRequest != null) {
            this.myRequest.disable();
        }
    }

    protected void action() throws Exception {
        if (this.myIsDisabled) {
            return;
        }
        Location location = this.getBreakpointLocation();
        if (location == null) {
            if (this.myCurrentScheduleAttempt < 20) {
                ++this.myCurrentScheduleAttempt;
                final BreakpointCommand thisCommand = this;
                JobScheduler.getScheduler().schedule(new Runnable(){

                    @Override
                    public void run() {
                        BreakpointCommand.this.myDebugProcess.getManagerThread().schedule((DebuggerCommandImpl)thisCommand);
                    }
                }, 500L, TimeUnit.MILLISECONDS);
            } else {
                LOGGER.warn("Could not set breakpoint " + this.myBreakpointDescriptor);
            }
            return;
        }
        this.myRequest = this.myDebugProcess.getRequestsManager().createBreakpointRequest((FilteredRequestor)new FilteredRequestorAdapter(){

            public boolean processLocatableEvent(SuspendContextCommandImpl action, LocatableEvent event) throws LocatableEventRequestor.EventProcessingException {
                try {
                    SuspendContextImpl suspendContext = action.getSuspendContext();
                    if (suspendContext == null) {
                        return false;
                    }
                    ThreadReferenceProxyImpl activeThread = suspendContext.getThread();
                    if (activeThread == null) {
                        return false;
                    }
                    suspendContext.initExecutionStacks(activeThread);
                    JavaExecutionStack activeExecutionStack = suspendContext.getActiveExecutionStack();
                    if (activeExecutionStack == null) {
                        return false;
                    }
                    JavaStackFrame stackFrame = (JavaStackFrame)activeExecutionStack.getTopFrame();
                    if (stackFrame == null) {
                        return false;
                    }
                    StackFrameProxyImpl frameProxy = stackFrame.getStackFrameProxy();
                    ObjectReference objectReference = frameProxy.thisObject();
                    EvaluationContextImpl evalContext = new EvaluationContextImpl(suspendContext, frameProxy, (Value)objectReference);
                    JavaDebugProcess xdebugProcess = BreakpointCommand.this.myDebugProcess.getXdebugProcess();
                    if (xdebugProcess == null) {
                        return false;
                    }
                    NodeManagerImpl nodeManager = xdebugProcess.getNodeManager();
                    if (BreakpointCommand.this.myBreakpointDescriptor.eventType.equals("LAZY_CLASSES_LOADER")) {
                        for (String className : LAZILY_LOADED_CLASSES) {
                            try {
                                BreakpointCommand.this.myDebugProcess.loadClass(evalContext, className, null);
                            }
                            catch (Exception exception) {}
                        }
                        BreakpointCommand.this.disable();
                    } else if (BreakpointCommand.this.myBreakpointDescriptor.eventType.equals("WINDOW_CONTENT_CHANGED") && TestRecorderScreenshotTask.IS_UI_HIERARCHY_DUMPING) {
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else if (BreakpointCommand.this.myBreakpointDescriptor.eventType.equals("VIEW_TEXT_CHANGED")) {
                        if (!BreakpointCommand.isUserInputTextChange(activeThread)) {
                            return false;
                        }
                        if (BreakpointCommand.this.myBreakpointDescriptor.isPreparatory) {
                            preparatoryTextChangeEvent = BreakpointCommand.this.prepareEvent(evalContext, nodeManager);
                        } else {
                            if (preparatoryTextChangeEvent == null) {
                                throw new RuntimeException("Mandatory preparatory text change event is missing!");
                            }
                            String receiverReference = BreakpointCommand.this.getReceiverReference(evalContext, nodeManager);
                            Value text = BreakpointCommand.this.evaluateExpression(receiverReference + ".getText().toString()", evalContext, nodeManager);
                            preparatoryTextChangeEvent.setReplacementText(text == null ? "" : BreakpointCommand.this.getStringValue(text));
                            BreakpointCommand.this.notifyEventListener(preparatoryTextChangeEvent);
                            preparatoryTextChangeEvent = null;
                        }
                    } else {
                        BreakpointCommand.this.notifyEventListener(BreakpointCommand.this.prepareEvent(evalContext, nodeManager));
                    }
                }
                catch (Exception e) {
                    LOGGER.warn("Failed to process breakpoint event", (Throwable)e);
                }
                return false;
            }
        }, location);
        this.myDebugProcess.getRequestsManager().enableRequest((EventRequest)this.myRequest);
    }

    private static boolean isUserInputTextChange(ThreadReferenceProxyImpl activeThread) throws EvaluateException {
        for (StackFrameProxyImpl frame : activeThread.frames()) {
            Location location = frame.location();
            String callerClassName = location.declaringType().name();
            String callerMethodName = location.method().name();
            if (!"android.view.inputmethod.BaseInputConnection".equals(callerClassName) && !"android.view.KeyEvent".equals(callerClassName) && (!"android.widget.TextView".equals(callerClassName) || !"paste".equals(callerMethodName))) continue;
            return true;
        }
        return false;
    }

    private void notifyEventListener(TestRecorderEvent event) {
        if (this.myEventListener != null && event != null) {
            this.myEventListener.onEvent(event);
        }
    }

    public PrioritizedTask.Priority getPriority() {
        return PrioritizedTask.Priority.HIGH;
    }

    public void setEventListener(TestRecorderEventListener listener) {
        this.myEventListener = listener;
    }

    @Nullable
    private Location getBreakpointLocation() {
        List referenceTypes = this.myDebugProcess.getVirtualMachineProxy().classesByName(this.myBreakpointDescriptor.className);
        if (referenceTypes.isEmpty()) {
            return null;
        }
        if (referenceTypes.size() > 1) {
            throw new RuntimeException("Found more than one copy of class " + this.myBreakpointDescriptor.className);
        }
        List<Method> methods = ((ReferenceType)referenceTypes.get(0)).methodsByName(this.myBreakpointDescriptor.methodName, this.myBreakpointDescriptor.methodSignature);
        if (methods.isEmpty()) {
            throw new RuntimeException("Could not find method " + this.myBreakpointDescriptor.methodName + this.myBreakpointDescriptor.methodSignature + " in class " + this.myBreakpointDescriptor.className);
        }
        if (methods.size() > 1) {
            throw new RuntimeException("Found more than one copy of method " + this.myBreakpointDescriptor.methodName + this.myBreakpointDescriptor.methodSignature + " in class " + this.myBreakpointDescriptor.className);
        }
        return methods.get(0).location();
    }

    @Nullable
    private TestRecorderEvent prepareEvent(EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        TestRecorderEvent event = new TestRecorderEvent(this.myBreakpointDescriptor.eventType, System.currentTimeMillis());
        if (event.isPermissionsRequest()) {
            return this.preparePermissionsRequestEvent(event, evalContext, nodeManager);
        }
        if (event.isDelayedMessagePost()) {
            return this.prepareDelayedMessagePostEvent(event, evalContext, nodeManager);
        }
        if (event.isPressEvent()) {
            if (event.isPressBack()) {
                if (event.isPressBackEmulator28()) {
                    return event;
                }
                Value isKeyCodeBackActionUp = this.evaluateExpression("p.mEvent.mKeyCode == android.view.KeyEvent.KEYCODE_BACK && p.mEvent.mAction == android.view.KeyEvent.ACTION_UP", evalContext, nodeManager);
                if (isKeyCodeBackActionUp != null && Boolean.parseBoolean(this.getStringValue(isKeyCodeBackActionUp))) {
                    return event;
                }
                return null;
            }
            Value actionCode = this.evaluateExpression("actionCode", evalContext, nodeManager);
            if (actionCode != null) {
                event.setActionCode(Integer.parseInt(this.getStringValue(actionCode)));
            }
        }
        String receiverReference = this.getReceiverReference(evalContext, nodeManager);
        this.populateElementDescriptors(event, evalContext, nodeManager, receiverReference, 1);
        if (event.isSwipe()) {
            return this.completeSwipeEvent(event, evalContext, nodeManager);
        }
        if (event.getElementDescriptorsCount() > 0) {
            event.setReplacementText(event.getElementDescriptor(0).getText());
        }
        this.setScrollableState(event, evalContext, nodeManager, receiverReference + PARENT_NODE_CALL, 2);
        return event;
    }

    private TestRecorderEvent preparePermissionsRequestEvent(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        Value permissionsValue = this.evaluateExpression("permissions", evalContext, nodeManager);
        if (permissionsValue instanceof ArrayReference) {
            ArrayList permissions = Lists.newArrayList();
            for (Value permission : ((ArrayReference)permissionsValue).getValues()) {
                permissions.add(this.getStringValue(permission));
            }
            event.setRequestedPermissions(permissions);
            return event;
        }
        return null;
    }

    @Nullable
    private TestRecorderEvent prepareDelayedMessagePostEvent(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        Value runnableClassNameValue;
        int delayMillis;
        Value delayMillisValue = this.evaluateExpression("delayMillis", evalContext, nodeManager);
        if (delayMillisValue != null && (delayMillis = Integer.parseInt(this.getStringValue(delayMillisValue))) > 15 && (runnableClassNameValue = this.evaluateExpression("r.getClass().getName()", evalContext, nodeManager)) != null && !this.isFrameworkClass(this.getStringValue(runnableClassNameValue))) {
            event.setDelayTime(delayMillis > 7000 ? 7000L : (long)delayMillis);
            return event;
        }
        return null;
    }

    private boolean isFrameworkClass(String className) {
        if (Strings.isNullOrEmpty((String)className)) {
            return false;
        }
        return className.startsWith("android.support.") || className.startsWith("android.widget.") || className.startsWith("android.view.") || className.startsWith("android.os.");
    }

    @Nullable
    private TestRecorderEvent completeSwipeEvent(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        int dy;
        Value dxValue = this.evaluateExpression("x - getScrollX()", evalContext, nodeManager);
        Value dyValue = this.evaluateExpression("y - getScrollY()", evalContext, nodeManager);
        int dx = dxValue == null ? 0 : Integer.parseInt(this.getStringValue(dxValue));
        int n = dy = dyValue == null ? 0 : Integer.parseInt(this.getStringValue(dyValue));
        if (dx == 0 && dy == 0) {
            return null;
        }
        if (Math.abs(dx) >= Math.abs(dy)) {
            event.setSwipeDirection(dx < 0 ? TestRecorderEvent.SwipeDirection.Right : TestRecorderEvent.SwipeDirection.Left);
        } else {
            event.setSwipeDirection(dy < 0 ? TestRecorderEvent.SwipeDirection.Down : TestRecorderEvent.SwipeDirection.Up);
        }
        return event;
    }

    @NotNull
    private String getReceiverReference(EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        if (this.myBreakpointDescriptor.eventType.equals("VIEW_CLICKED") || this.myBreakpointDescriptor.eventType.equals("VIEW_TEXT_CHANGED")) {
            return "this.this$0";
        }
        if (this.myBreakpointDescriptor.eventType.equals("LIST_ITEM_CLICKED")) {
            String titleViewReference = "view.mTitleView";
            Value titleView = this.evaluateExpression(titleViewReference, evalContext, nodeManager);
            if (titleView != null) {
                return titleViewReference;
            }
            return "view";
        }
        return "this";
    }

    private void setScrollableState(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager, String objectReference, int level) {
        String parentElementType;
        if (level > TestRecorderSettings.getInstance().SCROLL_DEPTH) {
            return;
        }
        Value parentElementTypeValue = this.evaluateExpression(objectReference + ".getClass().getCanonicalName()", evalContext, nodeManager);
        if (parentElementTypeValue != null && ("android.widget.ScrollView".equals(parentElementType = this.getStringValue(parentElementTypeValue)) || "android.widget.HorizontalScrollView".equals(parentElementType))) {
            event.setCanScrollTo(true);
            return;
        }
        this.setScrollableState(event, evalContext, nodeManager, objectReference + PARENT_NODE_CALL, level + 1);
    }

    private void populateElementDescriptors(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager, String objectReference, int level) {
        Value positionIndex;
        String parentReference;
        Value parentElementType;
        if (level > TestRecorderSettings.getInstance().EVALUATION_DEPTH) {
            return;
        }
        int recyclerViewChildPosition = -1;
        if (level == 1 && (parentElementType = this.evaluateExpression((parentReference = objectReference + PARENT_NODE_CALL) + ".getClass().getCanonicalName()", evalContext, nodeManager)) != null && ("android.support.v7.widget.RecyclerView".equals(this.getStringValue(parentElementType)) || "androidx.recyclerview.widget.RecyclerView".equals(this.getStringValue(parentElementType))) && (positionIndex = this.evaluateExpression(objectReference + ".getLayoutParams().mViewHolder.getAdapterPosition()", evalContext, nodeManager)) != null) {
            recyclerViewChildPosition = Integer.parseInt(this.getStringValue(positionIndex));
        }
        if (this.evaluateAndAddElementDescriptor(event, evalContext, nodeManager, objectReference, false, recyclerViewChildPosition)) {
            this.populateElementDescriptors(event, evalContext, nodeManager, objectReference + PARENT_NODE_CALL, level + 1);
        } else if (level == 1) {
            Value className;
            Value childrenCount = this.evaluateExpression(objectReference + ".mChildrenCount", evalContext, nodeManager);
            if (childrenCount != null) {
                for (int i = 0; i < Integer.parseInt(this.getStringValue(childrenCount)); ++i) {
                    String childReference = objectReference + ".mChildren[" + i + "]";
                    if (!this.evaluateAndAddElementDescriptor(event, evalContext, nodeManager, childReference, true, -1)) continue;
                    return;
                }
            }
            event.addElementDescriptor(new ElementDescriptor((className = this.evaluateExpression(objectReference + ".getClass().getCanonicalName()", evalContext, nodeManager)) == null ? "" : this.getStringValue(className), -1, -1, -1, "", "", ""));
            this.populateElementDescriptors(event, evalContext, nodeManager, objectReference + PARENT_NODE_CALL, level + 1);
        }
    }

    private boolean evaluateAndAddElementDescriptor(TestRecorderEvent event, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager, String objectReference, boolean isTextMandatory, int recyclerViewChildPosition) {
        Value resourceNumberIdValue;
        Value text = this.evaluateExpression(objectReference + ".getText().toString()", evalContext, nodeManager);
        if (isTextMandatory && text == null) {
            return false;
        }
        int adapterViewChildPosition = -1;
        int groupViewChildPosition = -1;
        if (recyclerViewChildPosition == -1) {
            Value adapterViewChildPositionValue = this.evaluateExpression(objectReference + ".getParent().getPositionForView(" + objectReference + ")", evalContext, nodeManager);
            int n = adapterViewChildPosition = adapterViewChildPositionValue == null ? -1 : Integer.parseInt(this.getStringValue(adapterViewChildPositionValue));
            if (adapterViewChildPosition == -1) {
                Value groupViewChildPositionValue = this.evaluateExpression(objectReference + ".getParent().indexOfChild(" + objectReference + ")", evalContext, nodeManager);
                groupViewChildPosition = groupViewChildPositionValue == null ? -1 : Integer.parseInt(this.getStringValue(groupViewChildPositionValue));
            }
        }
        int resourceNumberId = (resourceNumberIdValue = this.evaluateExpression(objectReference + ".getId()", evalContext, nodeManager)) == null ? -1 : Integer.parseInt(this.getStringValue(resourceNumberIdValue));
        Value resourceId = resourceNumberId == -1 ? null : this.evaluateExpression(objectReference + ".getResources().getResourceName(" + resourceNumberId + ")", evalContext, nodeManager);
        Value contentDescription = this.evaluateExpression(objectReference + ".getContentDescription()", evalContext, nodeManager);
        if (!TestRecorderSettings.getInstance().CAP_AT_NON_IDENTIFIABLE_ELEMENTS || recyclerViewChildPosition != -1 || adapterViewChildPosition != -1 || groupViewChildPosition != -1 || resourceId != null || contentDescription != null || text != null) {
            Value className = this.evaluateExpression(objectReference + ".getClass().getCanonicalName()", evalContext, nodeManager);
            event.addElementDescriptor(new ElementDescriptor(className == null ? "" : this.getStringValue(className), recyclerViewChildPosition, adapterViewChildPosition, groupViewChildPosition, resourceId == null ? "" : this.getStringValue(resourceId), contentDescription == null ? "" : this.getStringValue(contentDescription), text == null ? "" : this.getStringValue(text)));
            return true;
        }
        return false;
    }

    private String getStringValue(@NotNull Value value) {
        if (value instanceof StringReference) {
            return ((StringReference)value).value();
        }
        return value.toString();
    }

    private Value evaluateExpression(String expression, EvaluationContextImpl evalContext, NodeManagerImpl nodeManager) {
        TextWithImports text = TextWithImportsImpl.fromXExpression((XExpression)XExpressionImpl.fromText((String)expression));
        WatchItemDescriptor descriptor = nodeManager.getWatchItemDescriptor(null, text, null);
        descriptor.setContext(evalContext);
        return descriptor.getEvaluateException() != null ? null : descriptor.getValue();
    }

    private abstract class FilteredRequestorAdapter
    implements FilteredRequestor {
        private FilteredRequestorAdapter() {
        }

        public String getSuspendPolicy() {
            return "SuspendAll";
        }

        public boolean isInstanceFiltersEnabled() {
            return false;
        }

        public InstanceFilter[] getInstanceFilters() {
            return new InstanceFilter[0];
        }

        public boolean isCountFilterEnabled() {
            return false;
        }

        public int getCountFilter() {
            return 0;
        }

        public boolean isClassFiltersEnabled() {
            return false;
        }

        public ClassFilter[] getClassFilters() {
            return new ClassFilter[0];
        }

        public ClassFilter[] getClassExclusionFilters() {
            return new ClassFilter[0];
        }
    }
}

