/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.codegen;

import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.projectsystem.AndroidProjectSystem;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.collect.Collections2;
import com.google.gct.testrecorder.codegen.TestCodeMapper;
import com.google.gct.testrecorder.event.ElementAction;
import com.google.gct.testrecorder.event.TestRecorderAssertion;
import com.google.gct.testrecorder.event.TestRecorderEvent;
import com.google.gct.testrecorder.ui.RecordingDialog;
import com.google.gct.testrecorder.util.ResourceHelper;
import com.google.gct.testrecorder.util.StringHelper;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.google.wireless.android.sdk.stats.TestRecorderDetails;
import com.intellij.codeInsight.actions.OptimizeImportsProcessor;
import com.intellij.codeInsight.actions.ReformatCodeProcessor;
import com.intellij.concurrency.JobScheduler;
import com.intellij.ide.SelectInContext;
import com.intellij.ide.SelectInTarget;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.actions.SelectInContextImpl;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.impl.CoreProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiManager;
import com.intellij.util.containers.ConcurrentLongObjectMap;
import java.io.File;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestCodeGenerator {
    private static final String JAVA_TEST_CODE_TEMPLATE_FILE_NAME = "JavaTestCodeTemplate.vm";
    private static final String KOTLIN_TEST_CODE_TEMPLATE_FILE_NAME = "KotlinTestCodeTemplate.vm";
    private static final int BACKGROUND_TASKS_WAIT_LIMIT = 60;
    private final String myResourcePackageName;
    private final String myApplicationId;
    private final PsiClass myTestClass;
    private final Module myTestClassModule;
    private final List<ElementAction> myActions;
    private final Project myProject;
    private final String myLaunchedActivityName;
    private final boolean myWasEverPaused;
    private final boolean myIsKotlinTestClass;
    private final boolean myUsesAndroidxDependency;

    public TestCodeGenerator(String resourcePackageName, String applicationId, Module testClassModule, PsiClass testClass, List<ElementAction> actions, String launchedActivityName, boolean wasEverPaused, boolean isKotlinTestClass, boolean usesAndroidxDependency) {
        this.myResourcePackageName = resourcePackageName;
        this.myApplicationId = applicationId;
        this.myTestClass = testClass;
        this.myTestClassModule = testClassModule;
        this.myActions = actions;
        this.myProject = this.myTestClassModule.getProject();
        this.myLaunchedActivityName = launchedActivityName;
        this.myWasEverPaused = wasEverPaused;
        this.myIsKotlinTestClass = isKotlinTestClass;
        this.myUsesAndroidxDependency = usesAndroidxDependency;
    }

    public void generate() {
        String testFilePath = this.myTestClass.getContainingFile().getVirtualFile().getPath();
        final VirtualFile testVirtualFile = LocalFileSystem.getInstance().findFileByPath(testFilePath);
        if (testVirtualFile == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> this.writeCode(testVirtualFile));
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.myProject);
        Document document = FileDocumentManager.getInstance().getDocument(testVirtualFile);
        if (document != null) {
            psiDocumentManager.commitDocument(document);
        } else {
            psiDocumentManager.commitAllDocuments();
        }
        testVirtualFile.refresh(false, true);
        OpenFileAction.openFile((String)testFilePath, (Project)this.myProject);
        testVirtualFile.refresh(false, true, new Runnable(){

            @Override
            public void run() {
                ProjectView projectView = ProjectView.getInstance((Project)TestCodeGenerator.this.myProject);
                String currentViewId = projectView.getCurrentViewId() == null ? "ProjectPane" : projectView.getCurrentViewId();
                for (SelectInTarget target : projectView.getSelectInTargets()) {
                    if (!currentViewId.equals(target.getMinorViewId())) continue;
                    AnActionEvent event = AnActionEvent.createFromDataContext((String)"unknown", null, (DataContext)new DataContext(){

                        @Nullable
                        public Object getData(String dataId) {
                            if (CommonDataKeys.PROJECT.getName().equals(dataId)) {
                                return TestCodeGenerator.this.myProject;
                            }
                            if (PlatformDataKeys.FILE_EDITOR.getName().equals(dataId)) {
                                return FileEditorManagerEx.getInstanceEx((Project)TestCodeGenerator.this.myProject).getSelectedEditor(testVirtualFile);
                            }
                            if (CommonDataKeys.VIRTUAL_FILE.getName().equals(dataId)) {
                                return testVirtualFile;
                            }
                            return null;
                        }
                    });
                    SelectInContext context = SelectInContextImpl.createContext((AnActionEvent)event);
                    target.selectIn(context, false);
                    break;
                }
                JobScheduler.getScheduler().schedule(() -> {
                    TestCodeGenerator.this.waitForBackgroundTasksToFinish();
                    ApplicationManager.getApplication().invokeAndWait(() -> new OptimizeImportsProcessor(TestCodeGenerator.this.myProject, PsiManager.getInstance((Project)TestCodeGenerator.this.myProject).findFile(testVirtualFile)).run());
                    TestCodeGenerator.this.waitForBackgroundTasksToFinish();
                    ApplicationManager.getApplication().invokeLater(() -> new ReformatCodeProcessor(TestCodeGenerator.this.myProject, PsiManager.getInstance((Project)TestCodeGenerator.this.myProject).findFile(testVirtualFile), null, false).run());
                }, 10L, TimeUnit.MILLISECONDS);
            }
        });
    }

    private void waitForBackgroundTasksToFinish() {
        ProjectSystemSyncManager syncManager;
        int secondsWaited = 0;
        AndroidProjectSystem projectSystem = ProjectSystemUtil.getProjectSystem((Project)this.myProject);
        while (secondsWaited < 60 && ((syncManager = projectSystem.getSyncManager()).isSyncInProgress() || syncManager.isSyncNeeded() || CompilerManager.getInstance((Project)this.myProject).isCompilationActive())) {
            try {
                Thread.sleep(1000L);
                ++secondsWaited;
            }
            catch (InterruptedException interruptedException) {}
        }
        try {
            Field field = CoreProgressManager.class.getDeclaredField("currentIndicators");
            field.setAccessible(true);
            while (secondsWaited < 60 && !((ConcurrentLongObjectMap)field.get(null)).isEmpty()) {
                try {
                    Thread.sleep(1000L);
                    ++secondsWaited;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    protected void writeCode(VirtualFile testVirtualFile) {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(testVirtualFile.getOutputStream((Object)this));
            VelocityEngine velocityEngine = new VelocityEngine();
            velocityEngine.setProperty("runtime.log.logsystem.class", (Object)"org.apache.velocity.runtime.log.NullLogChute");
            velocityEngine.init();
            velocityEngine.evaluate((Context)this.createVelocityContext(testVirtualFile), (Writer)writer, RecordingDialog.class.getName(), this.readTemplateFileContent());
            ((Writer)writer).flush();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to generate test class file: ", e);
        }
        finally {
            if (writer != null) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private String readTemplateFileContent() {
        File testTemplateFile = ResourceHelper.getFileForResource(this, this.myIsKotlinTestClass ? KOTLIN_TEST_CODE_TEMPLATE_FILE_NAME : JAVA_TEST_CODE_TEMPLATE_FILE_NAME, "test_code_template_", "vm");
        try {
            return FileUtils.readFileToString((File)testTemplateFile);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read the test template file " + testTemplateFile.getAbsolutePath(), e);
        }
    }

    @NotNull
    private VelocityContext createVelocityContext(VirtualFile testCodeVirtualFile) {
        Set<String> requestedPermissions;
        Object lastAction;
        VelocityContext velocityContext = new VelocityContext();
        velocityContext.put("TestActivityName", (Object)StringHelper.getClassName(this.myLaunchedActivityName));
        velocityContext.put("ClassName", (Object)this.myTestClass.getName());
        velocityContext.put("TestMethodName", (Object)StringHelper.lowerCaseFirstCharacter(this.myTestClass.getName()));
        velocityContext.put("PackageName", (Object)StringHelper.getPackageName(this.myTestClass.getQualifiedName()));
        velocityContext.put("WasEverPaused", (Object)this.myWasEverPaused);
        velocityContext.put("ResourcePackageName", (Object)this.myResourcePackageName);
        velocityContext.put("UsesAndroidxDependency", (Object)this.myUsesAndroidxDependency);
        velocityContext.put("EspressoPackageNamePrefix", (Object)(this.myUsesAndroidxDependency ? "androidx" : "android.support"));
        velocityContext.put("RecyclerViewPackageNamePrefix", (Object)(this.myUsesAndroidxDependency ? "androidx.recyclerview.widget" : "android.support.v7.widget"));
        TestCodeMapper codeMapper = new TestCodeMapper(this.myApplicationId, this.myTestClassModule, this.getAndroidTargetData(), this.myIsKotlinTestClass);
        ArrayList<String> testCodeLines = new ArrayList<String>();
        int eventCount = 0;
        int assertionCount = 0;
        if (!this.myActions.isEmpty() && (lastAction = this.myActions.get(this.myActions.size() - 1)) instanceof TestRecorderEvent && ((TestRecorderEvent)lastAction).isDelayedMessagePost()) {
            this.myActions.remove(this.myActions.size() - 1);
        }
        for (ElementAction action : this.myActions) {
            List<String> actionCodeLines;
            if (action instanceof TestRecorderEvent) {
                actionCodeLines = codeMapper.getTestCodeLinesForEvent((TestRecorderEvent)action);
                ++eventCount;
            } else {
                actionCodeLines = codeMapper.getTestCodeLinesForAssertion((TestRecorderAssertion)action);
                ++assertionCount;
            }
            if (actionCodeLines.isEmpty()) continue;
            testCodeLines.addAll(actionCodeLines);
            testCodeLines.add("");
        }
        if (!testCodeLines.isEmpty()) {
            testCodeLines.remove(testCodeLines.size() - 1);
        }
        if (!(requestedPermissions = codeMapper.getRequestedPermissions()).isEmpty()) {
            velocityContext.put("HasRequestedPermissions", (Object)true);
            velocityContext.put("RequestedPermissions", (Object)StringUtils.join((Collection)Collections2.transform(requestedPermissions, permission -> StringHelper.boxString(permission)), (String)",\n"));
        }
        velocityContext.put("AddContribImport", (Object)codeMapper.isRecyclerViewActionAdded());
        velocityContext.put("AddChildAtPositionMethod", (Object)codeMapper.isChildAtPositionAdded());
        velocityContext.put("TestCode", testCodeLines);
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_GENERATE_TEST_CLASS).setTestRecorderDetails(TestRecorderDetails.newBuilder().setAssertionCount((long)assertionCount).setEventCount((long)eventCount)), (Project)this.myProject));
        return velocityContext;
    }

    @Nullable
    private AndroidTargetData getAndroidTargetData() {
        AndroidPlatform androidPlatform = AndroidPlatform.getInstance((Module)this.myTestClassModule);
        if (androidPlatform == null) {
            return null;
        }
        return androidPlatform.getSdkData().getTargetData(androidPlatform.getTarget());
    }
}

