/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.zipcache;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.zipcache.CidrWritableZipBackedCache;
import com.jetbrains.cidr.zipcache.CidrZipBackedCache;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.coroutines.CoroutineContext;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.SupervisorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u0000*\u0006\b\u0001\u0010\u0002 \u0001*\u0006\b\u0002\u0010\u0003 \u00002\u0014\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u0002\u0012\u0004\u0012\u0002H\u00030\u00042\u00020\u0005B\u001f\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u001b\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002\u00a2\u0006\u0002\u0010\u001eJ\u0012\u0010\u001f\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0017\u0010!\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\"J\u0017\u0010#\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u001c\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J\u0017\u0010%\u001a\u0004\u0018\u00018\u00012\u0006\u0010\u001c\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010&J\u0010\u0010'\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\u0011H\u0002J\u0012\u0010(\u001a\u0004\u0018\u00010\r2\u0006\u0010 \u001a\u00020\u0007H\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010\r2\u0006\u0010*\u001a\u00020\u0007H\u0002J\u0010\u0010+\u001a\u00020\u001b2\u0006\u0010,\u001a\u00020-H\u0007J\u001d\u0010.\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002H\u0002\u00a2\u0006\u0002\u0010\u001eJ%\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00028\u00002\u0006\u0010\u001d\u001a\u00028\u0002H$\u00a2\u0006\u0002\u00100R\u0013\u0010\f\u001a\u0004\u0018\u00010\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lcom/jetbrains/cidr/zipcache/CidrWritableZipBackedCache;", "Key", "Value", "CachingValue", "Lcom/jetbrains/cidr/zipcache/CidrZipBackedCache;", "Lkotlinx/coroutines/CoroutineScope;", "relativeCachePath", "", "zipFileName", "zipCacheVersion", "", "(Ljava/lang/String;Ljava/lang/String;I)V", "cacheRoot", "Lcom/intellij/openapi/vfs/VirtualFile;", "getCacheRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "cacheRootPath", "Ljava/nio/file/Path;", "getCacheRootPath", "()Ljava/nio/file/Path;", "coroutineContext", "Lkotlin/coroutines/CoroutineContext;", "getCoroutineContext", "()Lkotlin/coroutines/CoroutineContext;", "myCacheRoot", "myCacheRootInTests", "cacheValue", "", "key", "value", "(Ljava/lang/Object;Ljava/lang/Object;)V", "findExistingVirtualFileParent", "path", "getCacheDir", "(Ljava/lang/Object;)Lcom/intellij/openapi/vfs/VirtualFile;", "getPathForCaching", "(Ljava/lang/Object;)Ljava/nio/file/Path;", "getValue", "(Ljava/lang/Object;)Ljava/lang/Object;", "markDirectoryDirty", "prepareRoot", "registerRootOnEDT", "relativeOrAbsoluteCachePath", "setCacheRootToTempDirInTests", "testRootDisposable", "Lcom/intellij/openapi/Disposable;", "writeValue", "dir", "(Ljava/nio/file/Path;Ljava/lang/Object;Ljava/lang/Object;)V", "intellij.cidr.util"})
public abstract class CidrWritableZipBackedCache<Key, Value, CachingValue>
extends CidrZipBackedCache<Key, Value, CachingValue>
implements CoroutineScope {
    @NotNull
    private final CoroutineContext coroutineContext = (CoroutineContext)SupervisorKt.SupervisorJob$default(null, (int)1, null);
    private final VirtualFile myCacheRoot;
    private VirtualFile myCacheRootInTests;

    @NotNull
    public final CoroutineContext getCoroutineContext() {
        return this.coroutineContext;
    }

    @Nullable
    public final VirtualFile getCacheRoot() {
        return ApplicationManager.getApplication().isUnitTestMode() ? this.myCacheRootInTests : this.myCacheRoot;
    }

    @Nullable
    public final Path getCacheRootPath() {
        VirtualFile virtualFile = this.getCacheRoot();
        return virtualFile != null ? virtualFile.toNioPath() : null;
    }

    @Override
    @Nullable
    public Value getValue(Key key) {
        Object Value = super.getValue(key);
        if (Value != null) {
            Object Value2;
            Object it = Value2 = Value;
            boolean bl = false;
            return it;
        }
        VirtualFile virtualFile = this.getCacheDir(key);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile cacheDir = virtualFile;
        return this.readValue(cacheDir, key);
    }

    private final VirtualFile registerRootOnEDT(String relativeOrAbsoluteCachePath) {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            ApplicationManager.getApplication().assertIsDispatchThread();
        }
        String path = FileUtil.isAbsolute((String)relativeOrAbsoluteCachePath) ? relativeOrAbsoluteCachePath : FileUtil.join((String[])new String[]{PathManager.getSystemPath(), relativeOrAbsoluteCachePath});
        new File(path).mkdirs();
        return (VirtualFile)WriteAction.computeAndWait((ThrowableComputable)new ThrowableComputable(this, path){
            final /* synthetic */ CidrWritableZipBackedCache this$0;
            final /* synthetic */ String $path;

            public final VirtualFile compute() {
                return CidrWritableZipBackedCache.access$prepareRoot(this.this$0, this.$path);
            }
            {
                this.this$0 = cidrWritableZipBackedCache;
                this.$path = string;
            }
        });
    }

    private final VirtualFile prepareRoot(String path) {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        try {
            VirtualFile dir = LocalFileSystem.getInstance().refreshAndFindFileByPath(path);
            if (dir != null) {
                return dir;
            }
        }
        catch (IOException error) {
            CidrZipBackedCache.Companion.getLOG().error((Throwable)error);
        }
        return null;
    }

    @TestOnly
    public final void setCacheRootToTempDirInTests(@NotNull Disposable testRootDisposable) {
        ApplicationManager.getApplication().invokeAndWait(new Runnable(this){
            final /* synthetic */ CidrWritableZipBackedCache this$0;

            public final void run() {
                String path = FileUtil.createTempDirectory((String)"cidr_test_", null, (boolean)false).getCanonicalPath();
                CidrWritableZipBackedCache.access$setMyCacheRootInTests$p(this.this$0, CidrWritableZipBackedCache.access$registerRootOnEDT(this.this$0, path));
            }
            {
                this.this$0 = cidrWritableZipBackedCache;
            }
        });
        Disposer.register((Disposable)testRootDisposable, (Disposable)new Disposable(this){
            final /* synthetic */ CidrWritableZipBackedCache this$0;

            public final void dispose() {
                ApplicationManager.getApplication().invokeAndWait(new Runnable(this){
                    final /* synthetic */ setCacheRootToTempDirInTests.2 this$0;

                    public final void run() {
                        Object object = CidrWritableZipBackedCache.access$getMyCacheRootInTests$p(this.this$0.this$0);
                        if (object != null && (object = object.getCanonicalPath()) != null) {
                            Object object2;
                            Object path = object2 = object;
                            boolean bl = false;
                            FileUtil.delete((File)new File((String)path));
                        }
                        CidrWritableZipBackedCache.access$setMyCacheRootInTests$p(this.this$0.this$0, CidrWritableZipBackedCache.access$getMyCacheRoot$p(this.this$0.this$0));
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = cidrWritableZipBackedCache;
            }
        });
    }

    public final void cacheValue(Key key, CachingValue value) {
        this.writeValue(key, value);
    }

    protected abstract void writeValue(@NotNull Path var1, Key var2, CachingValue var3);

    private final void writeValue(Key key, CachingValue value) {
        Path path = this.getPathForCaching(key);
        if (path == null) {
            return;
        }
        Path dir = path;
        this.writeValue(dir, key, value);
        this.markDirectoryDirty(dir);
    }

    private final void markDirectoryDirty(Path path) {
        VirtualFile virtualFile = this.findExistingVirtualFileParent(path);
        if (virtualFile == null) {
            return;
        }
        VirtualFile parent = virtualFile;
        VfsUtil.markDirty((boolean)true, (boolean)true, (VirtualFile[])new VirtualFile[]{parent});
    }

    private final VirtualFile findExistingVirtualFileParent(Path path) {
        VirtualFile virtualFile = this.getCacheRoot();
        if (virtualFile == null) {
            return null;
        }
        VirtualFile parent = virtualFile;
        for (Path part : path) {
            VirtualFile child;
            if (parent.findChild(((Object)part).toString()) == null) {
                return parent;
            }
            parent = child;
        }
        return parent;
    }

    private final VirtualFile getCacheDir(Key key) {
        Path path = this.getPathForCaching(key);
        if (path == null) {
            return null;
        }
        Path pathForCaching = path;
        return VfsUtil.findFile((Path)pathForCaching, (boolean)false);
    }

    private final Path getPathForCaching(Key key) {
        Path path = this.getCacheRootPath();
        if (path == null) {
            return null;
        }
        Path basePath = path;
        Path path2 = this.getRelativePath(key);
        if (path2 == null) {
            return null;
        }
        Path relativePath = path2;
        return basePath.resolve(relativePath);
    }

    public CidrWritableZipBackedCache(@NotNull String relativeCachePath, @Nullable String zipFileName, int zipCacheVersion) {
        super(zipFileName, zipCacheVersion);
        String path = this.withVersion(relativeCachePath);
        this.myCacheRootInTests = this.myCacheRoot = this.registerRootOnEDT(path);
    }

    public static final /* synthetic */ VirtualFile access$prepareRoot(CidrWritableZipBackedCache $this, String path) {
        return $this.prepareRoot(path);
    }

    public static final /* synthetic */ VirtualFile access$getMyCacheRootInTests$p(CidrWritableZipBackedCache $this) {
        return $this.myCacheRootInTests;
    }

    public static final /* synthetic */ void access$setMyCacheRootInTests$p(CidrWritableZipBackedCache $this, VirtualFile virtualFile) {
        $this.myCacheRootInTests = virtualFile;
    }

    public static final /* synthetic */ VirtualFile access$registerRootOnEDT(CidrWritableZipBackedCache $this, String relativeOrAbsoluteCachePath) {
        return $this.registerRootOnEDT(relativeOrAbsoluteCachePath);
    }

    public static final /* synthetic */ VirtualFile access$getMyCacheRoot$p(CidrWritableZipBackedCache $this) {
        return $this.myCacheRoot;
    }
}

