/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.ui;

import com.intellij.ide.NativeIconProvider;
import com.jetbrains.cidr.ui.BaseItemPrinter;
import com.jetbrains.cidr.ui.ComponentRenderer;
import com.jetbrains.cidr.ui.ItemPrinterKt;
import com.jetbrains.cidr.ui.ItemState;
import com.jetbrains.cidr.ui.PrintersKt;
import java.io.File;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B%\b\u0007\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/ui/FileItemPrinter;", "Lcom/jetbrains/cidr/ui/BaseItemPrinter;", "Ljava/io/File;", "printFullPath", "", "showIcon", "checkExists", "(ZZZ)V", "getCheckExists", "()Z", "getPrintFullPath", "getShowIcon", "renderValue", "", "Lcom/jetbrains/cidr/ui/ComponentRenderer;", "value", "state", "Lcom/jetbrains/cidr/ui/ItemState;", "intellij.cidr.util.ui"})
public final class FileItemPrinter
extends BaseItemPrinter<File> {
    private final boolean printFullPath;
    private final boolean showIcon;
    private final boolean checkExists;

    @Override
    public void renderValue(@NotNull ComponentRenderer $this$renderValue, @NotNull File value, @NotNull ItemState state) {
        if (this.checkExists && !value.exists()) {
            $this$renderValue.appendError(value.getName(), state);
        } else {
            $this$renderValue.append(value.getName());
        }
        if (this.printFullPath && Intrinsics.areEqual((Object)value.getName(), (Object)value.getPath()) ^ true) {
            $this$renderValue.appendGrayed(" (" + PrintersKt.getPresentablePath(value) + ")", state);
        }
        if (this.showIcon) {
            $this$renderValue.setIcon(NativeIconProvider.getNativeIcon((Path)value.toPath()));
        }
    }

    public final boolean getPrintFullPath() {
        return this.printFullPath;
    }

    public final boolean getShowIcon() {
        return this.showIcon;
    }

    public final boolean getCheckExists() {
        return this.checkExists;
    }

    @JvmOverloads
    public FileItemPrinter(boolean printFullPath, boolean showIcon, boolean checkExists) {
        boolean $i$f$filterByClass = false;
        super(ItemPrinterKt.filterByClass(File.class));
        this.printFullPath = printFullPath;
        this.showIcon = showIcon;
        this.checkExists = checkExists;
    }

    public /* synthetic */ FileItemPrinter(boolean bl, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        if ((n & 2) != 0) {
            bl2 = false;
        }
        if ((n & 4) != 0) {
            bl3 = false;
        }
        this(bl, bl2, bl3);
    }

    @JvmOverloads
    public FileItemPrinter(boolean printFullPath, boolean showIcon) {
        this(printFullPath, showIcon, false, 4, null);
    }

    @JvmOverloads
    public FileItemPrinter(boolean printFullPath) {
        this(printFullPath, false, false, 6, null);
    }

    @JvmOverloads
    public FileItemPrinter() {
        this(false, false, false, 7, null);
    }
}

