/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.toolchains;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.CapturingProcessRunner;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrToolsUtil {
    private static final Logger LOG = Logger.getInstance(CidrToolsUtil.class);
    public static final int READ_VERSION_TIMEOUT = 10000;
    public static final int PATH_CACHE_SIZE = 10000;
    private static final String envCommand = "env";
    private static final String envNullFlag = "--null";
    private static final String sourcePosixCommand = ".";
    private static final String redirectOutput = "1> /dev/null ";
    private static final String fallbackShellAdvancedSetting = "cidr.util.fallback.shell";

    @Nullable
    public static ProgressIndicator getProgressIndicator() {
        return ProgressIndicatorProvider.getGlobalProgressIndicator();
    }

    @NotNull
    public static ProcessOutput runWithProgress(CapturingProcessHandler handler) {
        return CidrToolsUtil.runWithProgress(handler, 0);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull BaseProcessHandler<?> handler, int timeout) {
        return CidrToolsUtil.runWithProgress(handler, timeout);
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull BaseProcessHandler<?> handler, @Nullable ProgressIndicator indicator, int timeout) {
        return CidrToolsUtil.runProcess(handler, indicator, timeout);
    }

    @NotNull
    public static ProcessOutput runWithProgress(@NotNull ProcessHandler handler, int timeout) {
        ProgressIndicator indicator = CidrToolsUtil.getProgressIndicator();
        ProcessOutput result2 = CidrToolsUtil.runProcess(handler, indicator, timeout);
        if (result2.isCancelled()) {
            throw new ProcessCanceledException();
        }
        return result2;
    }

    @NotNull
    public static ProcessOutput runProcess(@NotNull ProcessHandler handler, @Nullable ProgressIndicator indicator, int timeout) {
        return CidrToolsUtil.runProcess(new CapturingProcessRunner(handler), indicator, timeout);
    }

    private static ProcessOutput runProcess(@NotNull CapturingProcessRunner runner, @Nullable ProgressIndicator indicator, int timeout) {
        return indicator == null ? runner.runProcess(timeout) : runner.runProcess(indicator, timeout);
    }

    public static boolean checkSuccess(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output, @NotNull Logger logger) {
        if (output.getExitCode() == 0 && !output.isTimeout()) {
            return true;
        }
        logger.info(CidrToolsUtil.logInfo(cl, output));
        return false;
    }

    @NotNull
    public static String logInfo(@NotNull GeneralCommandLine cl, @NotNull ProcessOutput output) {
        return "[" + cl.getCommandLineString() + "]: " + CidrToolsUtil.extractError(output);
    }

    @NotNull
    public static String extractError(@NotNull ProcessOutput output) {
        StringBuilder sb = new StringBuilder();
        if (output.isTimeout()) {
            sb.append("(timed out)");
        } else {
            sb.append("(exit code ").append(output.getExitCode()).append(") ");
            if (!output.getStderr().isEmpty()) {
                sb.append(output.getStderr());
            } else {
                sb.append(output.getStdout());
            }
        }
        return sb.toString();
    }

    @Nullable
    public static String readOneLineWithProgress(@NotNull GeneralCommandLine commandLine, int timeout) {
        try {
            ProcessOutput output = CidrToolsUtil.runWithProgress(new CapturingProcessHandler(commandLine), timeout);
            return (String)ContainerUtil.getFirstItem((List)StringsKt.lines((CharSequence)output.getStdout()));
        }
        catch (ExecutionException e) {
            return null;
        }
    }

    public static void setHasPty(@NotNull OSProcessHandler processHandler, boolean usePty) {
        if (usePty) {
            processHandler.setHasPty(true);
            processHandler.setShouldDestroyProcessRecursively(false);
        }
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host) throws IOException, ExecutionException {
        return CidrToolsUtil.readLinuxEnvironmentFromFile(file, host, null, null);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull Path file, @NotNull HostMachine host) throws IOException, ExecutionException {
        return CidrToolsUtil.readLinuxEnvironmentFromFile(file.toString(), host, null, null);
    }

    @NotNull
    public static Map<String, String> readLinuxEnvironmentFromFile(@NotNull String file, @NotNull HostMachine host, @Nullable String interpreterPath, @Nullable String envPath) throws IOException, ExecutionException {
        String envCommand = envPath == null ? envCommand : envPath;
        boolean envSupportsNullFlag = CidrToolsUtil.testEnvForNullFlag(host, envCommand);
        if (interpreterPath == null && (interpreterPath = CidrToolsUtil.getShellPath(host, envCommand, envSupportsNullFlag)) == null) {
            LOG.warn("SHELL is not found in environment, falling back to advanced setting cidr.util.fallback.shell");
            interpreterPath = AdvancedSettings.getString((String)fallbackShellAdvancedSetting);
        }
        StringBuilder envCommandStringBuilder = new StringBuilder(envCommand);
        if (envSupportsNullFlag) {
            envCommandStringBuilder.append(" ").append(envNullFlag);
        }
        String sourceCommandString = ". " + CommandLineUtil.posixQuote((String)file) + " 1> /dev/null && " + envCommandStringBuilder;
        GeneralCommandLine readShellEnvCommand = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", envCommandStringBuilder.toString()});
        GeneralCommandLine readShellEnvWithFileCommand = new GeneralCommandLine(new String[]{interpreterPath, "-l", "-c", sourceCommandString});
        Map<String, String> shellEnv = CidrToolsUtil.runCommandAndParseEnv(readShellEnvCommand, host, envSupportsNullFlag);
        Map<String, String> shellEnvWithFile = CidrToolsUtil.runCommandAndParseEnv(readShellEnvWithFileCommand, host, envSupportsNullFlag);
        return CidrToolsUtil.subtractEnvironments(shellEnvWithFile, shellEnv);
    }

    @Nullable
    private static String getShellPath(@NotNull HostMachine host, String envCommand, boolean envSupportsNullFlag) throws ExecutionException, IOException {
        GeneralCommandLine envCmd = new GeneralCommandLine();
        envCmd.setExePath(envCommand);
        if (envSupportsNullFlag) {
            envCmd.addParameter(envNullFlag);
        }
        Map<String, String> initialEnv = CidrToolsUtil.runCommandAndParseEnv(envCmd, host, envSupportsNullFlag);
        return initialEnv.getOrDefault("SHELL", null);
    }

    private static boolean testEnvForNullFlag(@NotNull HostMachine host, @NotNull String envPath) {
        GeneralCommandLine envTestCmd = new GeneralCommandLine(new String[]{envPath, envNullFlag});
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{envTestCmd});
        try {
            ProcessOutput output = host.runProcess(envTestCmd, HostUtilKt.getReadEnvironmentFileTimeoutMs());
            return output.checkSuccess(CidrLogService.LOG);
        }
        catch (ExecutionException e) {
            return false;
        }
    }

    @NotNull
    private static Map<String, String> runCommandAndParseEnv(@NotNull GeneralCommandLine shellSourceCmd, @NotNull HostMachine host, final boolean envSupportsNullFlag) throws ExecutionException, IOException {
        CidrLogService.LOG.debug("Going to execute command {}", new Object[]{shellSourceCmd});
        final ProcessOutput sourceOutput = host.runProcess(shellSourceCmd.withEnvironment("LC_ALL", "C.UTF-8"), CidrToolsUtil.getProgressIndicator(), HostUtilKt.getReadEnvironmentFileTimeoutMs());
        if (!sourceOutput.checkSuccess(CidrLogService.LOG)) {
            throw new IOException(sourceOutput.getStderr());
        }
        return new HashMap<String, String>(){
            {
                Arrays.stream(sourceOutput.getStdout().split(envSupportsNullFlag ? "\u0000" : "\n")).forEach((? super T string) -> {
                    int index = string.indexOf("=");
                    if (index > 0) {
                        this.put(string.substring(0, index), string.substring(index + 1));
                    }
                });
            }
        };
    }

    @NotNull
    public static Map<String, String> subtractEnvironments(@NotNull Map<String, String> sourcedEnv, @NotNull Map<String, String> originalEnv) {
        HashMap<String, String> result2 = new HashMap<String, String>(sourcedEnv);
        originalEnv.forEach((key, value) -> {
            if (result2.containsKey(key) && Objects.equals(value, result2.get(key))) {
                result2.remove(key);
            }
        });
        return result2;
    }

    @Nullable
    public static File getXcodeSelect() {
        return CidrToolsUtil.getXcodeSelect(new CidrToolEnvironment(), null);
    }

    @Nullable
    public static File getXcodeSelect(@NotNull CidrToolEnvironment environment, @Nullable ProgressIndicator indicator) {
        GeneralCommandLine cl = new GeneralCommandLine();
        cl.setExePath("xcode-select");
        cl.addParameter("-print-path");
        cl.setCharset(CharsetToolkit.getDefaultSystemCharset());
        try {
            ProcessOutput result2 = environment.getHostMachine().runProcess(cl, indicator, 1000);
            if (result2.isTimeout()) {
                throw new ExecutionException("xcode-select timed out");
            }
            String err = result2.getStderr().trim();
            if (!StringUtil.isEmpty((String)err)) {
                throw new ExecutionException(err);
            }
            String path = result2.getStdout().trim();
            if (StringUtil.isEmptyOrSpaces((String)path)) {
                throw new ExecutionException("xcode-select returned an empty path");
            }
            return new File(path);
        }
        catch (ExecutionException e) {
            LOG.info("Cannot determine default Xcode version: " + e.getMessage());
            return null;
        }
    }

    public static class Status {
        @NotNull
        public final StatusCode code;
        @NotNull
        @Nls
        public final String message;

        public Status(@NotNull StatusCode code, @NotNull @Nls String message) {
            this.code = code;
            this.message = message;
        }

        public static Status error(@NotNull @Nls String message) {
            return new Status(StatusCode.ERROR, message);
        }

        public static Status of(@NotNull Pair<Boolean, @Nls String> status) {
            return new Status((Boolean)status.first != false ? StatusCode.OK : StatusCode.ERROR, (String)status.second);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Status status = (Status)o;
            return this.code == status.code && this.message.equals(status.message);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.code, this.message});
        }
    }

    public static enum StatusCode {
        OK,
        WARNING,
        ERROR;

    }
}

