/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.ColoredProcessHandler;
import com.intellij.execution.process.ElevationService;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.execution.process.WinRunnerMediator;
import com.intellij.execution.util.ExecUtil;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.Alarm;
import com.intellij.util.EnvReader;
import com.intellij.util.io.BaseOutputReader;
import com.jetbrains.cidr.CidrUtilsBundle;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.HostUtilKt;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalHost
implements HostMachine {
    public static final LocalHost INSTANCE = new LocalHost();
    private static final Logger LOG = Logger.getInstance(LocalHost.class);
    private static final int SUDO_KILL_DELAY_MILLIS = 1000;

    @Override
    public boolean isRemote() {
        return false;
    }

    @Override
    public boolean hasRemoteFS() {
        return false;
    }

    @Override
    @NotNull
    public OSType getOSType() {
        return OSType.getCurrent();
    }

    @Override
    @NotNull
    public CidrProcessBuilder createProcessBuilder() {
        return new CidrProcessBuilder(){

            @Override
            @NotNull
            protected BaseProcessHandler<?> build(@NotNull GeneralCommandLine cl, @NotNull CidrProcessBuilder.Parameters params) throws com.intellij.execution.ExecutionException {
                if (params.getUseExternalConsole() && SystemInfo.isWindows) {
                    WinRunnerMediator.withExternalConsole((GeneralCommandLine)cl);
                }
                Object processHandler = params.isElevated() ? (Registry.is((String)"cidr.elevation.daemon.enabled", (boolean)true) ? ElevationService.getInstance().createProcessHandler(cl) : LocalHost.createElevatedProcess(cl)) : (params.isColored() ? new ParameterizedColoredProcessHandler(cl, params) : (params.isCapturedOutput() ? new ParameterizedCapturingProcessHandler(cl, params) : new ParameterizedOSProcessHandler(cl, params)));
                CidrToolsUtil.setHasPty(processHandler, params.isPty());
                return processHandler;
            }
        };
    }

    private static void runSudoKill(@NotNull Process process) {
        if (process.isAlive()) {
            long pid = process.pid();
            GeneralCommandLine killCommand = new GeneralCommandLine(new String[]{"kill", Long.toString(pid)});
            try {
                ExecUtil.sudo((GeneralCommandLine)killCommand, (String)CidrUtilsBundle.message("sudo.prompt", new Object[0]));
            }
            catch (com.intellij.execution.ExecutionException | IOException e) {
                LOG.error("Can't kill the process " + pid, e);
            }
        }
    }

    @NotNull
    private static OSProcessHandler createElevatedProcess(GeneralCommandLine cl) throws com.intellij.execution.ExecutionException {
        try {
            cl = ExecUtil.sudoCommand((GeneralCommandLine)cl, (String)CidrUtilsBundle.message("sudo.prompt", new Object[0]));
        }
        catch (IOException e) {
            throw new com.intellij.execution.ExecutionException(CidrUtilsBundle.message("sudo.error", cl), (Throwable)e);
        }
        Object processHandler = SystemInfo.isWindows ? new OSProcessHandler(cl) : new KillableProcessHandler(cl){
            final Alarm sudoKillAlarm = new Alarm();

            private void scheduleSudoKill() {
                this.sudoKillAlarm.addRequest(() -> LocalHost.runSudoKill(this.getProcess()), 1000, ModalityState.any());
            }

            protected void doDestroyProcess() {
                this.scheduleSudoKill();
                super.doDestroyProcess();
            }

            public void killProcess() {
                this.scheduleSudoKill();
                super.killProcess();
            }

            protected void onOSProcessTerminated(int exitCode) {
                this.sudoKillAlarm.cancelAllRequests();
                super.onOSProcessTerminated(exitCode);
            }
        };
        return processHandler;
    }

    public void destroyProcess(@NotNull BaseProcessHandler handler) {
        handler.destroyProcess();
    }

    public void killProcessTree(@NotNull BaseProcessHandler handler) {
        OSProcessUtil.killProcessTree((Process)handler.getProcess());
    }

    @Override
    @NotNull
    public List<ProcessInfo> getProcessList() {
        return Arrays.asList(OSProcessUtil.getProcessList());
    }

    @Override
    public int sendSignal(int pid, @NotNull String signalName) {
        if (this.getOSType() == OSType.WIN) {
            throw new UnsupportedOperationException("Not supported for Windows OS, use winbreak instead");
        }
        return UnixProcessManager.sendSignal((int)pid, (String)signalName);
    }

    @Override
    @NotNull
    public Path getPath(String first, String ... more) {
        return Paths.get(first, more);
    }

    @Override
    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> paths, boolean resolveSymlink) {
        String[] result2 = new String[paths.size()];
        for (int i = 0; i < paths.size(); ++i) {
            result2[i] = FileUtil.toCanonicalPath((String)paths.get(i), (boolean)resolveSymlink);
        }
        return result2;
    }

    @Override
    @NotNull
    public Path getTempDirectory() {
        return Paths.get(FileUtil.getTempDirectory(), new String[0]);
    }

    @Override
    @NotNull
    public Path createTempDirectory(@NotNull String prefix, @Nullable String suffix) throws IOException {
        return FileUtil.createTempDirectory((String)prefix, (String)suffix).toPath();
    }

    @Override
    @NotNull
    public NamedPipe openNamedPipe() throws com.intellij.execution.ExecutionException {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull Path file) {
        return file.toFile();
    }

    @Override
    @NotNull
    public File resolvePath(@NotNull File file) {
        return file;
    }

    @Override
    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> paths) {
        return paths;
    }

    @Override
    @NotNull
    public String getHostId() {
        return "__localhost_machine__";
    }

    @Override
    @NotNull
    public Map<String, String> readEnvironmentFile(@NotNull String file) throws IOException, com.intellij.execution.ExecutionException {
        Path path = Paths.get(file, new String[0]);
        EnvReader reader = new EnvReader((long)HostUtilKt.getReadEnvironmentFileTimeoutMs());
        if (SystemInfo.isWindows) {
            return LocalHost.readEnvironmentFileCancellable(() -> reader.readBatEnv(path, null), () -> reader.readBatEnv(null, null));
        }
        if (SystemInfo.isMac) {
            return LocalHost.readEnvironmentFileCancellable(() -> reader.readShellEnv(path, null), () -> reader.readShellEnv(null, null));
        }
        return CidrToolsUtil.readLinuxEnvironmentFromFile(path, (HostMachine)this);
    }

    private static Map<String, String> readEnvironmentFileCancellable(EnvironmentProducer fileEnvProducer, EnvironmentProducer defaultEnvProducer) throws IOException {
        ExecutorService pool = Executors.newFixedThreadPool(1);
        CompletableFuture<Map> future = CompletableFuture.supplyAsync(() -> {
            Thread.currentThread().setName("env-reader-thread");
            try {
                return CidrToolsUtil.subtractEnvironments(fileEnvProducer.getEnvironment(), defaultEnvProducer.getEnvironment());
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
                throw new RuntimeException(e);
            }
        }, pool);
        Map environment = null;
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        while (environment == null) {
            if (indicator != null) {
                try {
                    indicator.checkCanceled();
                }
                catch (ProcessCanceledException pce) {
                    LOG.debug("indicator is cancelled, cancelling future and thread pool");
                    future.cancel(true);
                    pool.shutdownNow();
                    throw pce;
                }
            }
            try {
                environment = future.get(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof RuntimeException) {
                    if (cause.getCause() instanceof IOException) {
                        throw (IOException)cause.getCause();
                    }
                    throw (RuntimeException)cause.getCause();
                }
                throw new RuntimeException(e);
            }
            catch (TimeoutException timeoutException) {
            }
        }
        return environment;
    }

    @FunctionalInterface
    static interface EnvironmentProducer {
        public Map<String, String> getEnvironment() throws IOException;
    }

    public static class ParameterizedOSProcessHandler
    extends OSProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedOSProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws com.intellij.execution.ExecutionException {
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedOSProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws com.intellij.execution.ExecutionException {
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
        }
    }

    public static class ParameterizedCapturingProcessHandler
    extends CapturingProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedCapturingProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws com.intellij.execution.ExecutionException {
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedCapturingProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws com.intellij.execution.ExecutionException {
            super(process, commandLine.getCharset(), commandLine.getCommandLineString());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
        }
    }

    public static class ParameterizedColoredProcessHandler
    extends ColoredProcessHandler {
        @NotNull
        private final CidrProcessBuilder.Parameters myParameters;

        public ParameterizedColoredProcessHandler(@NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws com.intellij.execution.ExecutionException {
            super(commandLine);
            this.myParameters = parameters;
        }

        public ParameterizedColoredProcessHandler(@NotNull Process process, @NotNull GeneralCommandLine commandLine, @NotNull CidrProcessBuilder.Parameters parameters) throws com.intellij.execution.ExecutionException {
            super(process, commandLine.getCommandLineString(), commandLine.getCharset());
            this.myParameters = parameters;
        }

        @NotNull
        protected BaseOutputReader.Options readerOptions() {
            return HostUtilKt.readerOptions(this.myParameters, super.readerOptions());
        }
    }
}

