/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.system;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.toolchains.CidrToolsUtil;
import com.jetbrains.cidr.toolchains.OSType;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface HostMachine {
    public boolean isRemote();

    public boolean hasRemoteFS();

    @NotNull
    public OSType getOSType();

    @NotNull
    default public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, int timeout) throws ExecutionException {
        return this.runProcess(cl, null, timeout);
    }

    @NotNull
    default public ProcessOutput runProcess(@NotNull GeneralCommandLine cl, @Nullable ProgressIndicator indicator, int timeout) throws ExecutionException {
        BaseProcessHandler<?> processHandler = this.createProcessBuilder().withCapturedOutput(true).withShortLived(true).withProgressIndicator(indicator).build(cl);
        return CidrToolsUtil.runProcess(processHandler, indicator, timeout);
    }

    @NotNull
    default public BaseProcessHandler<?> createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty) throws ExecutionException {
        return this.createProcess(cl, colored, usePty, true, false, false);
    }

    @NotNull
    default public BaseProcessHandler<?> createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty, boolean captureProcessOutput, boolean splitLines) throws ExecutionException {
        return this.createProcess(cl, colored, usePty, captureProcessOutput, splitLines, false);
    }

    @Deprecated(forRemoval=true)
    @NotNull
    default public BaseProcessHandler<?> createProcess(@NotNull GeneralCommandLine cl, boolean colored, boolean usePty, boolean captureProcessOutput, boolean splitLines, boolean isElevated) throws ExecutionException {
        return this.createProcessBuilder().withColoredOutput(colored).withPty(usePty).withCapturedOutput(captureProcessOutput).withSplitToLines(splitLines).withElevated(isElevated).build(cl);
    }

    @NotNull
    public CidrProcessBuilder createProcessBuilder();

    public void destroyProcess(@NotNull BaseProcessHandler<?> var1);

    public void killProcessTree(@NotNull BaseProcessHandler<?> var1);

    @NotNull
    public List<ProcessInfo> getProcessList() throws ExecutionException;

    default public int sendSignal(int pid, @NotNull String signalName, @NotNull Process mainProcess) {
        return this.sendSignal(pid, signalName);
    }

    public int sendSignal(int var1, @NotNull String var2);

    @NotNull
    public Path getPath(@NotNull @NonNls String var1, String ... var2);

    @NotNull
    public @NotNull String @NotNull [] toCanonicalPath(@NotNull List<@NonNls String> var1, boolean var2);

    @Deprecated
    @NotNull
    default public String toCanonicalPath(@NotNull String path, boolean resolveSymlink) {
        String[] result2 = this.toCanonicalPath(Collections.singletonList(path), resolveSymlink);
        if (result2.length != 1) {
            Logger.getInstance(HostMachine.class).error("cannot get canonical path: " + path);
            return path;
        }
        return result2[0];
    }

    @NotNull
    public Path getTempDirectory();

    @NotNull
    public Path createTempDirectory(@NotNull @NonNls String var1, @Nullable @NonNls String var2) throws IOException;

    @NotNull
    public NamedPipe openNamedPipe() throws ExecutionException;

    @NotNull
    public File resolvePath(@NotNull Path var1) throws IOException;

    @NotNull
    public File resolvePath(@NotNull File var1) throws IOException;

    @NotNull
    public List<String> resolveAndCache(@NotNull List<String> var1);

    @NotNull
    @NonNls
    public String getHostId();

    default public void invalidateCache() {
    }

    @NotNull
    @NonNls
    default public String getName() {
        return (this.isRemote() ? "Remote " : "Local ") + this.getOSType();
    }

    @NotNull
    public Map<String, String> readEnvironmentFile(@NotNull String var1) throws IOException, ExecutionException;

    @NotNull
    default public List<Path> findFilesWithExtension(@NotNull Path rootPath, Boolean recursive, final String ... extensions) throws IOException, ExecutionException {
        if (!Files.exists(rootPath, new LinkOption[0])) {
            return ContainerUtil.emptyList();
        }
        if (recursive.booleanValue()) {
            final ArrayList<Path> files = new ArrayList<Path>();
            Files.walkFileTree(rootPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult visitFile(@Nullable Path file, @Nullable BasicFileAttributes attrs) {
                    if (file != null && Files.isRegularFile(file, new LinkOption[0]) && ContainerUtil.exists((Object[])extensions, e -> file.toString().endsWith((String)e))) {
                        files.add(file);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            return files;
        }
        try (Stream<Path> filesStream = Files.list(rootPath);){
            List<Path> list = filesStream.filter(p -> Files.isRegularFile(p, new LinkOption[0]) && ContainerUtil.exists((Object[])extensions, e -> p.toString().endsWith((String)e))).collect(Collectors.toList());
            return list;
        }
    }

    @RequiresBackgroundThread
    default public void waitForFilesSync(@NotNull ProgressIndicator pi) {
    }
}

