/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory.hexdump;

import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.AddressUtil;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.AbstractHexdumpDataProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003\u000f\u0010\u0011B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u000b\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataProvider;", "", "()V", "createDataPlaceholder", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "holeRange", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "fromMemoryHunkList", "", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$ByteData;", "memoryHunks", "Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;", "ByteData", "ByteDataPlaceholder", "SingleByteDataEntry", "intellij.cidr.debugger"})
public abstract class AbstractHexdumpDataProvider
implements CidrMemoryData.DataProvider<Byte> {
    @Override
    @NotNull
    public CidrMemoryData.DataPlaceholder<Byte> createDataPlaceholder(@NotNull Address address, @NotNull AddressRange holeRange) {
        int blockSize = 256;
        AddressRange alignedRange = AddressUtil.toAlignedBlockRange(address, blockSize);
        return new ByteDataPlaceholder(alignedRange.intersectWith(holeRange), null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ByteData> fromMemoryHunkList(@NotNull List<LLMemoryHunk> memoryHunks) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = memoryHunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            LLMemoryHunk lLMemoryHunk = (LLMemoryHunk)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ByteData byteData = new ByteData((LLMemoryHunk)it);
            collection.add(byteData);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0012\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0005\u001a\u00028\u0000X\u0096\u0004\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$SingleByteDataEntry;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "value", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Ljava/lang/Object;)V", "getAddress", "()Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "intellij.cidr.debugger"})
    private static class SingleByteDataEntry<T>
    implements CidrMemoryData.DataEntry<T> {
        @NotNull
        private final Address address;
        private final T value;

        @Override
        @NotNull
        public AddressRange getRange() {
            return AddressUtil.addressToRange(this.getAddress(), 1L);
        }

        @Override
        @NotNull
        public Address getAddress() {
            return this.address;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        public SingleByteDataEntry(@NotNull Address address, T value) {
            this.address = address;
            this.value = value;
        }

        @Override
        @NotNull
        public Iterable<CidrMemoryData.DataEntry<T>> getEntries() {
            return CidrMemoryData.DataEntry.DefaultImpls.getEntries(this);
        }

        @Override
        @NotNull
        public CidrMemoryData.DataEntry<T> subRangeImpl(@NotNull AddressRange subRange) {
            return CidrMemoryData.DataEntry.DefaultImpls.subRangeImpl(this, subRange);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u001d\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nB#\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$ByteData;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "", "memoryHunk", "Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;", "(Lcom/jetbrains/cidr/execution/debugger/backend/LLMemoryHunk;)V", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "bytes", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;)V", "offset", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Ljava/util/List;I)V", "getBytes", "()Ljava/util/List;", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getEntries", "()Ljava/lang/Iterable;", "getOffset", "()I", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "subRangeImpl", "subRange", "intellij.cidr.debugger"})
    public static final class ByteData
    implements CidrMemoryData.DataBlock<Byte> {
        @NotNull
        private final Iterable<CidrMemoryData.DataEntry<Byte>> entries;
        @NotNull
        private final AddressRange range;
        @NotNull
        private final List<Byte> bytes;
        private final int offset;

        @Override
        @NotNull
        public Iterable<CidrMemoryData.DataEntry<Byte>> getEntries() {
            return this.entries;
        }

        @Override
        @NotNull
        public CidrMemoryData.DataBlock<Byte> subRangeImpl(@NotNull AddressRange subRange) {
            return new ByteData(subRange, this.bytes, this.offset + (int)subRange.getStart().minus(this.getRange().getStart()));
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @NotNull
        public final List<Byte> getBytes() {
            return this.bytes;
        }

        public final int getOffset() {
            return this.offset;
        }

        public ByteData(@NotNull AddressRange range, @NotNull List<Byte> bytes, int offset) {
            boolean bl;
            this.range = range;
            this.bytes = bytes;
            this.offset = offset;
            boolean bl2 = bl = (int)this.getRange().getSize() >= this.bytes.size() - this.offset;
            if (!bl) {
                String string = "Failed requirement.";
                throw new IllegalArgumentException(string.toString());
            }
            this.entries = SequencesKt.asIterable((Sequence)SequencesKt.mapIndexed((Sequence)CollectionsKt.asSequence((Iterable)this.getRange()), (Function2)((Function2)new Function2<Integer, Address, SingleByteDataEntry<Byte>>(this){
                final /* synthetic */ ByteData this$0;

                @NotNull
                public final SingleByteDataEntry<Byte> invoke(int i, @NotNull Address address) {
                    return new SingleByteDataEntry<Byte>(address, this.this$0.getBytes().get(this.this$0.getOffset() + i));
                }
                {
                    this.this$0 = byteData;
                    super(2);
                }
            })));
        }

        public ByteData(@NotNull LLMemoryHunk memoryHunk) {
            this(memoryHunk.getRange(), memoryHunk.getBytes());
        }

        public ByteData(@NotNull AddressRange range, @NotNull List<Byte> bytes) {
            this(range, bytes, 0);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0004H\u0016R\"\u0010\u0007\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\t0\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider$ByteDataPlaceholder;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataPlaceholder;", "", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "requestRange", "(Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;)V", "entries", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "getEntries", "()Ljava/lang/Iterable;", "getRange", "()Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "getRequestRange", "subRangeImpl", "subRange", "intellij.cidr.debugger"})
    private static final class ByteDataPlaceholder
    implements CidrMemoryData.DataPlaceholder<Byte> {
        @NotNull
        private final Iterable<CidrMemoryData.DataEntry<Byte>> entries;
        @NotNull
        private final AddressRange range;
        @NotNull
        private final AddressRange requestRange;

        @Override
        @NotNull
        public Iterable<CidrMemoryData.DataEntry<Byte>> getEntries() {
            return this.entries;
        }

        @NotNull
        public ByteDataPlaceholder subRangeImpl(@NotNull AddressRange subRange) {
            return new ByteDataPlaceholder(subRange, this.getRequestRange());
        }

        @Override
        @NotNull
        public AddressRange getRange() {
            return this.range;
        }

        @Override
        @NotNull
        public AddressRange getRequestRange() {
            return this.requestRange;
        }

        public ByteDataPlaceholder(@NotNull AddressRange range, @NotNull AddressRange requestRange) {
            this.range = range;
            this.requestRange = requestRange;
            this.entries = SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.getRange()), (Function1)entries.1.INSTANCE));
        }

        public /* synthetic */ ByteDataPlaceholder(AddressRange addressRange, AddressRange addressRange2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                addressRange2 = addressRange;
            }
            this(addressRange, addressRange2);
        }

        @Override
        @Nullable
        public Byte getValue() {
            return CidrMemoryData.DataPlaceholder.DefaultImpls.getValue(this);
        }

        @Override
        @NotNull
        public Address getAddress() {
            return CidrMemoryData.DataPlaceholder.DefaultImpls.getAddress(this);
        }
    }
}

