/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.DeprecatedVirtualFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDoc;
import com.jetbrains.cidr.execution.debugger.memory.MemoryViewFile;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\t\u001a\u00020\b2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0016J\b\u0010\u0017\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0016\u001a\u00020\u0007H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem;", "Lcom/intellij/openapi/vfs/DeprecatedVirtualFileSystem;", "()V", "counter", "Ljava/util/concurrent/atomic/AtomicInteger;", "files", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewFile;", "createMemoryViewFile", "memoryDoc", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryDoc;", "name", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "deleteFile", "", "requestor", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "findFileByPath", "path", "getProtocol", "refresh", "asynchronous", "", "refreshAndFindFileByPath", "Companion", "intellij.cidr.debugger"})
public final class MemoryViewVirtualFileSystem
extends DeprecatedVirtualFileSystem {
    private final ConcurrentHashMap<String, MemoryViewFile> files = new ConcurrentHashMap();
    private final AtomicInteger counter = new AtomicInteger(0);
    private static final String PROTOCOL = "cidr-memory-view";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final MemoryViewFile createMemoryViewFile(@NotNull CidrMemoryDoc<?> memoryDoc, @NotNull String name, @NotNull FileType fileType) {
        int id = this.counter.getAndIncrement();
        MemoryViewFile file = new MemoryViewFile(memoryDoc, name, fileType, id);
        ((Map)this.files).put(file.getPath(), file);
        return file;
    }

    @NotNull
    public String getProtocol() {
        return PROTOCOL;
    }

    @Nullable
    public VirtualFile findFileByPath(@NotNull String path) {
        return (VirtualFile)this.files.get(path);
    }

    public void refresh(boolean asynchronous) {
    }

    @Nullable
    public VirtualFile refreshAndFindFileByPath(@NotNull String path) {
        return this.findFileByPath(path);
    }

    protected void deleteFile(@Nullable Object requestor, @NotNull VirtualFile file) {
        this.files.remove(file.getPath());
    }

    @JvmStatic
    @NotNull
    public static final MemoryViewVirtualFileSystem getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem$Companion;", "", "()V", "PROTOCOL", "", "getInstance", "Lcom/jetbrains/cidr/execution/debugger/memory/MemoryViewVirtualFileSystem;", "intellij.cidr.debugger"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final MemoryViewVirtualFileSystem getInstance() {
            boolean $i$f$service = false;
            Class<VirtualFileManager> serviceClass$iv = VirtualFileManager.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            VirtualFileSystem virtualFileSystem = ((VirtualFileManager)object).getFileSystem(MemoryViewVirtualFileSystem.PROTOCOL);
            if (virtualFileSystem == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.memory.MemoryViewVirtualFileSystem");
            }
            return (MemoryViewVirtualFileSystem)virtualFileSystem;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

