/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.Processor;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.memory.AbstractDocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressSpace;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.DocRegion;
import com.jetbrains.cidr.execution.debugger.memory.Interval;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.ClosedRange;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000v\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 4*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u00014B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\b\u0012\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\n\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u001c\u0010\u0013\u001a\u00020\u00122\u0012\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u000b0\nH\u0002J\u0014\u0010\u0014\u001a\u00020\u00122\n\u0010\u0015\u001a\u0006\u0012\u0002\b\u00030\u0000H\u0014J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u0019H$J\u0010\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017H$J\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0017H\u0016J\u0018\u0010 \u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u0019H\u0014J$\u0010!\u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$2\u000e\u0010%\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000&H$J\u0014\u0010'\u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010(\u001a\u00020\u00122\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010)\u001a\u00020\u00122\n\u0010*\u001a\u00060+j\u0002`,H\u0002J\b\u0010-\u001a\u00020.H\u0016J\"\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000600*\u0002012\u0006\u00102\u001a\u00020\u00192\u0006\u00103\u001a\u00020\u0019H\u0002R\u001c\u0010\r\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u00065"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion;", "T", "Lcom/jetbrains/cidr/execution/debugger/memory/AbstractDocRegion;", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "dataRegion", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;", "reallocatedSpace", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;", "Lcom/jetbrains/cidr/execution/debugger/memory/DocRegion;", "(Lcom/intellij/openapi/editor/Document;Lcom/intellij/openapi/util/TextRange;Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataRegion;Lcom/jetbrains/cidr/execution/debugger/memory/AddressSpace;)V", "data", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "getData", "()Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$Data;", "deleteFromDocument", "", "doRenderReallocated", "doRenderSeamless", "oldRegion", "getAddressForLineNumberInDocument", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "line", "", "getAddressForLineNumberInsideRegion", "lineNumber", "getLineNumberInDocument", "address", "getLineNumberInsideRegion", "getOffsetInDocument", "getOffsetInsideLine", "renderEntry", "buffer", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "dataEntry", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataEntry;", "renderFooter", "renderHeader", "replaceSafely", "sb", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "toString", "", "getProtectedRanges", "", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "startOffset", "endOffset", "Companion", "intellij.cidr.debugger"})
public abstract class BaseDocRegion<T>
extends AbstractDocRegion<T> {
    @NotNull
    private final CidrMemoryData.Data<T> data;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    protected final CidrMemoryData.Data<T> getData() {
        return this.data;
    }

    protected void doRenderSeamless(@NotNull BaseDocRegion<?> oldRegion) {
        StringBuilder sb = new StringBuilder();
        this.renderHeader(sb);
        Iterable<CidrMemoryData.DataEntry<T>> $this$forEach$iv = this.data.getEntries();
        boolean $i$f$forEach = false;
        Iterator<CidrMemoryData.DataEntry<T>> iterator2 = $this$forEach$iv.iterator();
        while (iterator2.hasNext()) {
            CidrMemoryData.DataEntry<T> element$iv;
            CidrMemoryData.DataEntry<T> entry = element$iv = iterator2.next();
            boolean bl = false;
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        if (oldRegion.getTextRange().getLength() == sb.length()) {
            super.replaceSafely(sb);
        } else {
            this.getDocument().replaceString(this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset(), (CharSequence)sb);
        }
    }

    private final void doRenderReallocated(AddressSpace<DocRegion<T>> reallocatedSpace) {
        StringBuilder sb = new StringBuilder();
        int lastOffset = this.getRangeMarker().getStartOffset();
        this.renderHeader(sb);
        for (CidrMemoryData.DataEntry<T> entry : this.data.getEntries()) {
            Iterable $this$forEach$iv = reallocatedSpace.get(entry.getRange()).filterRegions();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Unit unit;
                boolean bl;
                DocRegion reallocatedRegion = (DocRegion)element$iv;
                boolean bl2 = false;
                boolean bl3 = bl = reallocatedRegion.getDocument() == this.getDocument();
                if (!bl) {
                    String string = "Failed requirement.";
                    throw new IllegalArgumentException(string.toString());
                }
                this.getDocument().insertString(lastOffset, (CharSequence)sb);
                Unit it = unit = Unit.INSTANCE;
                boolean bl4 = false;
                lastOffset += sb.length();
                sb.setLength(0);
                reallocatedRegion.deleteFromDocument();
            }
            this.renderEntry(sb, entry);
        }
        this.renderFooter(sb);
        this.getDocument().replaceString(lastOffset, this.getRangeMarker().getEndOffset(), (CharSequence)sb);
    }

    /*
     * WARNING - void declaration
     */
    private final void replaceSafely(StringBuilder sb) {
        if (this.getRangeMarker().isValid()) {
            DocumentEx documentEx;
            Document document2 = this.getDocument();
            if (document2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
            }
            DocumentEx $this$with = documentEx = (DocumentEx)document2;
            boolean bl = false;
            int offset = this.getRangeMarker().getStartOffset();
            List<TextRange> protectedRanges = this.getProtectedRanges($this$with, offset, this.getRangeMarker().getEndOffset());
            for (TextRange textRange : protectedRanges) {
                void startOffset;
                int n = BaseDocRegion.Companion.component1(textRange);
                int endOffset = BaseDocRegion.Companion.component2(textRange);
                $this$with.replaceString((int)startOffset, endOffset, (CharSequence)sb.substring((int)(startOffset - offset), endOffset - offset));
            }
            this.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deleteFromDocument() {
        if (this.getRangeMarker().isValid()) {
            DocumentEx documentEx;
            Document document2 = this.getDocument();
            if (document2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.editor.ex.DocumentEx");
            }
            DocumentEx $this$with = documentEx = (DocumentEx)document2;
            boolean bl = false;
            List<TextRange> protectedRanges = this.getProtectedRanges($this$with, this.getRangeMarker().getStartOffset(), this.getRangeMarker().getEndOffset());
            for (TextRange textRange : CollectionsKt.reversed((Iterable)protectedRanges)) {
                void startOffset;
                int n = BaseDocRegion.Companion.component1(textRange);
                int endOffset = BaseDocRegion.Companion.component2(textRange);
                $this$with.deleteString((int)startOffset, endOffset);
            }
            boolean bl2 = this.getTextRange().isEmpty();
            if (!bl2) {
                boolean bl3 = false;
                String string = "DocRegion text range is not empty after deleting it";
                throw new IllegalStateException(string.toString());
            }
            this.dispose();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<TextRange> getProtectedRanges(DocumentEx $this$getProtectedRanges, int startOffset, int endOffset) {
        List list;
        Set protectedOffsets = new LinkedHashSet();
        int length = endOffset - startOffset;
        if (length == 0) {
            return CollectionsKt.emptyList();
        }
        int n = startOffset;
        IntRange range = new IntRange(n, endOffset);
        Processor processor2 = new Processor(range, protectedOffsets, startOffset){
            final /* synthetic */ IntRange $range;
            final /* synthetic */ Set $protectedOffsets;
            final /* synthetic */ int $startOffset;

            public final boolean process(RangeMarker eachMarker) {
                Integer n;
                Collection collection;
                int n2;
                int it = n2 = eachMarker.getStartOffset();
                boolean bl = false;
                if (this.$range.contains(it)) {
                    collection = this.$protectedOffsets;
                    n = it - this.$startOffset;
                    collection.add(n);
                }
                it = n2 = eachMarker.getEndOffset();
                boolean bl2 = false;
                if (this.$range.contains(it)) {
                    collection = this.$protectedOffsets;
                    n = it - this.$startOffset;
                    collection.add(n);
                }
                return true;
            }
            {
                this.$range = intRange;
                this.$protectedOffsets = set;
                this.$startOffset = n;
            }
        };
        $this$getProtectedRanges.processRangeMarkersOverlappingWith(startOffset, endOffset, processor2);
        EditorFactory.getInstance().editors((Document)$this$getProtectedRanges).forEach(new Consumer(startOffset, endOffset, processor2){
            final /* synthetic */ int $startOffset;
            final /* synthetic */ int $endOffset;
            final /* synthetic */ Processor $processor;

            public final void accept(Editor editor) {
                block1: {
                    EditorEx editorEx;
                    Editor editor2 = editor;
                    if (!(editor2 instanceof EditorEx)) {
                        editor2 = null;
                    }
                    if ((editorEx = (EditorEx)editor2) == null || (editorEx = editorEx.getMarkupModel()) == null) break block1;
                    editorEx.processRangeHighlightersOverlappingWith(this.$startOffset, this.$endOffset, this.$processor);
                }
            }
            {
                this.$startOffset = n;
                this.$endOffset = n2;
                this.$processor = processor2;
            }
        });
        boolean bl = protectedOffsets.contains(0);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        bl = protectedOffsets.contains(length);
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Iterable $this$zipWithNext$iv = CollectionsKt.sorted((Iterable)protectedOffsets);
        boolean $i$f$zipWithNext = false;
        Iterator iterator$iv = $this$zipWithNext$iv.iterator();
        if (!iterator$iv.hasNext()) {
            list = CollectionsKt.emptyList();
        } else {
            List result$iv = new ArrayList();
            Object current$iv = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void eachEndOffset;
                void eachStartOffset;
                Object next$iv = iterator$iv.next();
                int n2 = ((Number)next$iv).intValue();
                int n3 = ((Number)current$iv).intValue();
                List list2 = result$iv;
                boolean bl2 = false;
                TextRange textRange = new TextRange(startOffset + eachStartOffset, startOffset + eachEndOffset);
                list2.add(textRange);
                current$iv = next$iv;
            }
            list = result$iv;
        }
        return list;
    }

    protected abstract void renderEntry(@NotNull Appendable var1, @NotNull CidrMemoryData.DataEntry<? extends T> var2);

    protected void renderHeader(@NotNull Appendable buffer) {
    }

    protected void renderFooter(@NotNull Appendable buffer) {
    }

    @Nullable
    protected abstract Address getAddressForLineNumberInsideRegion(int var1);

    protected abstract int getLineNumberInsideRegion(@NotNull Address var1);

    protected int getOffsetInsideLine(@NotNull Address address, int lineNumber) {
        return 0;
    }

    @Override
    @Nullable
    public Address getAddressForLineNumberInDocument(int line) {
        int n;
        IntRange regionLineRange = this.getLineRangeInDocument();
        int it = n = RangesKt.coerceIn((int)line, (ClosedRange)((ClosedRange)regionLineRange));
        boolean bl = false;
        if (it != line) {
            CidrDebuggerLog.LOG.warn("Line number " + line + " is outside the region line range " + regionLineRange);
        }
        int lineNumberInsideRegion = n - regionLineRange.getStart();
        return this.getAddressForLineNumberInsideRegion(lineNumberInsideRegion);
    }

    @Override
    public int getLineNumberInDocument(@NotNull Address address) {
        int n;
        boolean bl = this.getRangeMarker().isValid();
        if (!bl) {
            boolean $i$a$-check-BaseDocRegion$getLineNumberInDocument$22 = false;
            String $i$a$-check-BaseDocRegion$getLineNumberInDocument$22 = "Region is disposed or otherwise removed from the Document";
            throw new IllegalStateException($i$a$-check-BaseDocRegion$getLineNumberInDocument$22.toString());
        }
        int regionLineNumber = this.getDocument().getLineNumber(this.getRangeMarker().getStartOffset());
        int lineNumber = !this.getRange().contains((Comparable)address) ? 0 : this.getLineNumberInsideRegion(address);
        int it = n = RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(regionLineNumber + lineNumber), (int)(this.getDocument().getLineCount() - 1)), (int)0);
        boolean bl2 = false;
        if (regionLineNumber + lineNumber != it) {
            CidrDebuggerLog.LOG.warn("Computed line number " + regionLineNumber + "+" + lineNumber + " is outside the document boundary " + it);
        }
        return n;
    }

    @Override
    public int getOffsetInDocument(@NotNull Address address) {
        int lineNumber = this.getLineNumberInDocument(address);
        int offsetInLine = this.getOffsetInsideLine(address, lineNumber);
        return RangesKt.coerceAtLeast((int)RangesKt.coerceAtMost((int)(this.getDocument().getLineStartOffset(lineNumber) + offsetInLine), (int)(this.getDocument().getTextLength() - 1)), (int)0);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(range=" + this.getRange() + ", myRangeMarker=" + this.getRangeMarker() + ")";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public BaseDocRegion(@NotNull Document document2, @NotNull TextRange textRange, @NotNull CidrMemoryData.DataRegion<T> dataRegion, @NotNull AddressSpace<DocRegion<T>> reallocatedSpace) {
        super(document2, textRange, dataRegion);
        boolean bl;
        void $this$withMarkerGreedy$iv;
        Object object;
        Object object2;
        Interval it;
        Object object3;
        this.data = dataRegion.getData();
        boolean bl2 = reallocatedSpace.getRange().contains(this.getRange());
        if (!bl2) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        boolean bl3 = bl2 = !(dataRegion instanceof CidrMemoryData.DataRegion.Completed.LoadError);
        if (!bl2) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Interval interval = (Interval)CollectionsKt.singleOrNull((Iterable)reallocatedSpace.getIntervals());
        if (interval != null) {
            object3 = interval;
            it = object3;
            boolean bl4 = false;
            object2 = Intrinsics.areEqual(it.getClass(), this.getClass()) && Intrinsics.areEqual((Object)it.getRange(), (Object)this.getRange()) ? object3 : null;
        } else {
            object2 = object = null;
        }
        if (!(object2 instanceof BaseDocRegion)) {
            object = null;
        }
        BaseDocRegion seamlessRegionUpdate = (BaseDocRegion)object;
        it = this.getRangeMarker();
        object3 = AbstractDocRegion.Companion;
        boolean value$iv = true;
        boolean $i$f$withMarkerGreedy$intellij_cidr_debugger = false;
        boolean savedToLeft$iv = $this$withMarkerGreedy$iv.isGreedyToLeft();
        boolean savedToRight$iv = $this$withMarkerGreedy$iv.isGreedyToRight();
        $this$withMarkerGreedy$iv.setGreedyToLeft(value$iv);
        $this$withMarkerGreedy$iv.setGreedyToRight(value$iv);
        try {
            boolean bl5 = false;
            if (seamlessRegionUpdate != null) {
                this.doRenderSeamless(seamlessRegionUpdate);
            } else {
                this.doRenderReallocated(reallocatedSpace);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            $this$withMarkerGreedy$iv.setGreedyToLeft(savedToLeft$iv);
            $this$withMarkerGreedy$iv.setGreedyToRight(savedToRight$iv);
        }
        boolean bl6 = bl = this.getRangeMarker().getStartOffset() != this.getRangeMarker().getEndOffset();
        if (!bl) {
            boolean bl7 = false;
            String string = "DocRegion text range is empty after rendering";
            throw new IllegalStateException(string.toString());
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\r\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0082\u0002J\r\u0010\u0006\u001a\u00020\u0004*\u00020\u0005H\u0082\u0002\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/BaseDocRegion$Companion;", "", "()V", "component1", "", "Lcom/intellij/openapi/util/TextRange;", "component2", "intellij.cidr.debugger"})
    public static final class Companion {
        private final int component1(TextRange $this$component1) {
            return $this$component1.getStartOffset();
        }

        private final int component2(TextRange $this$component2) {
            return $this$component2.getEndOffset();
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

