/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class ValueRendererUtils {
    public static final char MARK_CHAR = '\u00fe';

    public static boolean isQuotedString(@NotNull String s) {
        return ValueRendererUtils.isBeginQuotedString(s) && s.charAt(s.length() - 1) == '\"';
    }

    private static int skipMark(@NotNull String text, int textLength, int startIndex) {
        char next;
        if (startIndex + 2 <= textLength && text.charAt(startIndex) == '\u00fe' && ((next = text.charAt(startIndex + 1)) == 'S' || next == 'K' || next == 'N' || next == 'C' || next == 'V' || next == 'E')) {
            startIndex += 2;
        }
        return startIndex;
    }

    public static boolean isBeginQuotedString(@NotNull String s) {
        int stringLen = s.length();
        if (stringLen <= 1) {
            return false;
        }
        int start = 0;
        if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) + 1 < stringLen && s.charAt(start) == '0' && s.charAt(start + 1) == 'x') {
            start += 2;
            while (start < stringLen && StringUtil.isHexDigit((char)s.charAt(start))) {
                ++start;
            }
            if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) >= stringLen || s.charAt(start) != ' ') {
                return false;
            }
            ++start;
        }
        if ((start = ValueRendererUtils.skipMark(s, stringLen, start)) < stringLen && (s.charAt(start) == 'L' || s.charAt(start) == 'U' || s.charAt(start) == 'u')) {
            ++start;
        }
        return start + 1 < stringLen && s.charAt(start) == '\"';
    }

    @NotNull
    public static String getRawString(@NotNull String s) {
        int stringLen = s.length();
        if (stringLen >= 2) {
            char ch0;
            int start = 0;
            if (s.charAt(start) == '0' && s.charAt(start + 1) == 'x') {
                start += 2;
                while (start < s.length() && StringUtil.isHexDigit((char)s.charAt(start))) {
                    ++start;
                }
                if (s.charAt(start) == ' ') {
                    ++start;
                } else {
                    return StringUtil.unescapeStringCharacters((String)s);
                }
            }
            if ((ch0 = s.charAt(start)) == '\"') {
                ++start;
            } else if (start + 2 < stringLen && (ch0 == 'L' || ch0 == 'U' || ch0 == 'u') && s.charAt(start + 1) == '\"') {
                start += 2;
            } else {
                return StringUtil.unescapeStringCharacters((String)s);
            }
            if (s.endsWith("\"")) {
                s = s.substring(start, stringLen - 1);
            } else if (s.endsWith("\u2026")) {
                char ch = s.charAt(stringLen - 2);
                s = ch == '\"' ? s.substring(start, stringLen - 2) : s.substring(start, stringLen - 1);
            } else if (s.endsWith("...") && stringLen >= start + 4) {
                char ch = s.charAt(stringLen - 4);
                s = ch == '\"' ? s.substring(start, stringLen - 4) : s.substring(start, stringLen - 3);
            }
        }
        s = StringUtil.unescapeStringCharacters((String)s);
        return s;
    }

    @NotNull
    public static String extractString(@NotNull String formattedText) {
        StringBuilder result2 = new StringBuilder();
        int length = formattedText.length();
        int index = 0;
        while ((index = ValueRendererUtils.skipMark(formattedText, length, index)) < length) {
            char ch = formattedText.charAt(index);
            result2.append(ch);
            ++index;
        }
        return result2.toString();
    }

    @NotNull
    public static String shortenTemplateType(@NotNull String type) {
        return ValueRendererUtils.shortenTemplateType(type, 1);
    }

    @NotNull
    public static String shortenTemplateType(@NotNull String type, int templateTypeReduceLevel) {
        StringBuilder result2 = new StringBuilder();
        int count = 0;
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '<') {
                ++count;
            }
            if (count <= templateTypeReduceLevel) {
                int length = result2.length();
                if (c == '>' && length > 2 && result2.charAt(length - 1) == ' ' && result2.charAt(length - 2) != '>') {
                    result2.setLength(length - 1);
                }
                result2.append(c);
            }
            if (c != '>') continue;
            --count;
        }
        return count == 0 ? result2.toString() : type;
    }
}

