/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSEnumerableValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSEnumerableCollectionValueRenderer
extends NSEnumerableValueRenderer {
    private final NSCollectionValueRenderer.Kind myKind;
    private volatile LLValue myEnumerator;

    public NSEnumerableCollectionValueRenderer(@NotNull CidrPhysicalValue value, @NotNull NSCollectionValueRenderer.Kind kind) {
        super(value);
        this.myKind = kind;
    }

    @Override
    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        if (this.myValue.getVar().getType().matches("__NS.+0 \\*")) {
            return 0;
        }
        return (int)this.messageSendToSelfData("count", "unsigned int", context2).intValue();
    }

    @Override
    @Nullable
    protected CidrValue createChild(@NotNull EvaluationContext context2, int index) throws ExecutionException, DebuggerCommandException {
        CidrValue child;
        if (!context2.getData(this.myEnumerator).isValidPointer()) {
            return null;
        }
        LLValue next = context2.messageSend(this.myEnumerator, "nextObject");
        if (this.myKind == NSCollectionValueRenderer.Kind.DICTIONARY) {
            LLValueData nextData = context2.getData(next);
            LLValue object = this.messageSendToSelf("objectForKey:" + EvaluationContext.cast(nextData.getPointer(), "id"), "id", context2);
            child = this.createMapElementValue(next, object, index);
        } else {
            child = this.createElementValue(next, index);
        }
        return child;
    }

    @Override
    protected void willExpand(@NotNull EvaluationContext context2) throws ExecutionException, DebuggerCommandException {
        this.myEnumerator = this.myKind == NSCollectionValueRenderer.Kind.DICTIONARY ? context2.messageSend(this.myValue.getVar(), "keyEnumerator") : context2.messageSend(this.myValue.getVar(), "objectEnumerator");
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        return NSCollectionValueRenderer.getChildEvaluationExpression(this.myValue, this.myKind, child, lvalue);
    }
}

