/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.ColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.cidr.execution.debugger.CidrFrameTypeDecorator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxFrameTypeDecoratorKt;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameCache;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameRenderOptions;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameStdTypes;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CxxNameSugarizeOptions;
import java.awt.Font;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\u0006\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxFrameTypeDecorator;", "Lcom/jetbrains/cidr/execution/debugger/CidrFrameTypeDecorator;", "()V", "frameRenderOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "getFrameRenderOptions", "()Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameRenderOptions;", "sugarizeOptions", "Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "getSugarizeOptions", "()Lcom/jetbrains/cidr/execution/debugger/evaluation/renderers/CxxNameSugarizeOptions;", "typeIdRenderOptions", "getTypeIdRenderOptions", "adjustRenderOptions", "options", "renderForUiLabel", "", "getFrameFunctionColoredText", "Lcom/intellij/ui/ColoredText;", "frame", "Lcom/jetbrains/cidr/execution/debugger/CidrStackFrame;", "attributes", "Lcom/intellij/ui/SimpleTextAttributes;", "getValueDisplayType", "", "value", "Lcom/jetbrains/cidr/execution/debugger/evaluation/CidrPhysicalValue;", "intellij.cidr.debugger"})
public final class CxxFrameTypeDecorator
implements CidrFrameTypeDecorator {
    @NotNull
    public static final CxxFrameTypeDecorator INSTANCE;

    private final CxxNameSugarizeOptions getSugarizeOptions() {
        return new CxxNameSugarizeOptions(CxxFrameTypeDecoratorKt.access$getSettings$p().isSugarizeCxxStlTypes(), CxxFrameTypeDecoratorKt.access$getSettings$p().isSugarizeCxxStlTypes(), false, 4, null);
    }

    private final CxxNameRenderOptions getTypeIdRenderOptions() {
        Font font = null;
        boolean bl = false;
        CxxNameRenderOptions.RenderPolicy renderPolicy = CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy2 = !CxxFrameTypeDecoratorKt.access$getSettings$p().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy3 = !CxxFrameTypeDecoratorKt.access$getSettings$p().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy4 = !CxxFrameTypeDecoratorKt.access$getSettings$p().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        int n = 0;
        CxxNameRenderOptions.RenderPolicy renderPolicy5 = null;
        CxxNameRenderOptions.RenderPolicy renderPolicy6 = null;
        CxxNameRenderOptions.RenderPolicy renderPolicy7 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowTypeTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy8 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowTypeTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy9 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowTypeTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        return CxxNameRenderOptions.copy$default(CxxNameStdTypes.TYPE_ID_RENDER_OPTIONS, renderPolicy8, renderPolicy9, renderPolicy7, renderPolicy6, renderPolicy5, n, renderPolicy4, renderPolicy3, renderPolicy2, renderPolicy, bl, font, 3128, null);
    }

    private final CxxNameRenderOptions getFrameRenderOptions() {
        Font font = null;
        boolean bl = false;
        CxxNameRenderOptions.RenderPolicy renderPolicy = CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy2 = !CxxFrameTypeDecoratorKt.access$getSettings$p().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy3 = !CxxFrameTypeDecoratorKt.access$getSettings$p().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy4 = !CxxFrameTypeDecoratorKt.access$getSettings$p().isStripCxxAuxiliaryNamespaces() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        int n = 0;
        CxxNameRenderOptions.RenderPolicy renderPolicy5 = null;
        CxxNameRenderOptions.RenderPolicy renderPolicy6 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowFrameFunctionTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy7 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowFrameFunctionTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.FOLD;
        CxxNameRenderOptions.RenderPolicy renderPolicy8 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowFrameFunctionTemplateArguments() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        CxxNameRenderOptions.RenderPolicy renderPolicy9 = CxxFrameTypeDecoratorKt.access$getSettings$p().isShowFrameFunctionParameters() ? CxxNameRenderOptions.RenderPolicy.SHOW : CxxNameRenderOptions.RenderPolicy.HIDE;
        return new CxxNameRenderOptions(renderPolicy7, renderPolicy8, renderPolicy6, renderPolicy9, renderPolicy5, n, renderPolicy4, renderPolicy3, renderPolicy2, renderPolicy, bl, font, 3120, null);
    }

    @Override
    @NotNull
    public String getValueDisplayType(@NotNull CidrPhysicalValue value, boolean renderForUiLabel) {
        String string = CxxNameCache.Companion.getInstance().renderTypeIdString(value.getType(), this.getSugarizeOptions(), this.adjustRenderOptions(this.getTypeIdRenderOptions(), renderForUiLabel));
        if (string == null) {
            string = CidrFrameTypeDecorator.DefaultImpls.getValueDisplayType(this, value, renderForUiLabel);
        }
        return string;
    }

    @Override
    @NotNull
    public ColoredText getFrameFunctionColoredText(@NotNull CidrStackFrame frame, @NotNull SimpleTextAttributes attributes, boolean renderForUiLabel) {
        LLFrame llFrame = frame.getFrame();
        if (!llFrame.hasSymbolInfo()) {
            return CidrFrameTypeDecorator.DefaultImpls.getFrameFunctionColoredText(this, frame, attributes, renderForUiLabel);
        }
        ColoredText coloredText = CxxNameCache.Companion.getInstance().renderStackTraceColoredText(llFrame.getFunction(), this.getSugarizeOptions(), this.adjustRenderOptions(this.getFrameRenderOptions(), renderForUiLabel), attributes);
        if (coloredText == null) {
            coloredText = CidrFrameTypeDecorator.DefaultImpls.getFrameFunctionColoredText(this, frame, attributes, renderForUiLabel);
        }
        return coloredText;
    }

    private final CxxNameRenderOptions adjustRenderOptions(CxxNameRenderOptions options, boolean renderForUiLabel) {
        boolean alternativePunctuationEnabled = renderForUiLabel && Registry.is((String)"cidr.debugger.frameTypeDecorator.alternativePunctuation", (boolean)false);
        return CxxNameRenderOptions.copy$default(options, null, null, null, null, null, 0, null, null, null, null, !renderForUiLabel, alternativePunctuationEnabled ? StartupUiUtil.getLabelFont() : null, 1023, null);
    }

    private CxxFrameTypeDecorator() {
    }

    static {
        CxxFrameTypeDecorator cxxFrameTypeDecorator;
        INSTANCE = cxxFrameTypeDecorator = new CxxFrameTypeDecorator();
    }
}

