/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDictionaryEntryValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerValueRenderer
extends ValueRenderer {
    public ContainerValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return true;
    }

    @Override
    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context2, @NotNull XCompositeNode container, int startIndex, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        ArrayList<CidrValue> values = new ArrayList<CidrValue>(children.size());
        for (LLValue each : children) {
            if (container.isObsolete()) {
                return;
            }
            values.add(this.createElementValue(each, startIndex++, modifiable));
        }
        CidrValue.addAllTo(values, container);
    }

    @NotNull
    protected final CidrElementValue createElementValue(@NotNull LLValue var, int index) {
        return this.createElementValue(var, index, false);
    }

    @NotNull
    protected final CidrElementValue createElementValue(@NotNull LLValue var, int index, boolean modifiable) {
        return new CidrElementValue(var, "[" + index + "]", this.myValue, index, modifiable);
    }

    @NotNull
    protected final CidrDictionaryEntryValue createMapElementValue(@NotNull LLValue key, @NotNull LLValue value, int index) {
        return new CidrDictionaryEntryValue("[" + index + "]", this.myValue, key, value, index);
    }

    @NotNull
    public String getDictionaryEntryEvaluationExpression(@NotNull CidrDictionaryEntryValue entry, boolean lvalue) {
        return this.getChildEvaluationExpression(entry.getObject(), lvalue);
    }
}

