/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.codeInsight.daemon.impl.IdentifierHighlighterPass;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.DocumentUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XSourcePositionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelperBase;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.LocalVariablesFilterHandler;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class CidrDebuggerTypesHelper
implements CidrDebuggerTypesHelperBase {
    private static final Pattern OPTIONAL_PATTERN = Pattern.compile("Swift\\.(ImplicitlyUnwrapped)?Optional<(.*?)>");
    protected CidrDebugProcess myProcess;

    public CidrDebuggerTypesHelper(CidrDebugProcess process) {
        this.myProcess = process;
    }

    @Contract(value="null, _ -> null")
    public static PsiElement getContextElement(@Nullable XSourcePosition sourcePosition, @NotNull Project project) {
        if (sourcePosition == null) {
            return null;
        }
        Document document2 = FileDocumentManager.getInstance().getDocument(sourcePosition.getFile());
        if (document2 == null) {
            return null;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)project).getPsiFile(document2);
        if (psiFile == null) {
            return null;
        }
        return CidrDebuggerTypesHelper.findContextElement(sourcePosition, document2, psiFile);
    }

    @Nullable
    private static PsiElement findContextElement(XSourcePosition sourcePosition, Document document2, PsiFile psiFile) {
        PsiElement element;
        int positionOffset = sourcePosition.getOffset();
        if (!DocumentUtil.isValidOffset((int)positionOffset, (Document)document2)) {
            return null;
        }
        int lineEndOffset = document2.getLineEndOffset(document2.getLineNumber(positionOffset));
        int offset = positionOffset;
        while ((element = psiFile.findElementAt(offset)) != null) {
            if (!(element instanceof PsiWhiteSpace) && !(element instanceof PsiComment)) {
                return element;
            }
            offset = element.getTextRange().getEndOffset() + 1;
            if (offset < lineEndOffset) continue;
        }
        return psiFile.findElementAt(positionOffset);
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeSourcePositionAsync(@NotNull XSourcePosition position, @NotNull LLValue var, @NotNull ProgressIndicator indicator) {
        return CompletableFuture.supplyAsync(() -> (XSourcePosition)ReadAction.nonBlocking(() -> this.computeSourcePosition(position, var)).wrapProgress(indicator).executeSynchronously());
    }

    @Nullable
    public XSourcePosition computeSourcePosition(XSourcePosition position, LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(resolved.getContainingFile().getVirtualFile(), resolved.getTextOffset());
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeSourcePositionAsync(@NotNull CidrMemberValue value, @NotNull ProgressIndicator indicator) {
        return CompletableFuture.supplyAsync(() -> (XSourcePosition)ReadAction.nonBlocking(() -> this.computeSourcePosition(value)).wrapProgress(indicator).executeSynchronously());
    }

    @Nullable
    public XSourcePosition computeSourcePosition(@NotNull CidrMemberValue value) {
        return null;
    }

    @Override
    @NotNull
    public CompletableFuture<XSourcePosition> computeNearestUsageSourcePositionAsync(@NotNull XSourcePosition position, @NotNull LLValue var, @NotNull ProgressIndicator indicator) {
        return Promises.asCompletableFuture((Promise)ReadAction.nonBlocking(() -> this.computeNearestUsageSourcePosition(position, var)).wrapProgress(indicator).submit((Executor)AppExecutorUtil.getAppExecutorService()));
    }

    @Nullable
    private XSourcePosition computeNearestUsageSourcePosition(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement resolved = this.resolveToDeclaration(position, var);
        if (resolved == null) {
            return null;
        }
        PsiFile file = resolved.getContainingFile();
        if (file == null) {
            return null;
        }
        int positionLine = position.getLine();
        int bestLine = -1;
        XSourcePositionImpl bestPos = null;
        Collection usages = IdentifierHighlighterPass.getUsages((PsiElement)resolved, (PsiElement)file, (boolean)false);
        for (TextRange usage : usages) {
            int currLine;
            XSourcePositionImpl currPos = XSourcePositionImpl.createByOffset((VirtualFile)file.getVirtualFile(), (int)usage.getStartOffset());
            if (currPos == null || bestLine >= (currLine = currPos.getLine()) || currLine > positionLine) continue;
            bestLine = currLine;
            bestPos = currPos;
        }
        return bestPos;
    }

    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition position) {
        return CidrDebuggerTypesHelper.getContextElement(position, this.myProcess.getProject());
    }

    @Override
    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        return null;
    }

    @Override
    @NotNull
    public CompletableFuture<List<LLValue>> filterLocalVariables(@Nullable XSourcePosition position, @NotNull List<LLValue> vars, @NotNull Expirable expirable) {
        if (position == null) {
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        if (!CidrDebuggerSettings.getInstance().isValuesFilterEnabled()) {
            return CompletableFuture.completedFuture(vars);
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProcess.getProject());
        if (dumbService.isDumb()) {
            dumbService.runWhenSmart(() -> {
                if (!expirable.isExpired()) {
                    this.myProcess.getSession().rebuildViews();
                }
            });
            return CompletableFuture.completedFuture(Collections.emptyList());
        }
        Project project = this.myProcess.getProject();
        LocalVariablesFilterHandler explicitFilterHandler = LocalVariablesFilterHandler.findFilterHandler(project, position);
        if (explicitFilterHandler != null) {
            return explicitFilterHandler.filterVars(project, position, vars);
        }
        return CompletableFuture.completedFuture(ContainerUtil.filter(vars, value -> {
            boolean[] resolved = new boolean[1];
            boolean[] special = new boolean[]{false};
            Computable calcVariableLineRunnable = () -> {
                PsiElement declarator = this.resolveToDeclaration(position, (LLValue)((Object)value));
                boolean bl = resolved[0] = declarator != null;
                if (declarator == null) {
                    Boolean thisSelfSupper = this.isImplicitContextVariable(position, (LLValue)((Object)value));
                    special[0] = thisSelfSupper != null ? thisSelfSupper : false;
                    return null;
                }
                PsiFile targetFile = declarator.getContainingFile();
                if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)position.getFile())) {
                    return null;
                }
                int endOffset = declarator.getTextRange().getEndOffset();
                Document document2 = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
                if (document2 == null) {
                    return null;
                }
                return document2.getLineNumber(endOffset);
            };
            CidrDebuggerUtil.ReadActionResult variableLine = CidrDebuggerUtil.runInReadActionWithRetries(calcVariableLineRunnable, () -> project.isDisposed() || expirable.isExpired());
            value.setValid(special[0] || resolved[0] && variableLine.value != null && (Integer)variableLine.value < position.getLine());
            return !CidrDebuggerSettings.getInstance().isValuesFilterEnabled() || resolved[0] || special[0];
        }));
    }

    @Nullable
    public PsiElement resolveToDeclaration(@Nullable XSourcePosition position, @NotNull LLValue var) {
        PsiElement context2 = this.getContextElement(position);
        if (context2 == null) {
            return null;
        }
        PsiReference ref = this.createReferenceFromText(var, context2);
        if (ref == null) {
            return null;
        }
        try {
            PsiElement resolved = ref.resolve();
            if (resolved == null) {
                return null;
            }
            if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
                return null;
            }
            return resolved;
        }
        catch (IndexNotReadyException ignored) {
            return null;
        }
    }

    @Nullable
    protected PsiReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context2) {
        return null;
    }

    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        return null;
    }

    @Nullable
    public static String unwrapSwiftOptionalType(@NotNull String typeName) {
        Matcher m = OPTIONAL_PATTERN.matcher(typeName);
        return m.matches() ? m.group(2) : null;
    }

    @NotNull
    public static String unwrapSwiftOptionalTypeIfNecessary(@NotNull String typeName) {
        return StringUtil.notNullize((String)CidrDebuggerTypesHelper.unwrapSwiftOptionalType(typeName), (String)typeName);
    }
}

