/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PlatformUtils;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrExceptionBreakpointPropertiesPanel;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrExceptionBreakpointType
extends XBreakpointType<XBreakpoint<Properties>, Properties> {
    public CidrExceptionBreakpointType() {
        this(CidrDebuggerBundle.message("debug.exception.breakpoints", new Object[0]));
    }

    protected CidrExceptionBreakpointType(@Nls String title) {
        super("CidrExceptionBreakpoint", title);
    }

    public String getDisplayText(XBreakpoint<Properties> breakpoint) {
        Properties properties = (Properties)breakpoint.getProperties();
        if (properties == null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.invalid", new Object[0]);
        }
        Properties.Type thrown = properties.getWhenThrown();
        Properties.Type caught = properties.getWhenCaught();
        if (thrown != null && caught != null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.when.summary.thrownAndCaught.label", thrown.getSummaryFragment(), caught.getSummaryFragment());
        }
        if (thrown != null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.when.summary.thrown.label", thrown.getSummaryFragment());
        }
        if (caught != null) {
            return CidrDebuggerBundle.message("debug.exception.breakpoint.when.summary.caught.label", caught.getSummaryFragment());
        }
        return CidrDebuggerBundle.message("debug.exception.breakpoint", new Object[0]);
    }

    @NotNull
    public Icon getEnabledIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return AllIcons.Debugger.Db_disabled_exception_breakpoint;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    public Properties createProperties() {
        return new Properties();
    }

    public XBreakpoint<Properties> createDefaultBreakpoint(@NotNull XBreakpointType.XBreakpointCreator<Properties> creator) {
        XBreakpoint breakpoint = creator.createBreakpoint((XBreakpointProperties)this.createProperties());
        breakpoint.setEnabled(false);
        return breakpoint;
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<Properties>> createCustomPropertiesPanel(@NotNull Project project) {
        return new CidrExceptionBreakpointPropertiesPanel();
    }

    public XBreakpoint<Properties> addBreakpoint(Project project, JComponent parentComponent) {
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)project).getBreakpointManager().addBreakpoint((XBreakpointType)this, (XBreakpointProperties)new Properties()));
    }

    public boolean isAddBreakpointButtonVisible() {
        return true;
    }

    public static class Properties
    extends XBreakpointProperties<Properties> {
        @Attribute(value="thrown")
        @Nullable
        private Type myWhenThrown;
        @Attribute(value="caught")
        @Nullable
        private Type myWhenCaught;

        public Properties() {
            this(Type.ANY_EXCEPTION, null);
        }

        public Properties(@Nullable Type whenThrown, @Nullable Type whenCaught) {
            this.myWhenThrown = whenThrown;
            this.myWhenCaught = whenCaught;
        }

        @Nullable
        public Type getWhenThrown() {
            return this.myWhenThrown;
        }

        public void setWhenThrown(@Nullable Type whenThrown) {
            this.myWhenThrown = whenThrown;
        }

        public boolean updateWhenThrown(@Nullable Type whenThrown) {
            if (this.myWhenThrown == whenThrown) {
                return false;
            }
            this.setWhenThrown(whenThrown);
            return true;
        }

        @Nullable
        public Type getWhenCaught() {
            return this.myWhenCaught;
        }

        public void setWhenCaught(@Nullable Type stopOnCaught) {
            this.myWhenCaught = stopOnCaught;
        }

        public boolean updateWhenCaught(@Nullable Type stopOnCaught) {
            if (this.myWhenCaught == stopOnCaught) {
                return false;
            }
            this.setWhenCaught(stopOnCaught);
            return true;
        }

        @NotNull
        public Properties getState() {
            return this;
        }

        public void loadState(@NotNull Properties state) {
            this.myWhenThrown = state.myWhenThrown;
            this.myWhenCaught = state.myWhenCaught;
        }

        public static enum Type {
            ANY_EXCEPTION(CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.any.label", new Object[0]), CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.any.fragment", new Object[0])),
            OBJC_EXCEPTION((Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.objc.label", new Object[0]), (Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.objc.fragment", new Object[0])){

                @Override
                public boolean isAvailable() {
                    return SystemInfo.isMac;
                }
            }
            ,
            SWIFT_EXCEPTION((Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.swift.label", new Object[0]), (Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.swift.fragment", new Object[0])){

                @Override
                public boolean isAvailable() {
                    boolean swiftInstalled = PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)"com.intellij.clion-swift"));
                    return PlatformUtils.isCLion() && swiftInstalled || SystemInfo.isMac && (PlatformUtils.isAppCode() || PlatformUtils.isMobileIde());
                }
            }
            ,
            KN_EXCEPTION((Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.kn.label", new Object[0]), (Supplier)CidrDebuggerBundle.messagePointer("debug.exception.breakpoint.when.kn.fragment", new Object[0])){

                @Override
                public boolean isAvailable() {
                    boolean kotlinInstalled = PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)"org.jetbrains.kotlin"));
                    boolean kmmACInstalled = PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)"com.intellij.appcode.kmm"));
                    boolean kmmASInstalled = PluginManagerCore.isPluginInstalled((PluginId)PluginId.getId((String)"com.jetbrains.kmm"));
                    return PlatformUtils.isIdeaUltimate() && kotlinInstalled || SystemInfo.isMac && (PlatformUtils.isMobileIde() || kmmACInstalled || kmmASInstalled);
                }
            };

            @NotNull
            private final @NotNull Supplier<@NlsContexts.RadioButton @NotNull String> myLabelSupplier;
            @NotNull
            private final @NotNull Supplier<@Nls @NotNull String> mySummaryFragmentSupplier;

            private Type(Supplier<String> labelSupplier, Supplier<String> summaryFragmentSupplier) {
                this.myLabelSupplier = labelSupplier;
                this.mySummaryFragmentSupplier = summaryFragmentSupplier;
            }

            @NlsContexts.ListItem
            @NotNull
            public String getLabel() {
                return this.myLabelSupplier.get();
            }

            @Nls
            @NotNull
            public String getSummaryFragment() {
                return this.mySummaryFragmentSupplier.get();
            }

            public boolean isAvailable() {
                return true;
            }
        }
    }
}

