/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.util.containers.FactoryMap;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrCodePointHandlerBase<T extends XBreakpoint<?>, C extends LLCodepoint>
extends XBreakpointHandler<T> {
    protected final CidrDebugProcess myProcess;
    private final Map<Integer, C> myIdToCodepoint = new HashMap<Integer, C>();
    private final Map<T, List<Integer>> myBreakpoints = FactoryMap.create(key -> new ArrayList());
    private final Map<Integer, T> myIdToBreakpoint = new HashMap<Integer, T>();

    public CidrCodePointHandlerBase(CidrDebugProcess process, @NotNull Class<? extends XBreakpointType<T, ?>> type) {
        super(type);
        this.myProcess = process;
    }

    public void registerBreakpoint(@NotNull T breakpoint) {
        long threadId = this.myProcess.getCurrentThreadId();
        int frameIndex = this.myProcess.getCurrentFrameIndex();
        this.myProcess.postCommand(driver -> this.doRegisterBreakpoint(driver, breakpoint, threadId, frameIndex));
    }

    public void unregisterBreakpoint(@NotNull T breakpoint, boolean temporary) {
        this.myProcess.postCommand(driver -> this.doUnregisterBreakpoint(driver, breakpoint));
    }

    protected void doRegisterBreakpoint(@NotNull DebuggerDriver driver, @NotNull T breakpoint, long threadId, int frameIndex) throws ExecutionException {
        Collection<C> added = this.addCodepointsInBackend(driver, breakpoint, threadId, frameIndex);
        if (added.isEmpty()) {
            return;
        }
        this.registerCodepointsMapping(breakpoint, added);
    }

    protected void doUnregisterBreakpoint(@NotNull DebuggerDriver driver, @NotNull T breakpoint) throws ExecutionException {
        List<Integer> idsToRemove = this.unregisterCodepointsMapping(breakpoint);
        if (idsToRemove.isEmpty()) {
            return;
        }
        try {
            this.removeCodepointsInBackend(driver, idsToRemove, breakpoint);
        }
        catch (DebuggerCommandException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerCodepointsMapping(@NotNull T breakpoint, @NotNull Collection<C> added) {
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            List<Integer> breakpointIds = this.myBreakpoints.get(breakpoint);
            for (LLCodepoint each : added) {
                this.myIdToCodepoint.put(each.getId(), each);
                breakpointIds.add(each.getId());
                this.myIdToBreakpoint.put(each.getId(), breakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Integer> unregisterCodepointsMapping(@NotNull T breakpoint) {
        List<Integer> idsToRemove;
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            idsToRemove = this.myBreakpoints.remove(breakpoint);
            if (idsToRemove == null) {
                return Collections.emptyList();
            }
            for (Integer each : idsToRemove) {
                this.myIdToCodepoint.remove(each);
                this.myIdToBreakpoint.remove(each);
            }
        }
        return Collections.unmodifiableList(idsToRemove);
    }

    protected abstract Collection<C> addCodepointsInBackend(@NotNull DebuggerDriver var1, @NotNull T var2, long var3, int var5) throws ExecutionException;

    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull T breakpoint) throws ExecutionException, DebuggerCommandException {
        driver.removeCodepoints(ids);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public T getXBreakpoint(int id) {
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            return (T)((XBreakpoint)this.myIdToBreakpoint.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public C getCodepoint(int id) {
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            return (C)((LLCodepoint)this.myIdToCodepoint.get(id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCodepoint(int id, @NotNull C codepoint) {
        Map<T, List<Integer>> map = this.myBreakpoints;
        synchronized (map) {
            this.myIdToCodepoint.replace(id, codepoint);
        }
    }

    @Nullable
    protected String convertCondition(@NotNull XBreakpoint<? extends XBreakpointProperties> breakpoint) {
        String conversion;
        if (breakpoint.getCondition() != null && (conversion = (String)WriteAction.computeAndWait(() -> {
            try {
                return CidrEvaluatorHelper.getInstance().convertExpression(this.myProcess, breakpoint.getCondition(), breakpoint.getSourcePosition());
            }
            catch (CidrEvaluatorHelper.ConversionException e) {
                if (breakpoint instanceof XLineBreakpoint) {
                    this.myProcess.getSession().setBreakpointInvalid((XLineBreakpoint)breakpoint, e.getMessage());
                }
                return null;
            }
        })) != null) {
            return conversion;
        }
        return breakpoint.getCondition();
    }
}

