/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpointLocation;
import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrAddressBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrCleanableBreakpointHandlerBase;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\u0018\u00002\u0018\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002\u0012\u0004\u0012\u00020\u00040\u0001B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J8\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\nH\u0014J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0011\u001a\u00020\u0004J\u001c\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u000b0\u001aJ\u001c\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001aJ\u001c\u0010\u001d\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\n2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\f0\u001aJ\u000e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\nJ\u0016\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010 \u001a\u00020\u0004J\u001a\u0010!\u001a\u00020\"2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0002J0\u0010#\u001a\u00020\u00162\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010$\u001a\b\u0012\u0004\u0012\u00020\n0\u001a2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0014J\u001a\u0010%\u001a\u00020\"2\u0010\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0002H\u0014J\"\u0010&\u001a\u00020\u00162\u0010\u0010'\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u00022\u0006\u0010(\u001a\u00020\"H\u0002R&\u0010\b\u001a\u001a\u0012\u0004\u0012\u00020\n\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrAddressBreakpointHandler;", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrCleanableBreakpointHandlerBase;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpoint;", "Lcom/intellij/xdebugger/breakpoints/XBreakpointProperties;", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpoint;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "myLocationsMap", "", "", "", "Lcom/jetbrains/cidr/execution/debugger/backend/LLBreakpointLocation;", "addCodepointsInBackend", "", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "breakpoint", "threadId", "", "frameIndex", "handleBreakpointAdded", "", "handleBreakpointLocationsRemoved", "breakpointId", "locationIds", "", "handleBreakpointLocationsReplaced", "locations", "handleBreakpointLocationsUpdated", "handleBreakpointRemoved", "handleBreakpointUpdated", "newBreakpoint", "isOurBreakpoint", "", "removeCodepointsInBackend", "ids", "shouldBreakpointBeRemoved", "updateBreakpointPresentation", "uiBreakpoint", "resolved", "intellij.cidr.debugger"})
public final class CidrAddressBreakpointHandler
extends CidrCleanableBreakpointHandlerBase<XLineBreakpoint<XBreakpointProperties<?>>, LLBreakpoint> {
    private final Map<Integer, Map<String, LLBreakpointLocation>> myLocationsMap = new LinkedHashMap();

    @Override
    protected boolean shouldBreakpointBeRemoved(@NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        return this.isOurBreakpoint(breakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @NotNull
    protected Collection<LLBreakpoint> addCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint, long threadId, int frameIndex) throws ExecutionException {
        if (!this.isOurBreakpoint(breakpoint)) {
            return CollectionsKt.emptyList();
        }
        Address address = CidrAddressBreakpointType.Companion.breakpointToAddress(breakpoint);
        if (address == null) {
            return CollectionsKt.emptyList();
        }
        Address address2 = address;
        try {
            void $this$associateByTo$iv$iv;
            DebuggerDriver.AddBreakpointResult result2 = driver.addAddressBreakpoint(address2, this.convertCondition((XBreakpoint<XBreakpointProperties>)((XBreakpoint)breakpoint)));
            LLBreakpoint brk = result2.getBreakpoint();
            List<LLBreakpointLocation> brkLocations = result2.getBreakpointLocations();
            Iterable $this$associateBy$iv = brkLocations;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                LLBreakpointLocation lLBreakpointLocation = (LLBreakpointLocation)element$iv$iv;
                Map map = destination$iv$iv;
                boolean bl = false;
                String string = it.getId();
                map.put(string, element$iv$iv);
            }
            Map brkLocationsMap = MapsKt.toMutableMap((Map)destination$iv$iv);
            Object object = this.myLocationsMap;
            Map<Integer, Map<String, LLBreakpointLocation>> map = object;
            synchronized (map) {
                boolean bl = false;
                this.myLocationsMap.put(brk.getId(), brkLocationsMap);
                Unit unit = Unit.INSTANCE;
            }
            object = brkLocations;
            this.updateBreakpointPresentation(breakpoint, !object.isEmpty());
            return CollectionsKt.listOf((Object)result2.getBreakpoint());
        }
        catch (DebuggerCommandException e) {
            this.myProcess.getSession().setBreakpointInvalid(breakpoint, e.getMessage());
            return CollectionsKt.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void removeCodepointsInBackend(@NotNull DebuggerDriver driver, @NotNull List<Integer> ids, @NotNull XLineBreakpoint<XBreakpointProperties<?>> breakpoint) throws ExecutionException, DebuggerCommandException {
        try {
            super.removeCodepointsInBackend(driver, ids, (XBreakpoint)breakpoint);
        }
        finally {
            Map<Integer, Map<String, LLBreakpointLocation>> map;
            Map<Integer, Map<String, LLBreakpointLocation>> map2 = map = this.myLocationsMap;
            synchronized (map2) {
                boolean bl = false;
                Iterator<Integer> iterator2 = ids.iterator();
                while (iterator2.hasNext()) {
                    int id = ((Number)iterator2.next()).intValue();
                    this.myLocationsMap.remove(id);
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    public final void handleBreakpointAdded(@NotNull LLBreakpoint breakpoint) {
    }

    public final void handleBreakpointRemoved(int breakpointId) {
    }

    public final void handleBreakpointUpdated(int breakpointId, @NotNull LLBreakpoint newBreakpoint) {
        this.updateCodepoint(breakpointId, (LLCodepoint)newBreakpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void handleBreakpointLocationsReplaced(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean bl;
        Map<Integer, Map<String, LLBreakpointLocation>> map;
        Map<Integer, Map<String, LLBreakpointLocation>> map2 = map = this.myLocationsMap;
        synchronized (map2) {
            void $this$associateByTo$iv$iv;
            boolean bl2 = false;
            if (this.myLocationsMap.get(breakpointId) == null) {
                return;
            }
            Iterable $this$associateBy$iv = locations;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Iterable iterable = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                LLBreakpointLocation lLBreakpointLocation = (LLBreakpointLocation)element$iv$iv;
                Map map3 = destination$iv$iv;
                boolean bl3 = false;
                String string = it.getId();
                map3.put(string, element$iv$iv);
            }
            Map locationsMap = MapsKt.toMutableMap((Map)destination$iv$iv);
            this.myLocationsMap.put(breakpointId, locationsMap);
            Map map4 = locationsMap;
            bl = !map4.isEmpty();
        }
        boolean resolved = bl;
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (xLineBreakpoint == null) {
            return;
        }
        XLineBreakpoint uiBreakpoint = xLineBreakpoint;
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleBreakpointLocationsUpdated(int breakpointId, @NotNull List<LLBreakpointLocation> locations) {
        boolean bl;
        Map<Integer, Map<String, LLBreakpointLocation>> map;
        Map<Integer, Map<String, LLBreakpointLocation>> map2 = map = this.myLocationsMap;
        synchronized (map2) {
            boolean bl2 = false;
            Map<String, LLBreakpointLocation> map3 = this.myLocationsMap.get(breakpointId);
            if (map3 == null) {
                return;
            }
            Map<String, LLBreakpointLocation> locationsMap = map3;
            for (LLBreakpointLocation location : locations) {
                locationsMap.put(location.getId(), location);
            }
            Map<String, LLBreakpointLocation> map4 = locationsMap;
            bl = !map4.isEmpty();
        }
        boolean resolved = bl;
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (xLineBreakpoint == null) {
            return;
        }
        XLineBreakpoint uiBreakpoint = xLineBreakpoint;
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleBreakpointLocationsRemoved(int breakpointId, @NotNull List<String> locationIds) {
        boolean bl;
        Map<Integer, Map<String, LLBreakpointLocation>> map;
        Map<Integer, Map<String, LLBreakpointLocation>> map2 = map = this.myLocationsMap;
        synchronized (map2) {
            boolean bl2 = false;
            Map<String, LLBreakpointLocation> map3 = this.myLocationsMap.get(breakpointId);
            if (map3 == null) {
                return;
            }
            Map<String, LLBreakpointLocation> locationsMap = map3;
            for (String id : locationIds) {
                locationsMap.remove(id);
            }
            Map<String, LLBreakpointLocation> map4 = locationsMap;
            bl = !map4.isEmpty();
        }
        boolean resolved = bl;
        XLineBreakpoint xLineBreakpoint = (XLineBreakpoint)this.getXBreakpoint(breakpointId);
        if (xLineBreakpoint == null) {
            return;
        }
        XLineBreakpoint uiBreakpoint = xLineBreakpoint;
        this.updateBreakpointPresentation(uiBreakpoint, resolved);
    }

    private final void updateBreakpointPresentation(XLineBreakpoint<XBreakpointProperties<?>> uiBreakpoint, boolean resolved) {
        if (resolved) {
            this.myProcess.getSession().setBreakpointVerified(uiBreakpoint);
        } else {
            this.myProcess.getSession().setBreakpointInvalid(uiBreakpoint, CidrDebuggerBundle.message("debug.breakpoint.line.unresolved.hint", new Object[0]));
        }
    }

    private final boolean isOurBreakpoint(XLineBreakpoint<XBreakpointProperties<?>> breakpoint) {
        XSourcePosition xSourcePosition = breakpoint.getSourcePosition();
        if (xSourcePosition == null) {
            return false;
        }
        XSourcePosition pos = xSourcePosition;
        return this.myProcess.fileToMemoryDoc(pos.getFile()) != null;
    }

    public CidrAddressBreakpointHandler(@NotNull CidrDebugProcess process) {
        super(process, CidrAddressBreakpointType.class);
    }
}

