/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb.formatters;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisDiagnosticsLevel;
import com.jetbrains.cidr.execution.debugger.backend.lldb.formatters.LLDBNatvisSupport;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisFileProvider;
import com.jetbrains.cidr.execution.debugger.formatters.natvis.NatvisSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00072\u00020\u0001:\u0002\u0007\bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "Companion", "HexBackendStateManager", "intellij.cidr.debugger"})
public final class LLDBNatvisSupport
implements CidrDebugProcessConfigurator {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        DebuggerDriverConfiguration debuggerDriverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        if (!(debuggerDriverConfiguration instanceof LLDBDriverConfiguration)) {
            debuggerDriverConfiguration = null;
        }
        LLDBDriverConfiguration lLDBDriverConfiguration = (LLDBDriverConfiguration)debuggerDriverConfiguration;
        if (lLDBDriverConfiguration == null) {
            return;
        }
        LLDBDriverConfiguration driverConfiguration = lLDBDriverConfiguration;
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        if (!settings.isLLDBNatvisRenderersEnabled()) {
            return;
        }
        process.putUserData(CidrPhysicalValue.DO_NOT_SHOW_ADDRESSES, true);
        process.putUserData(CidrPhysicalValue.THREAT_VALUE_AS_RICH_TEXT, true);
        LLDBNatvisDiagnosticsLevel diagnosticsLevel = settings.getLLDBNatvisDiagnosticsLevel();
        process.postCommand(new CidrDebugProcess.VoidDebuggerCommand(diagnosticsLevel){
            final /* synthetic */ LLDBNatvisDiagnosticsLevel $diagnosticsLevel;

            public final void run(@NotNull DebuggerDriver driver) {
                LLDBNatvisSupport.Companion.initializeNatvis(driver, this.$diagnosticsLevel);
            }
            {
                this.$diagnosticsLevel = lLDBNatvisDiagnosticsLevel;
            }
        });
        HexBackendStateManager hexStateManager = new HexBackendStateManager(process, settings);
        process.getSession().addSessionListener((XDebugSessionListener)hexStateManager, process.getProcessDisposable());
        process.setHexChangedHandler(hexStateManager);
        boolean globalHexEnabled = settings.isHexFormattingEnabled();
        boolean globalHexShowBoth = settings.isHexAsSecondaryFormattingEnabled();
        hexStateManager.sendSetRequest(globalHexEnabled, globalHexShowBoth);
        List natvisFilesList = new ArrayList();
        Companion.collectNatvisFilesListFromSettings(process.getProject(), natvisFilesList);
        for (NatvisFileProvider provider : (NatvisFileProvider[])NatvisFileProvider.Companion.getEP_NAME().getExtensions()) {
            provider.populate(process, natvisFilesList);
        }
        process.postCommand(new CidrDebugProcess.VoidDebuggerCommand(natvisFilesList){
            final /* synthetic */ List $natvisFilesList;

            public final void run(@NotNull DebuggerDriver driver) {
                LLDBNatvisSupport.Companion.loadNatvisFiles(driver, this.$natvisFilesList);
            }
            {
                this.$natvisFilesList = list;
            }
        });
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\tJ\b\u0010\u0010\u001a\u00020\fH\u0016J\b\u0010\u0011\u001a\u00020\fH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport$HexBackendStateManager;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess$HexChangedHandler;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "settings", "Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;Lcom/jetbrains/cidr/execution/debugger/CidrDebuggerSettings;)V", "lastAppliedValueHex", "", "lastAppliedValueHexSecondary", "handleHexChanged", "", "sendSetRequest", "hexEnabled", "hexShowBoth", "sessionPaused", "synchronizeState", "intellij.cidr.debugger"})
    private static final class HexBackendStateManager
    implements CidrDebugProcess.HexChangedHandler,
    XDebugSessionListener {
        private volatile boolean lastAppliedValueHex;
        private volatile boolean lastAppliedValueHexSecondary;
        private final CidrDebugProcess process;
        private final CidrDebuggerSettings settings;

        @Override
        public void handleHexChanged() {
            this.synchronizeState();
        }

        public void sessionPaused() {
            this.synchronizeState();
        }

        private final void synchronizeState() {
            boolean lastAppliedHex = this.lastAppliedValueHex;
            boolean lastAppliedHexSecondary = this.lastAppliedValueHexSecondary;
            boolean globalHexEnabled = this.settings.isHexFormattingEnabled();
            boolean globalHexShowBoth = this.settings.isHexAsSecondaryFormattingEnabled();
            if (lastAppliedHex != globalHexEnabled || lastAppliedHexSecondary != globalHexShowBoth) {
                this.sendSetRequest(globalHexEnabled, globalHexShowBoth);
            }
        }

        public final void sendSetRequest(boolean hexEnabled, boolean hexShowBoth) {
            this.process.postCommand(new CidrDebugProcess.DebuggerUIUpdateCommand(hexEnabled, hexShowBoth){
                final /* synthetic */ boolean $hexEnabled;
                final /* synthetic */ boolean $hexShowBoth;

                public final void run(@NotNull DebuggerDriver driver) {
                    LLDBNatvisSupport.Companion.setGlobalHex(driver, this.$hexEnabled, this.$hexShowBoth);
                }
                {
                    this.$hexEnabled = bl;
                    this.$hexShowBoth = bl2;
                }
            }).thenAccept(new Consumer(this, hexEnabled, hexShowBoth){
                final /* synthetic */ HexBackendStateManager this$0;
                final /* synthetic */ boolean $hexEnabled;
                final /* synthetic */ boolean $hexShowBoth;

                public final void accept(Void it) {
                    HexBackendStateManager.access$setLastAppliedValueHex$p(this.this$0, this.$hexEnabled);
                    HexBackendStateManager.access$setLastAppliedValueHexSecondary$p(this.this$0, this.$hexShowBoth);
                    ApplicationManager.getApplication().invokeLater(new Runnable(this){
                        final /* synthetic */ sendSetRequest.2 this$0;

                        public final void run() {
                            HexBackendStateManager.access$getProcess$p(this.this$0.this$0).getSession().rebuildViews();
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.this$0 = hexBackendStateManager;
                    this.$hexEnabled = bl;
                    this.$hexShowBoth = bl2;
                }
            });
        }

        public HexBackendStateManager(@NotNull CidrDebugProcess process, @NotNull CidrDebuggerSettings settings) {
            this.process = process;
            this.settings = settings;
        }

        public static final /* synthetic */ boolean access$getLastAppliedValueHex$p(HexBackendStateManager $this) {
            return $this.lastAppliedValueHex;
        }

        public static final /* synthetic */ void access$setLastAppliedValueHex$p(HexBackendStateManager $this, boolean bl) {
            $this.lastAppliedValueHex = bl;
        }

        public static final /* synthetic */ boolean access$getLastAppliedValueHexSecondary$p(HexBackendStateManager $this) {
            return $this.lastAppliedValueHexSecondary;
        }

        public static final /* synthetic */ void access$setLastAppliedValueHexSecondary$p(HexBackendStateManager $this, boolean bl) {
            $this.lastAppliedValueHexSecondary = bl;
        }

        public static final /* synthetic */ CidrDebugProcess access$getProcess$p(HexBackendStateManager $this) {
            return $this.process;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bJ\u0016\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011J\u001e\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisSupport$Companion;", "", "()V", "collectNatvisFilesListFromSettings", "", "project", "Lcom/intellij/openapi/project/Project;", "fileList", "", "", "initializeNatvis", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver;", "diagnosticsLevel", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/formatters/LLDBNatvisDiagnosticsLevel;", "loadNatvisFiles", "natvisFilesList", "", "setGlobalHex", "hexEnabled", "", "hexShowBoth", "intellij.cidr.debugger"})
    public static final class Companion {
        public final void initializeNatvis(@NotNull DebuggerDriver driver, @NotNull LLDBNatvisDiagnosticsLevel diagnosticsLevel) {
            driver.executeInterpreterCommand(-1L, -1, "command script import renderers.jb_lldb_logging_manager");
            driver.executeInterpreterCommand(-1L, -1, "jb_renderers_set_diagnostics_level " + diagnosticsLevel.getLevel());
            driver.executeInterpreterCommand(-1L, -1, "command script import renderers.jb_lldb_declarative_formatters");
            driver.executeInterpreterCommand(-1L, -1, "jb_renderers_loaders_add natvis renderers.jb_lldb_natvis_loader natvis_loader");
        }

        public final void setGlobalHex(@NotNull DebuggerDriver driver, boolean hexEnabled, boolean hexShowBoth) {
            int globalHexEnabled = hexEnabled ? 1 : 0;
            int globalHexShowBoth = hexShowBoth ? 1 : 0;
            driver.executeInterpreterCommand(-1L, -1, "jb_renderers_set_global_hex " + globalHexEnabled + " " + globalHexShowBoth);
            driver.executeInterpreterCommand(-1L, -1, "script");
        }

        public final void loadNatvisFiles(@NotNull DebuggerDriver driver, @NotNull List<String> natvisFilesList) {
            if (natvisFilesList.isEmpty()) {
                return;
            }
            Iterable $this$forEach$iv = natvisFilesList;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String path = (String)element$iv;
                boolean bl = false;
                driver.executeInterpreterCommand(-1L, -1, "jb_renderers_load natvis \"" + path + "\"");
            }
        }

        /*
         * WARNING - void declaration
         */
        public final void collectNatvisFilesListFromSettings(@NotNull Project project, @NotNull List<String> fileList) {
            NatvisSettings settings = NatvisSettings.Companion.getInstance(project);
            for (Pair<File, Boolean> pair : settings.searchPaths) {
                Collection<String> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                void path;
                File file = (File)pair.component1();
                boolean enabled = (Boolean)pair.component2();
                if (!enabled) continue;
                Iterable iterable = NatvisFileProvider.Companion.listNatvisFilesInDirectory((File)path);
                List<String> list = fileList;
                boolean $i$f$map = false;
                void var10_10 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    File file2 = (File)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    String string = it.getAbsolutePath();
                    collection.add(string);
                }
                collection = (List)destination$iv$iv;
                list.addAll(collection);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

