/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lang;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.extapi.psi.PsiFileBase;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.ParserDefinition;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public abstract class DBParserDefinition
implements ParserDefinition {
    @NotNull
    protected abstract Language getLanguage();

    protected abstract LanguageFileType getFileType();

    @NotNull
    public TokenSet getWhitespaceTokens() {
        return TokenSet.create((IElementType[])new IElementType[]{GDBTokenType.WHITE_SPACE});
    }

    @NotNull
    public TokenSet getCommentTokens() {
        return TokenSet.EMPTY;
    }

    @NotNull
    public TokenSet getStringLiteralElements() {
        return TokenSet.create((IElementType[])new IElementType[]{GDBTokenType.QUOTED_STRING});
    }

    @NotNull
    public PsiElement createElement(ASTNode node) {
        if (node.getElementType() == GDBTokenType.EXPRESSION_PLACEHOLDER) {
            return new GDBExpressionPlaceholder(node);
        }
        return new ASTWrapperPsiElement(node);
    }

    @NotNull
    public PsiFile createFile(@NotNull FileViewProvider viewProvider) {
        final LanguageFileType type = this.getFileType();
        return new PsiFileBase(viewProvider, type.getLanguage()){

            @NotNull
            public FileType getFileType() {
                return type;
            }
        };
    }

    @NotNull
    public ParserDefinition.SpaceRequirements spaceExistenceTypeBetweenTokens(ASTNode left, ASTNode right) {
        return ParserDefinition.SpaceRequirements.MAY;
    }
}

