/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb.lang;

import com.intellij.lang.ASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.PsiParser;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBTokenType;
import org.jetbrains.annotations.NotNull;

public class GDBParser
implements PsiParser {
    private static final String[] GDB_EXPRESSION_COMMANDS = new String[]{"print", "p", "print-object", "po", "call"};

    @NotNull
    public ASTNode parse(@NotNull IElementType root, PsiBuilder builder) {
        PsiBuilder.Marker mark = builder.mark();
        GDBParser.parseGDBCommand(builder);
        mark.done(root);
        return builder.getTreeBuilt();
    }

    private static void parseGDBCommand(PsiBuilder builder) {
        PsiBuilder.Marker command = builder.mark();
        if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
            String commandName = builder.getTokenText();
            PsiBuilder.Marker commandNameMarker = builder.mark();
            builder.advanceLexer();
            commandNameMarker.done((IElementType)GDBTokenType.COMMAND_NAME);
            if (GDBParser.isExpressionCommand(commandName)) {
                GDBParser.parseExpression(builder);
            } else {
                GDBParser.parseCommandArguments(builder);
            }
        } else {
            GDBParser.eatEverything(builder);
        }
        command.done((IElementType)GDBTokenType.DBG_COMMAND);
    }

    private static boolean isExpressionCommand(String commandName) {
        return ArrayUtil.contains((String)commandName, (String[])GDB_EXPRESSION_COMMANDS);
    }

    private static void eatEverything(PsiBuilder builder) {
        while (!builder.eof()) {
            builder.advanceLexer();
        }
    }

    private static void parseExpression(PsiBuilder builder) {
        PsiBuilder.Marker body = builder.mark();
        GDBParser.eatEverything(builder);
        body.done((IElementType)GDBTokenType.EXPRESSION_PLACEHOLDER);
    }

    private static void parseCommandArguments(PsiBuilder builder) {
        PsiBuilder.Marker body = builder.mark();
        while (!builder.eof()) {
            if (builder.getTokenType() == GDBTokenType.IDENTIFIER) {
                PsiBuilder.Marker subCommand = builder.mark();
                builder.advanceLexer();
                subCommand.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
                continue;
            }
            if (builder.getTokenType() == GDBTokenType.DASH && builder.rawLookup(1) == GDBTokenType.IDENTIFIER) {
                PsiBuilder.Marker option = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                option.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
                continue;
            }
            if (builder.getTokenType() == GDBTokenType.DASHDASH) {
                PsiBuilder.Marker dashDash = builder.mark();
                builder.advanceLexer();
                dashDash.done((IElementType)GDBTokenType.COMMAND_ARGS_END);
                GDBParser.eatEverything(builder);
                continue;
            }
            builder.advanceLexer();
        }
        body.done((IElementType)GDBTokenType.COMMAND_ARGUMENTS);
    }
}

