/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbLexer;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.dfa.DFA;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GDBResponse {
    public static GDBResponse parse(String s) throws ResponseParseException {
        return new Parser(s).parse();
    }

    private static String formatRecord(RecordCategory kind, RecordType name, GDBTuple resultList) {
        StringBuilder buffer = new StringBuilder(kind.toString());
        buffer.append(name);
        if (!resultList.isEmpty()) {
            buffer.append(",");
            GDBResponse.doFormat(buffer, resultList, false);
        }
        return buffer.toString();
    }

    private static void doFormat(StringBuilder buffer, Object obj, boolean closed) {
        if (obj instanceof Pair) {
            buffer.append(((Pair)obj).first);
            buffer.append("=");
            GDBResponse.doFormat(buffer, ((Pair)obj).second, true);
        } else if (obj instanceof List) {
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'{' : '[');
            }
            boolean first = true;
            for (Object each : (List)obj) {
                if (!first) {
                    buffer.append(',');
                }
                first = false;
                GDBResponse.doFormat(buffer, each, true);
            }
            if (closed) {
                buffer.append(obj instanceof GDBTuple ? (char)'}' : ']');
            }
        } else if (obj instanceof String) {
            buffer.append("\"").append(StringUtil.escapeQuotes((String)((String)obj))).append("\"");
        } else {
            throw new RuntimeException("unknown object: " + obj);
        }
    }

    public String toString() {
        return super.toString();
    }

    public static class ResponseParseException
    extends Exception {
        public ResponseParseException(String text, Throwable cause) {
            super(text, cause);
        }
    }

    public static class StreamRecord
    extends GDBResponse {
        private final Category myCategory;
        private final String myText;

        public StreamRecord(@NotNull Category category, @NotNull String text) {
            this.myCategory = category;
            this.myText = text;
        }

        @NotNull
        public Category getCategory() {
            return this.myCategory;
        }

        @NlsSafe
        @NotNull
        public String getText() {
            return this.myText;
        }

        @Override
        public String toString() {
            return this.myCategory.myPrefix + "\"" + StringUtil.escapeStringCharacters((String)this.myText) + "\"";
        }

        public static enum Category implements RecordCategory
        {
            console("~"),
            target("@"),
            log("&");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @NotNull
            public String getPrefix() {
                return this.myPrefix;
            }

            public String toString() {
                return this.myPrefix;
            }

            static Category forPrefix(@NotNull String prefix) {
                return (Category)RecordCategory.forPrefix((RecordCategory[])Category.values(), (String)prefix);
            }
        }
    }

    public static class AsyncRecord
    extends Record<Category, Type> {
        public AsyncRecord(@NotNull Category category, @NotNull String type, @NotNull GDBTuple resultList) {
            super(category, new Type(type), resultList);
        }

        public static class Type
        implements RecordType {
            @NotNull
            private final String myValue;

            public Type(@NotNull String value) {
                this.myValue = value;
            }

            @NlsSafe
            @NotNull
            public String getValue() {
                return this.myValue;
            }

            public String toString() {
                return this.myValue;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Type name = (Type)o;
                return this.myValue.equals(name.myValue);
            }

            public int hashCode() {
                return this.myValue.hashCode();
            }
        }

        public static enum Category implements RecordCategory
        {
            exec("*"),
            notify("="),
            status("+");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @NotNull
            public String getPrefix() {
                return this.myPrefix;
            }

            public String toString() {
                return this.myPrefix;
            }

            static Category forPrefix(@NotNull String prefix) {
                return (Category)RecordCategory.forPrefix((RecordCategory[])Category.values(), (String)prefix);
            }
        }
    }

    public static class ResultRecord
    extends Record<Category, Type> {
        public ResultRecord(@NotNull Category kind, @NotNull Type type, @NotNull GDBTuple resultList) {
            super(kind, type, resultList);
        }

        public static enum Type implements RecordType
        {
            done,
            running,
            connected,
            error,
            exit,
            stepping,
            continuing,
            result,
            tuple_value,
            list_value,
            str_value;

        }

        public static enum Category implements RecordCategory
        {
            result("^");

            private final String myPrefix;

            private Category(String prefix) {
                this.myPrefix = prefix;
            }

            @Override
            @NlsSafe
            @NotNull
            public String getPrefix() {
                return this.myPrefix;
            }

            public String toString() {
                return this.myPrefix;
            }
        }
    }

    public static abstract class Record<CATEGORY_TYPE extends RecordCategory, TYPE_TYPE extends RecordType>
    extends GDBResponse {
        @NotNull
        private final CATEGORY_TYPE myCategory;
        @NotNull
        private final TYPE_TYPE myType;
        @NotNull
        private final GDBTuple myResultList;

        public Record(@NotNull CATEGORY_TYPE category, @NotNull TYPE_TYPE type, @NotNull GDBTuple resultList) {
            this.myCategory = category;
            this.myType = type;
            this.myResultList = resultList;
        }

        @NotNull
        public CATEGORY_TYPE getCategory() {
            return this.myCategory;
        }

        @NotNull
        public TYPE_TYPE getType() {
            return this.myType;
        }

        @NotNull
        public GDBTuple getResultList() {
            return this.myResultList;
        }

        @Override
        public String toString() {
            return GDBResponse.formatRecord(this.getCategory(), this.getType(), this.myResultList);
        }
    }

    public static interface RecordType {
    }

    public static interface RecordCategory {
        @NlsSafe
        @NotNull
        public String getPrefix();

        @NotNull
        public static <T extends RecordCategory> T forPrefix(T @NotNull [] values, @NotNull String prefix) {
            for (T each : values) {
                if (!each.getPrefix().equals(prefix)) continue;
                return each;
            }
            throw new IllegalArgumentException("Unknown RecordCategory prefix, expected one of " + Arrays.toString(values));
        }
    }

    private static final class Parser {
        String text;

        private Parser(String s) {
            this.text = s;
        }

        public GDBResponse parse() throws ResponseParseException {
            ANTLRInputStream input = new ANTLRInputStream(this.text);
            GdbLexer lexer = new GdbLexer(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            GdbParser parser = new GdbParser(tokens);
            parser.removeErrorListeners();
            parser.addErrorListener(new ANTLRErrorListener(){

                @Override
                public void syntaxError(Recognizer<?, ?> recognizer, @Nullable Object o, int line, int position, String msg, @Nullable RecognitionException e) {
                    throw new RuntimeException("Syntax error: " + msg + " in \"" + text + "\" line " + line + " position " + position);
                }

                @Override
                public void reportAmbiguity(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, boolean b, @org.antlr.v4.runtime.misc.NotNull BitSet bitSet, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.warn("Ambiguity in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                @Override
                public void reportAttemptingFullContext(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, @Nullable BitSet bitSet, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.warn("Attempting full context in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }

                @Override
                public void reportContextSensitivity(@org.antlr.v4.runtime.misc.NotNull org.antlr.v4.runtime.Parser parser, @org.antlr.v4.runtime.misc.NotNull DFA dfa, int startIndex, int stopIndex, int i3, @org.antlr.v4.runtime.misc.NotNull ATNConfigSet atnConfigs) {
                    CidrDebuggerLog.LOG.error("Context sensitivity in \"" + text + "\" started " + startIndex + " stopped " + stopIndex);
                }
            });
            try {
                GdbParser.ResponseContext tree = parser.response();
                GDBResponseVisitor visitor = new GDBResponseVisitor();
                return (GDBResponse)visitor.visit(tree);
            }
            catch (Throwable e) {
                throw new ResponseParseException(e.getMessage(), e);
            }
        }
    }
}

