/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.execution.ExecutionException;
import com.intellij.util.PathUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcessConfigurator;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerUsagesCollector;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.cuda.CudaLLThread;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBBundle;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport;", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcessConfigurator;", "()V", "configure", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "CudaCommands", "intellij.cidr.debugger"})
public final class CudaSupport
implements CidrDebugProcessConfigurator {
    @Override
    public void configure(@NotNull CidrDebugProcess process) {
        DebuggerDriverConfiguration driverConfiguration = process.getRunParameters().getDebuggerDriverConfiguration();
        if (!(driverConfiguration instanceof GDBDriverConfiguration) || Intrinsics.areEqual((Object)PathUtil.getFileName((String)((GDBDriverConfiguration)driverConfiguration).getGDBExecutablePath()), (Object)"cuda-gdb") ^ true) {
            return;
        }
        process.postCommand(new CidrDebugProcess.VoidDebuggerCommand(this, process){
            final /* synthetic */ CudaSupport this$0;
            final /* synthetic */ CidrDebugProcess $process;

            public final void run(@NotNull DebuggerDriver driver) {
                DebuggerDriver debuggerDriver = driver;
                if (debuggerDriver == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.backend.gdb.GDBDriver");
                }
                String output = ((GDBDriver)debuggerDriver).sendSilentRequestAndWaitForDone("show cuda", new Object[0]).getOutput();
                if (StringsKt.contains((CharSequence)output, (CharSequence)"CUDA Debugger", (boolean)true)) {
                    ((GDBDriver)driver).setThreadFrameInfoDriverDelegate(this.this$0.new CudaCommands());
                    CidrDebuggerUsagesCollector.Companion.logCudaDetected(this.$process.getProject());
                }
            }
            {
                this.this$0 = cudaSupport;
                this.$process = cidrDebugProcess;
            }
        });
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J2\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J&\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\r0\u00172\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J?\u0010\u0018\u001a\u0002H\u0019\"\u0004\b\u0000\u0010\u00192\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u00190\u001bH\u0002\u00a2\u0006\u0002\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport$CudaCommands;", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$ThreadFrameInfoDriverDelegate;", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/CudaSupport;)V", "doReadStopPlaceAsync", "Ljava/util/concurrent/CompletableFuture;", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$StopPlace;", "bridge", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;", "driver", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver;", "stopTuple", "Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBTuple;", "evaluate", "Lcom/jetbrains/cidr/execution/debugger/backend/LLValue;", "thread", "Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;", "frame", "Lcom/jetbrains/cidr/execution/debugger/backend/LLFrame;", "expression", "", "language", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$DebuggerLanguage;", "getVariables", "", "switchContextIfNeededAndExecute", "T", "switchedContextExecutor", "Lkotlin/Function0;", "defaultExecutor", "(Lcom/jetbrains/cidr/execution/debugger/backend/gdb/GDBDriver$Bridge;Lcom/jetbrains/cidr/execution/debugger/backend/LLThread;Lkotlin/jvm/functions/Function0;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "intellij.cidr.debugger"})
    private final class CudaCommands
    implements GDBDriver.ThreadFrameInfoDriverDelegate {
        @Override
        @NotNull
        public CompletableFuture<DebuggerDriver.StopPlace> doReadStopPlaceAsync(@NotNull GDBDriver.Bridge bridge, @NotNull GDBDriver driver, @NotNull GDBTuple stopTuple) {
            CompletableFuture<DebuggerDriver.StopPlace> completableFuture;
            GDBTuple cudaFocus = stopTuple.getTupleOrEmpty("CudaFocus");
            if (cudaFocus.isEmpty()) {
                completableFuture = GDBDriver.ThreadFrameInfoDriverDelegate.super.doReadStopPlaceAsync(bridge, driver, stopTuple);
            } else {
                DebuggerDriver.StopPlace stopPlace2;
                try {
                    GDBTuple $this$with = cudaFocus;
                    boolean bl = false;
                    CudaLLThread thread = new CudaLLThread($this$with.getRequiredInt("kernel"), $this$with.getRequiredInt("grid"), $this$with.getRequiredString("blockIdx"), $this$with.getRequiredString("threadIdx"), $this$with.getRequiredInt("device"), $this$with.getRequiredInt("sm"), $this$with.getRequiredInt("warp"), $this$with.getRequiredInt("lane"));
                    GDBTuple frameTuple2 = stopTuple.getRequiredTupleOrThrow("frame", new Supplier(stopTuple){
                        final /* synthetic */ GDBTuple $stopTuple;

                        @NotNull
                        public final ExecutionException get() {
                            return new ExecutionException(GDBBundle.message("error.cannot.read.stop.place", this.$stopTuple));
                        }
                        {
                            this.$stopTuple = gDBTuple;
                        }
                    });
                    LLFrame frame = bridge.doReadFrame(0, frameTuple2);
                    stopPlace2 = new DebuggerDriver.StopPlace(thread, frame);
                }
                catch (ExecutionException e) {
                    CidrDebuggerLog.LOG.error((Throwable)e);
                    stopPlace2 = null;
                }
                DebuggerDriver.StopPlace stopPlace3 = stopPlace2;
                completableFuture = CompletableFuture.completedFuture(stopPlace3);
            }
            return completableFuture;
        }

        @Override
        @NotNull
        public List<LLValue> getVariables(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame) {
            return (List)this.switchContextIfNeededAndExecute(bridge, thread, (Function0)new Function0<List<LLValue>>(bridge, frame){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLFrame $frame;

                @NotNull
                public final List<LLValue> invoke() {
                    return this.$bridge.doGetFrameVariables(-1L, this.$frame.getIndex());
                }
                {
                    this.$bridge = bridge;
                    this.$frame = lLFrame;
                    super(0);
                }
            }, (Function0)new Function0<List<LLValue>>(this, bridge, thread, frame){
                final /* synthetic */ CudaCommands this$0;
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLThread $thread;
                final /* synthetic */ LLFrame $frame;

                @NotNull
                public final List<LLValue> invoke() {
                    return CudaCommands.access$getVariables$s-1970100169(this.this$0, this.$bridge, this.$thread, this.$frame);
                }
                {
                    this.this$0 = cudaCommands;
                    this.$bridge = bridge;
                    this.$thread = lLThread;
                    this.$frame = lLFrame;
                    super(0);
                }
            });
        }

        @Override
        @NotNull
        public LLValue evaluate(@NotNull GDBDriver.Bridge bridge, @NotNull LLThread thread, @NotNull LLFrame frame, @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) {
            return (LLValue)((Object)this.switchContextIfNeededAndExecute(bridge, thread, (Function0)new Function0<LLValue>(bridge, frame, expression, language){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLFrame $frame;
                final /* synthetic */ String $expression;
                final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;

                @NotNull
                public final LLValue invoke() {
                    return this.$bridge.doEvaluate(-1L, this.$frame.getIndex(), this.$expression, this.$language);
                }
                {
                    this.$bridge = bridge;
                    this.$frame = lLFrame;
                    this.$expression = string;
                    this.$language = debuggerLanguage;
                    super(0);
                }
            }, (Function0)new Function0<LLValue>(this, bridge, thread, frame, expression, language){
                final /* synthetic */ CudaCommands this$0;
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLThread $thread;
                final /* synthetic */ LLFrame $frame;
                final /* synthetic */ String $expression;
                final /* synthetic */ DebuggerDriver.DebuggerLanguage $language;

                @NotNull
                public final LLValue invoke() {
                    return CudaCommands.access$evaluate$s-1970100169(this.this$0, this.$bridge, this.$thread, this.$frame, this.$expression, this.$language);
                }
                {
                    this.this$0 = cudaCommands;
                    this.$bridge = bridge;
                    this.$thread = lLThread;
                    this.$frame = lLFrame;
                    this.$expression = string;
                    this.$language = debuggerLanguage;
                    super(0);
                }
            }));
        }

        private final <T> T switchContextIfNeededAndExecute(GDBDriver.Bridge bridge, LLThread thread, Function0<? extends T> switchedContextExecutor, Function0<? extends T> defaultExecutor) {
            return (T)(thread instanceof CudaLLThread ? bridge.executeCommand(new GDBDriver.SuspendedCommand(bridge, thread, switchedContextExecutor){
                final /* synthetic */ GDBDriver.Bridge $bridge;
                final /* synthetic */ LLThread $thread;
                final /* synthetic */ Function0 $switchedContextExecutor;

                @Nullable
                public final T call() {
                    String consoleOutput = this.$bridge.sendSilentRequestAndGetOutput("cuda kernel", new Object[0]);
                    if (StringsKt.startsWith$default((String)consoleOutput, (String)"Focus is not set", (boolean)false, (int)2, null)) {
                        this.$bridge.sendSilentRequestAndGetOutput("cuda kernel " + ((CudaLLThread)this.$thread).getKernel() + " grid " + ((CudaLLThread)this.$thread).getGrid() + " thread " + ((CudaLLThread)this.$thread).getThreadIdx() + " block " + ((CudaLLThread)this.$thread).getBlockIdx() + " device " + ((CudaLLThread)this.$thread).getDevice() + " sm " + ((CudaLLThread)this.$thread).getSm() + " warp " + ((CudaLLThread)this.$thread).getWarp() + " lane " + ((CudaLLThread)this.$thread).getLane(), new Object[0]);
                    }
                    return (T)this.$switchedContextExecutor.invoke();
                }
                {
                    this.$bridge = bridge;
                    this.$thread = lLThread;
                    this.$switchedContextExecutor = function0;
                }
            }) : defaultExecutor.invoke());
        }

        public static final /* synthetic */ List access$getVariables$s-1970100169(CudaCommands $this, GDBDriver.Bridge bridge, LLThread thread, LLFrame frame) {
            return GDBDriver.ThreadFrameInfoDriverDelegate.super.getVariables(bridge, thread, frame);
        }

        public static final /* synthetic */ LLValue access$evaluate$s-1970100169(CudaCommands $this, GDBDriver.Bridge bridge, LLThread thread, LLFrame frame, String expression, DebuggerDriver.DebuggerLanguage language) {
            return GDBDriver.ThreadFrameInfoDriverDelegate.super.evaluate(bridge, thread, frame, expression, language);
        }
    }
}

