/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    private final String myOrigFile;
    private final int myOrigLine;
    @Nullable
    private final String myCondition;

    public LLBreakpoint(int id, @NotNull String file, int line, @Nullable String condition) {
        super(id);
        this.myOrigFile = file;
        this.myOrigLine = line;
        this.myCondition = condition;
    }

    @NotNull
    public String getOrigFile() {
        return this.myOrigFile;
    }

    public int getOrigLine() {
        return this.myOrigLine;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    public String toString() {
        String result2 = "Breakpoint-" + this.getId() + "@" + this.getOrigFile() + ":" + this.getOrigLine();
        if (this.myCondition != null) {
            result2 = result2 + ":condition:" + this.myCondition;
        }
        return result2;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myOrigLine != that.myOrigLine) {
            return false;
        }
        if (!this.myOrigFile.equals(that.myOrigFile)) {
            return false;
        }
        return Objects.equals(this.myCondition, that.myCondition);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myOrigFile.hashCode();
        result2 = 31 * result2 + this.myOrigLine;
        result2 = 31 * result2 + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        return result2;
    }
}

