/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.FileLocationKt;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0017\u0012\b\b\u0001\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0003\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation;", "", "path", "", "line", "", "(Ljava/lang/String;I)V", "getLine", "()I", "getPath", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "Companion", "intellij.cidr.debugger.backend"})
public final class FileLocation {
    @NotNull
    private final String path;
    private final int line;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final String getPath() {
        return this.path;
    }

    public final int getLine() {
        return this.line;
    }

    public FileLocation(@NonNls @NotNull String path, int line) {
        this.path = path;
        this.line = line;
    }

    @NotNull
    public final String component1() {
        return this.path;
    }

    public final int component2() {
        return this.line;
    }

    @NotNull
    public final FileLocation copy(@NonNls @NotNull String path, int line) {
        return new FileLocation(path, line);
    }

    public static /* synthetic */ FileLocation copy$default(FileLocation fileLocation, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = fileLocation.path;
        }
        if ((n2 & 2) != 0) {
            n = fileLocation.line;
        }
        return fileLocation.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "FileLocation(path=" + this.path + ", line=" + this.line + ")";
    }

    public int hashCode() {
        String string = this.path;
        return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.line);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FileLocation)) break block3;
                FileLocation fileLocation = (FileLocation)object;
                if (!Intrinsics.areEqual((Object)this.path, (Object)fileLocation.path) || this.line != fileLocation.line) break block3;
            }
            return true;
        }
        return false;
    }

    @JvmStatic
    @NotNull
    public static final FileLocation fromFileLineNumber(@NonNls @NotNull String path, int lineNumber) {
        return Companion.fromFileLineNumber(path, lineNumber);
    }

    @JvmStatic
    @JvmOverloads
    @Contract(value="_, !null -> !null")
    @Nullable
    public static final FileLocation tryParse(@NonNls @NotNull String locationString, @Nullable FileLocation defaultValue) {
        return Companion.tryParse(locationString, defaultValue);
    }

    @JvmStatic
    @JvmOverloads
    @Contract(value="_, !null -> !null")
    @Nullable
    public static final FileLocation tryParse(@NonNls @NotNull String locationString) {
        return com.jetbrains.cidr.execution.debugger.backend.FileLocation$Companion.tryParse$default(Companion, locationString, null, 2, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J \u0010\t\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\n\u001a\u00020\u00062\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation$Companion;", "", "()V", "fromFileLineNumber", "Lcom/jetbrains/cidr/execution/debugger/backend/FileLocation;", "path", "", "lineNumber", "", "tryParse", "locationString", "defaultValue", "intellij.cidr.debugger.backend"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final FileLocation fromFileLineNumber(@NonNls @NotNull String path, int lineNumber) {
            return new FileLocation(path, lineNumber - 1);
        }

        @JvmStatic
        @JvmOverloads
        @Contract(value="_, !null -> !null")
        @Nullable
        public final FileLocation tryParse(@NonNls @NotNull String locationString, @Nullable FileLocation defaultValue) {
            Matcher matcher = FileLocationKt.access$getLOCATION_PATTERN$p().matcher(locationString);
            if (!matcher.matches()) {
                return defaultValue;
            }
            String path = matcher.group(1);
            String string = matcher.group(2);
            int lineNumber = Integer.parseInt(string);
            return this.fromFileLineNumber(path, lineNumber);
        }

        public static /* synthetic */ FileLocation tryParse$default(Companion companion, String string, FileLocation fileLocation, int n, Object object) {
            if ((n & 2) != 0) {
                fileLocation = null;
            }
            return companion.tryParse(string, fileLocation);
        }

        @JvmStatic
        @JvmOverloads
        @Contract(value="_, !null -> !null")
        @Nullable
        public final FileLocation tryParse(@NonNls @NotNull String locationString) {
            return com.jetbrains.cidr.execution.debugger.backend.FileLocation$Companion.tryParse$default(this, locationString, null, 2, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

