/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DebuggerSourceFileHash {
    private final Type myType;
    private final String myHash;

    public DebuggerSourceFileHash(@NotNull Type type, @NotNull String hash) {
        this.myType = type;
        this.myHash = hash;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    @NotNull
    public String getHash() {
        return this.myHash;
    }

    public String toString() {
        return String.format("%s: %s", new Object[]{this.myType, this.myHash});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DebuggerSourceFileHash rhs = (DebuggerSourceFileHash)obj;
        if (!Objects.equals((Object)this.myType, (Object)rhs.myType)) {
            return false;
        }
        return Objects.equals(this.myHash, rhs.myHash);
    }

    public int hashCode() {
        return 17 * this.myType.hashCode() + this.myHash.hashCode();
    }

    public static enum Type {
        MD5,
        SHA1,
        SHA256;

    }
}

