/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAware;
import com.intellij.ui.content.Content;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.MemoryViewPanel;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.GotoAddressPanel;
import javax.swing.JComponent;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/ShowInMemoryViewAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isEnabled", "", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "nodeName", "", "update", "intellij.cidr.debugger"})
public final class ShowInMemoryViewAction
extends XDebuggerTreeActionBase
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        XDebugSession currentSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        XDebugSession xDebugSession = currentSession;
        e.getPresentation().setVisible((xDebugSession != null ? xDebugSession.getDebugProcess() : null) instanceof CidrDebugProcess);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XValue xValue = (XValue)node.getValueContainer();
        if (!(xValue instanceof CidrPhysicalValue)) {
            xValue = null;
        }
        CidrPhysicalValue cidrPhysicalValue = (CidrPhysicalValue)xValue;
        if (cidrPhysicalValue == null) {
            return false;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return false;
        }
        LLValueData data = value.getPreparedVarData();
        return !data.isPointer() || data.isValidPointer();
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        XDebugSessionTab sessionTab;
        XValue xValue = (XValue)node.getValueContainer();
        if (!(xValue instanceof CidrPhysicalValue)) {
            xValue = null;
        }
        CidrPhysicalValue cidrPhysicalValue = (CidrPhysicalValue)xValue;
        if (cidrPhysicalValue == null) {
            return;
        }
        CidrPhysicalValue value = cidrPhysicalValue;
        if (!value.isValueDataAvailable()) {
            return;
        }
        CidrDebugProcess debugProcess = value.getProcess();
        MemoryViewPanel memoryViewPanel = debugProcess.getHexdumpViewPanel();
        if (memoryViewPanel == null) {
            return;
        }
        MemoryViewPanel memoryViewPanel2 = memoryViewPanel;
        GotoAddressPanel gotoAddressPanel = memoryViewPanel2.getGotoAddressPanel();
        XDebugSession debugSession = debugProcess.getSession();
        if (debugSession instanceof XDebugSessionImpl && (sessionTab = ((XDebugSessionImpl)debugSession).getSessionTab()) != null) {
            Content memoryViewContent = sessionTab.getUi().findContent("DEBUGGER_MEMORY_VIEW");
            JComponent memoryViewComponent = memoryViewPanel2.getPreferredFocusableComponent();
            sessionTab.getUi().selectAndFocus(memoryViewContent, true, true).doWhenDone(new Runnable(memoryViewComponent){
                final /* synthetic */ JComponent $memoryViewComponent;

                public final void run() {
                    this.$memoryViewComponent.requestFocus();
                }
                {
                    this.$memoryViewComponent = jComponent;
                }
            });
        }
        gotoAddressPanel.navigateToValue(value, true);
    }
}

