/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerUtilImpl;
import com.intellij.xdebugger.impl.actions.DebuggerActionHandler;
import com.intellij.xdebugger.impl.actions.XDebuggerActionBase;
import com.intellij.xdebugger.impl.actions.XDebuggerSuspendedActionHandler;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0014\u00a8\u0006\n"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerActionBase;", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getHandler", "Lcom/intellij/xdebugger/impl/actions/DebuggerActionHandler;", "debuggerSupport", "Lcom/intellij/xdebugger/impl/DebuggerSupport;", "ActionHandler", "intellij.cidr.debugger"})
public final class CidrJumpToLineAction
extends XDebuggerActionBase {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    @NotNull
    protected DebuggerActionHandler getHandler(@NotNull DebuggerSupport debuggerSupport) {
        return (DebuggerActionHandler)ActionHandler.Companion.getINSTANCE();
    }

    public CidrJumpToLineAction() {
        this.getTemplatePresentation().setText(CidrDebuggerBundle.message("debug.jumpToLine.text", new Object[0]));
        this.getTemplatePresentation().setDescription(CidrDebuggerBundle.message("debug.jumpToLine.tooltip", new Object[0]));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014J\u001a\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016J\u001a\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0014\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler;", "Lcom/intellij/xdebugger/impl/actions/XDebuggerSuspendedActionHandler;", "()V", "getDebugProcess", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "isEnabled", "", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "isHidden", "project", "Lcom/intellij/openapi/project/Project;", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "", "Companion", "intellij.cidr.debugger"})
    private static final class ActionHandler
    extends XDebuggerSuspendedActionHandler {
        @NotNull
        private static final ActionHandler INSTANCE;
        @NotNull
        public static final Companion Companion;

        protected boolean isEnabled(@NotNull XDebugSession session, @Nullable DataContext dataContext) {
            CidrDebugProcess cidrDebugProcess = this.getDebugProcess(session);
            if (cidrDebugProcess == null) {
                return false;
            }
            CidrDebugProcess process = cidrDebugProcess;
            return super.isEnabled(session, dataContext) && process.supportsJumpToLine() && XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext) != null;
        }

        public boolean isHidden(@NotNull Project project, @Nullable AnActionEvent event) {
            XDebugSession xDebugSession = XDebuggerManager.getInstance((Project)project).getCurrentSession();
            if (xDebugSession == null) {
                return true;
            }
            XDebugSession session = xDebugSession;
            return this.getDebugProcess(session) == null || super.isHidden(project, event);
        }

        protected void perform(@NotNull XDebugSession session, @Nullable DataContext dataContext) {
            XSourcePosition xSourcePosition = XDebuggerUtilImpl.getCaretPosition((Project)session.getProject(), (DataContext)dataContext);
            if (xSourcePosition == null) {
                return;
            }
            XSourcePosition position = xSourcePosition;
            XDebugProcess xDebugProcess = session.getDebugProcess();
            if (!(xDebugProcess instanceof CidrDebugProcess)) {
                xDebugProcess = null;
            }
            CidrDebugProcess cidrDebugProcess = (CidrDebugProcess)xDebugProcess;
            if (cidrDebugProcess == null) {
                return;
            }
            CidrDebugProcess process = cidrDebugProcess;
            XStackFrame xStackFrame = session.getCurrentStackFrame();
            if (!(xStackFrame instanceof CidrStackFrame)) {
                xStackFrame = null;
            }
            CidrStackFrame cidrStackFrame = (CidrStackFrame)xStackFrame;
            if (cidrStackFrame == null) {
                return;
            }
            CidrStackFrame stackFrame = cidrStackFrame;
            process.jumpToLine(stackFrame.getThread(), position.getFile(), position.getLine());
        }

        private final CidrDebugProcess getDebugProcess(XDebugSession session) {
            XDebugProcess xDebugProcess = session.getDebugProcess();
            if (!(xDebugProcess instanceof CidrDebugProcess)) {
                xDebugProcess = null;
            }
            return (CidrDebugProcess)xDebugProcess;
        }

        static {
            Companion = new Companion(null);
            INSTANCE = new ActionHandler();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler$Companion;", "", "()V", "INSTANCE", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler;", "getINSTANCE", "()Lcom/jetbrains/cidr/execution/debugger/actions/CidrJumpToLineAction$ActionHandler;", "intellij.cidr.debugger"})
        public static final class Companion {
            @NotNull
            public final ActionHandler getINSTANCE() {
                return INSTANCE;
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

