/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionPromoter;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrCopyAddressAction
extends XDebuggerTreeActionBase
implements ActionPromoter {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        XValue value = CidrCopyAddressAction.getSelectedValue((DataContext)e.getDataContext());
        e.getPresentation().setVisible(value instanceof CidrValue);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        if (!super.isEnabled(node, e)) {
            return false;
        }
        XValue value = (XValue)node.getValueContainer();
        if (!(value instanceof CidrValue)) {
            return false;
        }
        if (e.getInputEvent() instanceof KeyEvent) {
            return true;
        }
        return CidrCopyAddressAction.getShownAddress(node) != null;
    }

    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        String addressOrEmptyString = StringUtil.notNullize((String)CidrCopyAddressAction.getShownAddress(node));
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(addressOrEmptyString));
    }

    @Nullable
    private static String getShownAddress(@NotNull XValueNodeImpl node) {
        XValue value = (XValue)node.getValueContainer();
        if (!(value instanceof CidrPhysicalValue)) {
            return null;
        }
        return ((CidrPhysicalValue)value).getShownAddress();
    }

    @Nullable
    public List<AnAction> promote(@NotNull List<? extends AnAction> actions, @NotNull DataContext context2) {
        return List.of(this);
    }
}

