/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.util.ObjectUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrWatchpointUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrAddWatchpointAction
extends XDebuggerTreeActionBase {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        CidrDebugProcess process = CidrAddWatchpointAction.getDebugProcess(e);
        e.getPresentation().setVisible(process != null);
    }

    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        CidrDebugProcess process = CidrAddWatchpointAction.getDebugProcess(e);
        if (process == null || !process.supportsWatchpoints()) {
            return false;
        }
        XValue value = (XValue)node.getValueContainer();
        return value instanceof CidrLocalValue || value instanceof CidrMemberValue;
    }

    @Nullable
    private static CidrDebugProcess getDebugProcess(@NotNull AnActionEvent e) {
        XDebugSession currentSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        XDebugProcess process = currentSession == null ? null : currentSession.getDebugProcess();
        return (CidrDebugProcess)ObjectUtils.tryCast((Object)process, CidrDebugProcess.class);
    }

    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        XValue valueContainer = (XValue)node.getValueContainer();
        XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint = CidrWatchpointUtil.addWatchpoint(valueContainer, LLWatchpoint.AccessType.WRITE, LLWatchpoint.Lifetime.STACK_FRAME);
        if (breakpoint != null) {
            CidrWatchpointUtil.showWatchpointEditor(node, breakpoint, CidrAddWatchpointAction.getEventProject((AnActionEvent)e));
        }
    }
}

